/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.InputStream;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.lang.SystemUtils;

public class VersionDescription {
    public static final String RESOURCE_NAME = "GemFireVersion.properties";
    public static final String PRODUCT_NAME = "Product-Name";
    public static final String PRODUCT_VERSION = "Product-Version";
    public static final String SOURCE_DATE = "Source-Date";
    public static final String SOURCE_REVISION = "Source-Revision";
    public static final String SOURCE_REPOSITORY = "Source-Repository";
    public static final String BUILD_DATE = "Build-Date";
    public static final String BUILD_ID = "Build-Id";
    public static final String BUILD_PLATFORM = "Build-Platform";
    public static final String BUILD_JAVA_VERSION = "Build-Java-Version";
    public static final String NATIVE_VERSION = "Native version";
    public static final String RUNNING_ON = "Running on";
    private final Properties description;
    private final Optional<String> error;

    public VersionDescription(String name) {
        InputStream is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), name);
        if (is == null) {
            this.error = Optional.of(String.format("<Could not find resource org/apache/geode/internal/%s>", name));
            this.description = null;
            return;
        }
        this.description = new Properties();
        try {
            this.description.load(is);
        }
        catch (Exception ex) {
            this.error = Optional.of(String.format("<Could not read properties from resource org/apache/geode/internal/%s because: %s>", name, ex));
            return;
        }
        this.error = this.validate(this.description);
    }

    public String getProperty(String key) {
        return this.error.orElseGet(() -> this.description.getProperty(key));
    }

    void print(PrintWriter pw) {
        if (this.error.isPresent()) {
            pw.println(this.error.get());
        } else {
            for (Map.Entry<Object, Object> props : new TreeMap<Object, Object>(this.description).entrySet()) {
                pw.println(props.getKey() + ": " + props.getValue());
            }
        }
        pw.println(VersionDescription.getRunningOnInfo());
    }

    private static String getRunningOnInfo() {
        String line = VersionDescription.getLocalHost() + ", " + Runtime.getRuntime().availableProcessors() + " cpu(s), " + SystemUtils.getOsArchitecture() + ' ' + SystemUtils.getOsName() + ' ' + SystemUtils.getOsVersion() + ' ';
        return String.format("Running on: %s", line);
    }

    private static String getLocalHost() {
        try {
            return LocalHostUtil.getLocalHostString();
        }
        catch (UnknownHostException e) {
            return e.getMessage();
        }
    }

    private Optional<String> validate(Properties props) {
        if (props.get(PRODUCT_NAME) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", PRODUCT_NAME, RESOURCE_NAME));
        }
        if (props.get(PRODUCT_VERSION) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", PRODUCT_VERSION, RESOURCE_NAME));
        }
        if (props.get(SOURCE_DATE) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", SOURCE_DATE, RESOURCE_NAME));
        }
        if (props.get(SOURCE_REVISION) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", SOURCE_REVISION, RESOURCE_NAME));
        }
        if (props.get(SOURCE_REPOSITORY) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", SOURCE_REPOSITORY, RESOURCE_NAME));
        }
        if (props.get(BUILD_DATE) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", BUILD_DATE, RESOURCE_NAME));
        }
        if (props.get(BUILD_ID) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", BUILD_ID, RESOURCE_NAME));
        }
        if (props.get(BUILD_PLATFORM) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", BUILD_PLATFORM, RESOURCE_NAME));
        }
        if (props.get(BUILD_JAVA_VERSION) == null) {
            return Optional.of(String.format("<Missing property %s from resource org/apache/geode/internal/%s>", BUILD_JAVA_VERSION, RESOURCE_NAME));
        }
        return Optional.empty();
    }
}

