/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.geode.CancelCriterion;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.ResourceManager;
import org.apache.geode.cache.control.RestoreRedundancyOperation;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.FilterByPath;
import org.apache.geode.internal.cache.control.HeapMemoryMonitor;
import org.apache.geode.internal.cache.control.MemoryMonitor;
import org.apache.geode.internal.cache.control.OffHeapMemoryMonitor;
import org.apache.geode.internal.cache.control.RebalanceOperationImpl;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.control.ResourceEvent;
import org.apache.geode.internal.cache.control.ResourceListener;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.control.ResourceMonitor;
import org.apache.geode.internal.cache.control.RestoreRedundancyOperationImpl;
import org.apache.geode.internal.cache.control.TenuredHeapConsumptionMonitor;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.cache.partitioned.SizedBasedLoadProbe;
import org.apache.geode.internal.logging.CoreLoggingExecutors;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.runtime.RestoreRedundancyResults;
import org.apache.logging.log4j.Logger;

public class InternalResourceManager
implements ResourceManager {
    private static final Logger logger = LogService.getLogger();
    final int MAX_RESOURCE_MANAGER_EXE_THREADS = Integer.getInteger("gemfire.resource.manager.threads", 1);
    private final Collection<CompletableFuture<Void>> startupTasks = new ArrayList<CompletableFuture<Void>>();
    private Map<ResourceType, Set<ResourceListener>> listeners = new HashMap<ResourceType, Set<ResourceListener>>();
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService notifyExecutor;
    private final Map<RebalanceOperation, Boolean> inProgressRebalanceOperations = new ConcurrentHashMap<RebalanceOperation, Boolean>();
    private final Map<CompletableFuture<RestoreRedundancyResults>, Boolean> inProgressRedundancyOperations = new ConcurrentHashMap<CompletableFuture<RestoreRedundancyResults>, Boolean>();
    final InternalCache cache;
    private LoadProbe loadProbe;
    private final ResourceManagerStats stats;
    private final ResourceAdvisor resourceAdvisor;
    private boolean closed = true;
    private final Map<ResourceType, ResourceMonitor> resourceMonitors;
    @MutableForTesting
    private static ResourceObserver observer = new ResourceObserverAdapter();
    private static final String PR_LOAD_PROBE_CLASS = System.getProperty("gemfire.ResourceManager.PR_LOAD_PROBE_CLASS", SizedBasedLoadProbe.class.getName());

    public static InternalResourceManager getInternalResourceManager(Cache cache) {
        return (InternalResourceManager)cache.getResourceManager();
    }

    public static InternalResourceManager createResourceManager(InternalCache cache) {
        return new InternalResourceManager(cache);
    }

    private InternalResourceManager(InternalCache cache) {
        this.cache = cache;
        this.resourceAdvisor = (ResourceAdvisor)cache.getDistributionAdvisor();
        this.stats = new ResourceManagerStats(cache.getDistributedSystem());
        this.scheduledExecutor = LoggingExecutors.newScheduledThreadPool((String)"ResourceManagerRecoveryThread ", (int)this.MAX_RESOURCE_MANAGER_EXE_THREADS);
        try {
            Class<?> loadProbeClass = ClassPathLoader.getLatest().forName(PR_LOAD_PROBE_CLASS);
            this.loadProbe = (LoadProbe)loadProbeClass.newInstance();
        }
        catch (Exception e) {
            throw new InternalGemFireError("Unable to instantiate " + PR_LOAD_PROBE_CLASS, e);
        }
        this.notifyExecutor = CoreLoggingExecutors.newSerialThreadPoolWithFeedStatistics("Notification Handler", thread -> thread.setPriority(10), null, this.stats.getResourceEventPoolStatHelper(), this.getThreadMonitorObj(), 0, this.stats.getResourceEventQueueStatHelper());
        HashMap<ResourceType, MemoryMonitor> tempMonitors = new HashMap<ResourceType, MemoryMonitor>();
        tempMonitors.put(ResourceType.HEAP_MEMORY, new HeapMemoryMonitor(this, cache, this.stats, new TenuredHeapConsumptionMonitor()));
        tempMonitors.put(ResourceType.OFFHEAP_MEMORY, new OffHeapMemoryMonitor(this, cache, cache.getOffHeapStore(), this.stats));
        this.resourceMonitors = Collections.unmodifiableMap(tempMonitors);
        for (ResourceType resourceType : new ResourceType[]{ResourceType.HEAP_MEMORY, ResourceType.OFFHEAP_MEMORY}) {
            CopyOnWriteArraySet emptySet = new CopyOnWriteArraySet();
            this.listeners.put(resourceType, emptySet);
        }
        this.closed = false;
    }

    public void close() {
        for (ResourceMonitor monitor : this.resourceMonitors.values()) {
            monitor.stopMonitoring();
        }
        this.stopExecutor(this.scheduledExecutor);
        this.stopExecutor(this.notifyExecutor);
        this.stats.close();
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }

    public void fillInProfile(DistributionAdvisor.Profile profile) {
        assert (profile instanceof ResourceAdvisor.ResourceManagerProfile);
        for (ResourceMonitor monitor : this.resourceMonitors.values()) {
            monitor.fillInProfile((ResourceAdvisor.ResourceManagerProfile)profile);
        }
    }

    public void addResourceListener(ResourceListener listener) {
        this.addResourceListener(ResourceType.ALL, listener);
    }

    public void addResourceListener(ResourceType resourceType, ResourceListener listener) {
        for (Map.Entry<ResourceType, Set<ResourceListener>> mapEntry : this.listeners.entrySet()) {
            if ((mapEntry.getKey().id & resourceType.id) == 0) continue;
            mapEntry.getValue().add(listener);
        }
    }

    public void removeResourceListener(ResourceListener listener) {
        this.removeResourceListener(ResourceType.ALL, listener);
    }

    public void removeResourceListener(ResourceType resourceType, ResourceListener listener) {
        for (Map.Entry<ResourceType, Set<ResourceListener>> mapEntry : this.listeners.entrySet()) {
            if ((mapEntry.getKey().id & resourceType.id) == 0) continue;
            mapEntry.getValue().remove(listener);
        }
    }

    public Set<ResourceListener> getResourceListeners(ResourceType resourceType) {
        return this.listeners.get((Object)resourceType);
    }

    public void deliverEventFromRemote(final ResourceEvent event) {
        assert (!event.isLocal());
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("New remote event to deliver for member " + event.getMember() + ": event=" + event);
        }
        if (this.cache.getLogger().fineEnabled()) {
            this.cache.getLogger().fine("Remote event to deliver for member " + event.getMember() + ":" + event);
        }
        this.runWithNotifyExecutor(new Runnable(){

            @Override
            public void run() {
                InternalResourceManager.this.deliverLocalEvent(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverLocalEvent(ResourceEvent event) {
        Map<ResourceType, Set<ResourceListener>> map = this.listeners;
        synchronized (map) {
            this.resourceMonitors.get((Object)event.getType()).notifyListeners(this.listeners.get((Object)event.getType()), event);
        }
        this.stats.incResourceEventsDelivered();
    }

    public HeapMemoryMonitor getHeapMonitor() {
        return (HeapMemoryMonitor)this.resourceMonitors.get((Object)ResourceType.HEAP_MEMORY);
    }

    public OffHeapMemoryMonitor getOffHeapMonitor() {
        return (OffHeapMemoryMonitor)this.resourceMonitors.get((Object)ResourceType.OFFHEAP_MEMORY);
    }

    public MemoryMonitor getMemoryMonitor(boolean offheap) {
        if (offheap) {
            return this.getOffHeapMonitor();
        }
        return this.getHeapMonitor();
    }

    void runWithNotifyExecutor(Runnable runnable) {
        block2: {
            try {
                this.notifyExecutor.execute(runnable);
            }
            catch (RejectedExecutionException ignore) {
                if (this.isClosed()) break block2;
                this.cache.getLogger().warning("No memory events will be delivered because of RejectedExecutionException");
            }
        }
    }

    @Override
    public RebalanceFactory createRebalanceFactory() {
        return new RebalanceFactoryImpl();
    }

    @Override
    public Set<RebalanceOperation> getRebalanceOperations() {
        return Collections.unmodifiableSet(this.inProgressRebalanceOperations.keySet());
    }

    void addInProgressRebalance(RebalanceOperation op) {
        this.inProgressRebalanceOperations.put(op, Boolean.TRUE);
    }

    void removeInProgressRebalance(RebalanceOperation op) {
        this.inProgressRebalanceOperations.remove(op);
    }

    @Override
    public RestoreRedundancyOperation createRestoreRedundancyOperation() {
        return new RestoreRedundancyOperationImpl(this.cache);
    }

    @Override
    public Set<CompletableFuture<RestoreRedundancyResults>> getRestoreRedundancyFutures() {
        return Collections.unmodifiableSet(this.inProgressRedundancyOperations.keySet());
    }

    void addInProgressRestoreRedundancy(CompletableFuture<RestoreRedundancyResults> completableFuture) {
        this.inProgressRedundancyOperations.put(completableFuture, Boolean.TRUE);
    }

    void removeInProgressRestoreRedundancy(CompletableFuture<RestoreRedundancyResults> completableFuture) {
        this.inProgressRedundancyOperations.remove(completableFuture);
    }

    void stopExecutor(ExecutorService executor) {
        if (executor == null) {
            return;
        }
        executor.shutdown();
        int secToWait = Integer.getInteger("gemfire.prrecovery-close-timeout", 5);
        try {
            executor.awaitTermination(secToWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            logger.debug("Failed in interrupting the Resource Manager Thread due to interrupt");
        }
        if (!executor.isTerminated()) {
            logger.warn("Failed to stop resource manager threads in {} seconds, forcing shutdown", (Object)secToWait);
            List<Runnable> remainingTasks = executor.shutdownNow();
            remainingTasks.forEach(runnable -> {
                if (runnable instanceof Future) {
                    ((Future)((Object)runnable)).cancel(true);
                }
            });
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.scheduledExecutor;
    }

    public ResourceManagerStats getStats() {
        return this.stats;
    }

    public static void setResourceObserver(ResourceObserver observer) {
        if (observer == null) {
            observer = new ResourceObserverAdapter();
        }
        InternalResourceManager.observer = observer;
    }

    public static ResourceObserver getResourceObserver() {
        return observer;
    }

    public CancelCriterion getCancelCriterion() {
        return this.cache.getCancelCriterion();
    }

    public ResourceAdvisor getResourceAdvisor() {
        return this.resourceAdvisor;
    }

    public LoadProbe getLoadProbe() {
        return this.loadProbe;
    }

    public LoadProbe setLoadProbe(LoadProbe probe) {
        LoadProbe old = this.loadProbe;
        this.loadProbe = probe;
        return old;
    }

    @Override
    public void setCriticalOffHeapPercentage(float offHeapPercentage) {
        this.getOffHeapMonitor().setCriticalThreshold(offHeapPercentage);
    }

    @Override
    public float getCriticalOffHeapPercentage() {
        return this.getOffHeapMonitor().getCriticalThreshold();
    }

    @Override
    public void setEvictionOffHeapPercentage(float offHeapPercentage) {
        this.getOffHeapMonitor().setEvictionThreshold(offHeapPercentage);
    }

    @Override
    public float getEvictionOffHeapPercentage() {
        return this.getOffHeapMonitor().getEvictionThreshold();
    }

    @Override
    public void setCriticalHeapPercentage(float heapPercentage) {
        this.getHeapMonitor().setCriticalThreshold(heapPercentage);
    }

    @Override
    public float getCriticalHeapPercentage() {
        return this.getHeapMonitor().getCriticalThreshold();
    }

    @Override
    public void setEvictionHeapPercentage(float heapPercentage) {
        this.getHeapMonitor().setEvictionThreshold(heapPercentage);
    }

    @Override
    public float getEvictionHeapPercentage() {
        return this.getHeapMonitor().getEvictionThreshold();
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.cache.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }

    public void addStartupTask(CompletableFuture<Void> startupTask) {
        Objects.requireNonNull(startupTask);
        this.startupTasks.add(startupTask);
    }

    public CompletableFuture<Void> allOfStartupTasks() {
        CompletableFuture[] completableFutures = this.startupTasks.toArray(new CompletableFuture[0]);
        this.startupTasks.clear();
        return CompletableFuture.allOf(completableFutures);
    }

    public static class ResourceObserverAdapter
    implements ResourceObserver {
        @Override
        public void rebalancingFinished(Region region) {
            this.rebalancingOrRecoveryFinished(region);
        }

        @Override
        public void rebalancingStarted(Region region) {
            this.rebalancingOrRecoveryStarted(region);
        }

        @Override
        public void recoveryFinished(Region region) {
            this.rebalancingOrRecoveryFinished(region);
        }

        @Override
        public void recoveryStarted(Region region) {
            this.rebalancingOrRecoveryStarted(region);
        }

        public void rebalancingOrRecoveryStarted(Region region) {
        }

        public void rebalancingOrRecoveryFinished(Region region) {
        }

        @Override
        public void recoveryConflated(PartitionedRegion region) {
        }

        @Override
        public void movingBucket(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        }

        @Override
        public void movingPrimary(Region region, int bucketId, DistributedMember source, DistributedMember target) {
        }
    }

    public static interface ResourceObserver {
        public void rebalancingStarted(Region var1);

        public void rebalancingFinished(Region var1);

        public void recoveryStarted(Region var1);

        public void recoveryFinished(Region var1);

        public void recoveryConflated(PartitionedRegion var1);

        public void movingBucket(Region var1, int var2, DistributedMember var3, DistributedMember var4);

        public void movingPrimary(Region var1, int var2, DistributedMember var3, DistributedMember var4);
    }

    class RebalanceFactoryImpl
    implements RebalanceFactory {
        private Set<String> includedRegions;
        private Set<String> excludedRegions;

        RebalanceFactoryImpl() {
        }

        @Override
        public RebalanceOperation simulate() {
            FilterByPath filter = new FilterByPath(this.includedRegions, this.excludedRegions);
            RebalanceOperationImpl op = new RebalanceOperationImpl(InternalResourceManager.this.cache, true, filter);
            op.start();
            return op;
        }

        @Override
        public RebalanceOperation start() {
            FilterByPath filter = new FilterByPath(this.includedRegions, this.excludedRegions);
            RebalanceOperationImpl op = new RebalanceOperationImpl(InternalResourceManager.this.cache, false, filter);
            op.start();
            return op;
        }

        @Override
        public RebalanceFactory excludeRegions(Set<String> regions) {
            this.excludedRegions = regions;
            return this;
        }

        @Override
        public RebalanceFactory includeRegions(Set<String> regions) {
            this.includedRegions = regions;
            return this;
        }
    }

    public static enum ResourceType {
        HEAP_MEMORY(1),
        OFFHEAP_MEMORY(2),
        MEMORY(3),
        ALL(-1);

        final int id;

        private ResourceType(int id) {
            this.id = id;
        }
    }
}

