/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.Collection;
import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.set.RedisSetCommands;
import org.apache.geode.redis.internal.executor.set.SetExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SPopExecutor
extends SetExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        boolean isCountPassed = false;
        int popCount = 1;
        if (commandElems.size() == 3) {
            isCountPassed = true;
            popCount = Integer.parseInt(new String(commandElems.get(2)));
        }
        RedisKey key = command.getKey();
        RedisSetCommands redisSetCommands = this.createRedisSetCommands(context);
        Collection<ByteArrayWrapper> popped = redisSetCommands.spop(key, popCount);
        if (popped.isEmpty() && !isCountPassed) {
            return RedisResponse.nil();
        }
        if (!isCountPassed) {
            return RedisResponse.bulkString(popped.iterator().next().toString());
        }
        return RedisResponse.array(popped);
    }
}

