/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class IncrByFloatExecutor
extends StringExecutor {
    private static final int INCREMENT_INDEX = 2;
    private static final Pattern invalidArgs = Pattern.compile("[+-]?(inf|infinity)", 2);

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        Pair<BigDecimal, RedisResponse> validated = IncrByFloatExecutor.validateIncrByFloatArgument(commandElems.get(2));
        if (validated.getRight() != null) {
            return (RedisResponse)validated.getRight();
        }
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        BigDecimal result = stringCommands.incrbyfloat(key, (BigDecimal)validated.getLeft());
        return RedisResponse.bigDecimal(result);
    }

    public static Pair<BigDecimal, RedisResponse> validateIncrByFloatArgument(byte[] incrArray) {
        BigDecimal increment;
        String doub = Coder.bytesToString(incrArray).toLowerCase();
        if (invalidArgs.matcher(doub).matches()) {
            return Pair.of(null, (Object)RedisResponse.error("increment would produce NaN or Infinity"));
        }
        try {
            increment = Coder.bytesToBigDecimal(incrArray);
        }
        catch (NumberFormatException e) {
            return Pair.of(null, (Object)RedisResponse.error("value is not a valid float"));
        }
        return Pair.of((Object)increment, null);
    }
}

