/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class SetOptions
implements DataSerializableFixedID {
    private Exists exists;
    private long expirationMillis;
    private boolean keepTTL;

    public SetOptions(Exists exists, long expiration, boolean keepTTL) {
        this.exists = exists;
        this.expirationMillis = expiration;
        this.keepTTL = keepTTL;
    }

    public SetOptions() {
    }

    public boolean isNX() {
        return this.exists.equals((Object)Exists.NX);
    }

    public boolean isXX() {
        return this.exists.equals((Object)Exists.XX);
    }

    public Exists getExists() {
        return this.exists;
    }

    public long getExpiration() {
        return this.expirationMillis;
    }

    public boolean isKeepTTL() {
        return this.keepTTL;
    }

    public int getDSFID() {
        return 2190;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeEnum((Enum)this.exists, (DataOutput)out);
        out.writeLong(this.expirationMillis);
        out.writeBoolean(this.keepTTL);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException {
        this.exists = (Exists)DataSerializer.readEnum(Exists.class, (DataInput)in);
        this.expirationMillis = in.readLong();
        this.keepTTL = in.readBoolean();
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public static enum Exists {
        NONE,
        NX,
        XX;

    }
}

