/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.control.SerializableRestoreRedundancyResultsImpl;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.operation.RebalanceOperationPerformer;
import org.apache.geode.management.internal.operation.RestoreRedundancyPerformer;
import org.apache.geode.management.operation.RestoreRedundancyRequest;
import org.apache.geode.management.runtime.RestoreRedundancyResults;

public class RedundancyCommand
extends GfshCommand {
    public static final String NO_MEMBERS_SECTION = "no-members";
    public static final String NO_MEMBERS_HEADER = "No partitioned regions were found.";
    public static final String NO_MEMBERS_FOR_REGION_SECTION = "no-members-for-region";
    public static final String NO_MEMBERS_FOR_REGION_HEADER = "No members hosting the following regions were found: ";
    public static final String ERROR_SECTION = "errors";
    public static final String ERROR_SECTION_HEADER = "The following errors or exceptions were encountered: ";
    public static final String SUMMARY_SECTION = "summary-section";
    public static final String ZERO_REDUNDANT_COPIES = "Number of regions with zero redundant copies = ";
    public static final String PARTIALLY_SATISFIED_REDUNDANCY = "Number of regions with partially satisfied redundancy = ";
    public static final String FULLY_SATISFIED_REDUNDANCY = "Number of regions with fully satisfied redundancy = ";
    public static final String ZERO_REDUNDANCY_SECTION = "zero-redundancy";
    public static final String UNDER_REDUNDANCY_SECTION = "under-redundancy";
    public static final String SATISFIED_REDUNDANCY_SECTION = "satisfied-redundancy";
    public static final String PRIMARIES_INFO_SECTION = "primaries-info";
    public static final KnownVersion ADDED_VERSION = KnownVersion.GEODE_1_13_0;
    public static final String INDENT = "  ";

    ResultModel execute(String[] includeRegions, String[] excludeRegions, boolean reassignPrimaries, boolean isStatusCommand) {
        RestoreRedundancyPerformer performer = new RestoreRedundancyPerformer();
        RestoreRedundancyRequest request = new RestoreRedundancyRequest();
        if (includeRegions != null) {
            request.setIncludeRegions(Arrays.asList(includeRegions));
        }
        if (excludeRegions != null) {
            request.setExcludeRegions(Arrays.asList(excludeRegions));
        }
        request.setReassignPrimaries(reassignPrimaries);
        RestoreRedundancyResults results = performer.perform(this.getCache(), request, isStatusCommand);
        return this.buildResultModelFromFunctionResults(results, isStatusCommand);
    }

    List<DistributedMember> filterViableMembers(RebalanceOperationPerformer.MemberPRInfo prInfo) {
        return prInfo.dsMemberList.stream().map(InternalDistributedMember.class::cast).filter(member -> member.getVersion().compareTo((Object)ADDED_VERSION) >= 0).collect(Collectors.toList());
    }

    void populateLists(List<RebalanceOperationPerformer.MemberPRInfo> membersForEachRegion, List<String> noMemberRegions, String[] includeRegions, String[] excludeRegions) {
        if (includeRegions == null) {
            ArrayList<String> excludedRegionList = excludeRegions != null ? Arrays.asList(excludeRegions) : new ArrayList<String>();
            List<RebalanceOperationPerformer.MemberPRInfo> memberRegionList = this.getMembersForEachRegion(excludedRegionList);
            membersForEachRegion.addAll(memberRegionList);
        } else {
            for (String regionName : includeRegions) {
                DistributedMember memberForRegion = this.getOneMemberForRegion(regionName);
                if (memberForRegion == null) {
                    noMemberRegions.add(regionName);
                    continue;
                }
                RebalanceOperationPerformer.MemberPRInfo memberPRInfo = new RebalanceOperationPerformer.MemberPRInfo();
                memberPRInfo.region = regionName;
                memberPRInfo.dsMemberList.add(memberForRegion);
                membersForEachRegion.add(memberPRInfo);
            }
        }
    }

    ResultModel buildResultModelFromFunctionResults(RestoreRedundancyResults results, boolean isStatusCommand) {
        if (results.getRegionResults().isEmpty() && results.getIncludedRegionsWithNoMembers().isEmpty()) {
            return this.createNoMembersResultModel();
        }
        if (!results.getSuccess()) {
            return this.createErrorResultModel(results.getStatusMessage());
        }
        ResultModel result = new ResultModel();
        if (!results.getIncludedRegionsWithNoMembers().isEmpty()) {
            this.addRegionsWithNoMembersSection(results.getIncludedRegionsWithNoMembers(), result);
        }
        this.addSummarySection(result, results);
        this.addZeroRedundancySection(result, results);
        this.addUnderRedundancySection(result, results);
        this.addSatisfiedRedundancySection(result, results);
        if (!isStatusCommand) {
            this.addPrimariesSection(result, results);
            if (results.getRegionOperationStatus() == RestoreRedundancyResults.Status.FAILURE) {
                result.setStatus(Result.Status.ERROR);
            }
        }
        return result;
    }

    private ResultModel createNoMembersResultModel() {
        ResultModel result = new ResultModel();
        InfoResultModel noMembersSection = result.addInfo(NO_MEMBERS_SECTION);
        noMembersSection.setHeader(NO_MEMBERS_HEADER);
        return result;
    }

    private ResultModel createErrorResultModel(String errorString) {
        ResultModel result = new ResultModel();
        InfoResultModel errorSection = result.addInfo(ERROR_SECTION);
        errorSection.setHeader(ERROR_SECTION_HEADER);
        errorSection.addLine(errorString);
        result.setStatus(Result.Status.ERROR);
        return result;
    }

    private void addRegionsWithNoMembersSection(List<String> regionsWithNoMembers, ResultModel result) {
        InfoResultModel noMembersSection = result.addInfo(NO_MEMBERS_FOR_REGION_SECTION);
        noMembersSection.setHeader(NO_MEMBERS_FOR_REGION_HEADER);
        regionsWithNoMembers.forEach(noMembersSection::addLine);
        result.setStatus(Result.Status.ERROR);
    }

    private void addSummarySection(ResultModel result, RestoreRedundancyResults resultCollector) {
        InfoResultModel summary = result.addInfo(SUMMARY_SECTION);
        int satisfied = resultCollector.getSatisfiedRedundancyRegionResults().size();
        int notSatisfied = resultCollector.getUnderRedundancyRegionResults().size();
        int zeroRedundancy = resultCollector.getZeroRedundancyRegionResults().size();
        summary.addLine(ZERO_REDUNDANT_COPIES + zeroRedundancy);
        summary.addLine(PARTIALLY_SATISFIED_REDUNDANCY + notSatisfied);
        summary.addLine(FULLY_SATISFIED_REDUNDANCY + satisfied);
    }

    private void addZeroRedundancySection(ResultModel result, RestoreRedundancyResults resultCollector) {
        Map zeroRedundancyResults = resultCollector.getZeroRedundancyRegionResults();
        if (!zeroRedundancyResults.isEmpty()) {
            InfoResultModel zeroRedundancy = result.addInfo(ZERO_REDUNDANCY_SECTION);
            zeroRedundancy.setHeader("The following regions have redundancy configured but zero redundant copies: ");
            zeroRedundancyResults.values().stream().map(Object::toString).forEach(string -> zeroRedundancy.addLine(INDENT + string));
        }
    }

    private void addUnderRedundancySection(ResultModel result, RestoreRedundancyResults resultCollector) {
        Map underRedundancyResults = resultCollector.getUnderRedundancyRegionResults();
        if (!underRedundancyResults.isEmpty()) {
            InfoResultModel underRedundancy = result.addInfo(UNDER_REDUNDANCY_SECTION);
            underRedundancy.setHeader("Redundancy is partially satisfied for regions: ");
            underRedundancyResults.values().stream().map(Object::toString).forEach(string -> underRedundancy.addLine(INDENT + string));
        }
    }

    private void addSatisfiedRedundancySection(ResultModel result, RestoreRedundancyResults resultCollector) {
        Map satisfiedRedundancyResults = resultCollector.getSatisfiedRedundancyRegionResults();
        if (!satisfiedRedundancyResults.isEmpty()) {
            InfoResultModel satisfiedRedundancy = result.addInfo(SATISFIED_REDUNDANCY_SECTION);
            satisfiedRedundancy.setHeader("Redundancy is fully satisfied for regions: ");
            satisfiedRedundancyResults.values().stream().map(Object::toString).forEach(string -> satisfiedRedundancy.addLine(INDENT + string));
        }
    }

    private void addPrimariesSection(ResultModel result, RestoreRedundancyResults resultCollector) {
        InfoResultModel primaries = result.addInfo(PRIMARIES_INFO_SECTION);
        primaries.addLine("Total primary transfers completed = " + resultCollector.getTotalPrimaryTransfersCompleted());
        primaries.addLine("Total primary transfer time (ms) = " + resultCollector.getTotalPrimaryTransferTime());
    }

    List<RebalanceOperationPerformer.MemberPRInfo> getMembersForEachRegion(List<String> excludedRegionList) {
        InternalCache cache = (InternalCache)this.getCache();
        return RebalanceOperationPerformer.getMemberRegionList((ManagementService)ManagementService.getManagementService((Cache)cache), (InternalCache)cache, excludedRegionList);
    }

    DistributedMember getOneMemberForRegion(String regionName) {
        String regionNameWithSeparator = regionName;
        if (!regionName.startsWith("/")) {
            regionNameWithSeparator = "/" + regionName;
        }
        return RebalanceOperationPerformer.getAssociatedMembers((String)regionNameWithSeparator, (InternalCache)((InternalCache)this.getCache()));
    }

    SerializableRestoreRedundancyResultsImpl getNewRestoreRedundancyResults() {
        return new SerializableRestoreRedundancyResultsImpl();
    }
}

