/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class StatAlertNotification
extends StatAlert
implements Serializable,
DataSerializableFixedID {
    private static final long serialVersionUID = -1634729103430107871L;
    private String memberId;

    public StatAlertNotification() {
    }

    public StatAlertNotification(StatAlert statAlert, String memberId) {
        this.setDefinitionId(statAlert.getDefinitionId());
        this.setValues(statAlert.getValues());
        this.setTime(statAlert.getTime());
        this.memberId = memberId;
    }

    public int getDSFID() {
        return 1075;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String id) {
        this.memberId = id;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < this.getValues().length; ++i) {
            buf.append(this.getValues()[i] + ", ");
        }
        buf.append("]");
        return Integer.valueOf(this.getDefinitionId()) + ":" + buf.toString();
    }

    public String toString(StatAlertDefinition defn) {
        StringBuffer buf = new StringBuffer();
        buf.append("For Member ID: ");
        buf.append(this.memberId);
        buf.append("\n");
        buf.append("[ ");
        for (int i = 0; i < this.getValues().length; ++i) {
            buf.append(defn.getStatisticInfo()[i].toString() + "=" + this.getValues()[i] + "\n");
        }
        buf.append("]");
        return this.getTime().toString() + ":" + buf.toString();
    }

    public boolean equals(Object object) {
        if (object != null && !(object instanceof StatAlertNotification)) {
            return false;
        }
        StatAlertNotification other = (StatAlertNotification)object;
        int defId = this.getDefinitionId();
        return defId != -1 && defId == other.getDefinitionId() && this.memberId != null && this.memberId.equals(other.getMemberId());
    }

    public int hashCode() {
        return this.memberId.hashCode();
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writePrimitiveInt(this.getDefinitionId(), out);
        DataSerializer.writeDate(this.getTime(), out);
        DataSerializer.writeObjectArray(this.getValues(), out);
        DataSerializer.writeString(this.memberId, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.setDefinitionId(DataSerializer.readPrimitiveInt(in));
        this.setTime(DataSerializer.readDate(in));
        this.setValues((Number[])DataSerializer.readObjectArray(in));
        this.memberId = DataSerializer.readString(in);
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

