/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.FixedPartitionAttributes;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.partition.PartitionListener;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.offheap.OffHeapStorage;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionAttributesImpl
implements PartitionAttributes,
Cloneable,
DataSerializable {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -7120239286748961954L;
    private static final int OFF_HEAP_LOCAL_MAX_MEMORY_PLACEHOLDER = 1;
    private transient PartitionResolver partitionResolver;
    private transient boolean hasPartitionResolver;
    private int redundancy = 0;
    private transient boolean hasRedundancy;
    private long totalMaxMemory = Integer.MAX_VALUE;
    private transient boolean hasTotalMaxMemory;
    private Properties localProperties = new Properties();
    private Properties globalProperties = new Properties();
    @MutableForTesting
    private static String testAvailableOffHeapMemory = null;
    private int localMaxMemory = PartitionAttributesFactory.LOCAL_MAX_MEMORY_DEFAULT;
    private transient boolean hasLocalMaxMemory;
    private transient boolean localMaxMemoryExists;
    private transient boolean offHeap = false;
    private transient boolean hasOffHeap;
    private int totalNumBuckets = 113;
    private transient boolean hasTotalNumBuckets;
    private String colocatedRegionName;
    private transient boolean hasColocatedRegionName;
    private long recoveryDelay = -1L;
    private transient boolean hasRecoveryDelay;
    private long startupRecoveryDelay = 0L;
    private transient boolean hasStartupRecoveryDelay;
    private ArrayList<PartitionListener> partitionListeners;
    private transient boolean hasPartitionListeners;
    private List<FixedPartitionAttributesImpl> fixedPAttrs;
    private transient boolean hasFixedPAttrs;
    @Immutable
    private static final PartitionListener[] EMPTY_PARTITION_LISTENERS = new PartitionListener[0];

    public void setTotalNumBuckets(int maxNumberOfBuckets) {
        this.totalNumBuckets = maxNumberOfBuckets;
        this.globalProperties.setProperty("GLOBAL_MAX_BUCKETS", String.valueOf(this.totalNumBuckets));
        this.hasTotalNumBuckets = true;
    }

    public void setTotalMaxMemory(long maximumMB) {
        this.totalMaxMemory = maximumMB;
        this.globalProperties.setProperty("GLOBAL_MAX_MEMORY", String.valueOf(maximumMB));
        this.hasTotalMaxMemory = true;
    }

    public void setLocalMaxMemory(int maximumMB) {
        this.localMaxMemory = maximumMB;
        this.localProperties.setProperty("LOCAL_MAX_MEMORY", String.valueOf(this.localMaxMemory));
        this.hasLocalMaxMemory = true;
        this.localMaxMemoryExists = true;
    }

    public void setOffHeap(boolean offHeap) {
        this.offHeap = offHeap;
        this.hasOffHeap = true;
        if (this.offHeap && !this.hasLocalMaxMemory) {
            this.localMaxMemory = this.computeOffHeapLocalMaxMemory();
        }
    }

    public void setColocatedWith(String colocatedRegionFullPath) {
        this.colocatedRegionName = colocatedRegionFullPath;
        this.hasColocatedRegionName = true;
    }

    public void setRecoveryDelay(long recoveryDelay) {
        this.recoveryDelay = recoveryDelay;
        this.hasRecoveryDelay = true;
    }

    public void setStartupRecoveryDelay(long startupRecoveryDelay) {
        this.startupRecoveryDelay = startupRecoveryDelay;
        this.hasStartupRecoveryDelay = true;
    }

    public PartitionResolver getPartitionResolver() {
        return this.partitionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionListener(PartitionListener listener) {
        ArrayList<PartitionListener> listeners = this.partitionListeners;
        if (listeners == null) {
            ArrayList<PartitionListener> al = new ArrayList<PartitionListener>(1);
            al.add(listener);
            this.addPartitionListeners(al);
        } else {
            ArrayList<PartitionListener> arrayList = listeners;
            synchronized (arrayList) {
                listeners.add(listener);
            }
        }
    }

    private void addPartitionListeners(ArrayList<PartitionListener> listeners) {
        this.partitionListeners = listeners;
        this.hasPartitionListeners = true;
    }

    @Override
    public int getRedundantCopies() {
        return this.redundancy;
    }

    @Override
    public int getTotalNumBuckets() {
        return this.totalNumBuckets;
    }

    @Override
    public long getTotalSize() {
        return this.getTotalMaxMemory();
    }

    @Override
    public long getTotalMaxMemory() {
        return this.totalMaxMemory;
    }

    public boolean getOffHeap() {
        return this.offHeap;
    }

    @Override
    public int getLocalMaxMemory() {
        if (this.offHeap && !this.localMaxMemoryExists) {
            int value = this.computeOffHeapLocalMaxMemory();
            if (this.localMaxMemoryExists) {
                this.localMaxMemory = value;
            }
        }
        this.checkLocalMaxMemoryExists();
        return this.localMaxMemory;
    }

    private void checkLocalMaxMemoryExists() {
        if (this.offHeap && !this.localMaxMemoryExists) {
            throw new IllegalStateException("Attempting to use localMaxMemory for off-heap but value is not yet known (default value is equal to off-heap-memory-size)");
        }
    }

    public int getLocalMaxMemoryForValidation() {
        if (this.offHeap && !this.hasLocalMaxMemory && !this.localMaxMemoryExists) {
            int value = this.computeOffHeapLocalMaxMemory();
            if (this.localMaxMemoryExists) {
                this.localMaxMemory = value;
            }
        }
        return this.localMaxMemory;
    }

    @Override
    public String getColocatedWith() {
        return this.colocatedRegionName;
    }

    @Override
    public Properties getLocalProperties() {
        return this.localProperties;
    }

    @Override
    public Properties getGlobalProperties() {
        return this.globalProperties;
    }

    @Override
    public long getStartupRecoveryDelay() {
        return this.startupRecoveryDelay;
    }

    @Override
    public long getRecoveryDelay() {
        return this.recoveryDelay;
    }

    public List<FixedPartitionAttributesImpl> getFixedPartitionAttributes() {
        return this.fixedPAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionListener[] getPartitionListeners() {
        ArrayList<PartitionListener> listeners = this.partitionListeners;
        if (listeners == null) {
            return EMPTY_PARTITION_LISTENERS;
        }
        ArrayList<PartitionListener> arrayList = listeners;
        synchronized (arrayList) {
            if (listeners.size() == 0) {
                return EMPTY_PARTITION_LISTENERS;
            }
            PartitionListener[] result = new PartitionListener[listeners.size()];
            listeners.toArray(result);
            return result;
        }
    }

    public Object clone() {
        try {
            PartitionAttributesImpl copy = (PartitionAttributesImpl)super.clone();
            if (copy.fixedPAttrs != null) {
                copy.fixedPAttrs = new ArrayList<FixedPartitionAttributesImpl>(copy.fixedPAttrs);
            }
            if (copy.partitionListeners != null) {
                copy.partitionListeners = new ArrayList<PartitionListener>(copy.partitionListeners);
            }
            return copy;
        }
        catch (CloneNotSupportedException ignore) {
            throw new InternalGemFireError("CloneNotSupportedException thrown in class that implements cloneable");
        }
    }

    public PartitionAttributesImpl copy() {
        return (PartitionAttributesImpl)this.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append("PartitionAttributes@").append(System.identityHashCode(this)).append("[redundantCopies=").append(this.getRedundantCopies()).append(";localMaxMemory=").append(this.getLocalMaxMemory()).append(";totalMaxMemory=").append(this.totalMaxMemory).append(";totalNumBuckets=").append(this.totalNumBuckets).append(";partitionResolver=").append(this.partitionResolver).append(";colocatedWith=").append(this.colocatedRegionName).append(";recoveryDelay=").append(this.recoveryDelay).append(";startupRecoveryDelay=").append(this.startupRecoveryDelay).append(";FixedPartitionAttributes=").append(this.fixedPAttrs).append(";partitionListeners=").append(this.partitionListeners).append("]").toString();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        this.checkLocalMaxMemoryExists();
        out.writeInt(this.redundancy);
        out.writeLong(this.totalMaxMemory);
        out.writeInt(this.getLocalMaxMemory());
        out.writeInt(this.totalNumBuckets);
        DataSerializer.writeString(this.colocatedRegionName, out);
        DataSerializer.writeObject(this.localProperties, out);
        DataSerializer.writeObject(this.globalProperties, out);
        out.writeLong(this.recoveryDelay);
        out.writeLong(this.startupRecoveryDelay);
        DataSerializer.writeObject(this.fixedPAttrs, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.redundancy = in.readInt();
        this.totalMaxMemory = in.readLong();
        this.localMaxMemory = in.readInt();
        this.totalNumBuckets = in.readInt();
        this.colocatedRegionName = DataSerializer.readString(in);
        this.localProperties = (Properties)DataSerializer.readObject(in);
        this.globalProperties = (Properties)DataSerializer.readObject(in);
        this.recoveryDelay = in.readLong();
        this.startupRecoveryDelay = in.readLong();
        this.fixedPAttrs = (List)DataSerializer.readObject(in);
    }

    public static PartitionAttributesImpl createFromData(DataInput in) throws IOException, ClassNotFoundException {
        PartitionAttributesImpl result = new PartitionAttributesImpl();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    public void setPartitionResolver(PartitionResolver partitionResolver) {
        this.partitionResolver = partitionResolver;
        this.hasPartitionResolver = true;
    }

    public boolean equals(Object obj) {
        PartitionListener[] thisPListeners;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartitionAttributesImpl)) {
            return false;
        }
        PartitionAttributesImpl other = (PartitionAttributesImpl)obj;
        if (this.redundancy != other.getRedundantCopies() || this.getLocalMaxMemory() != other.getLocalMaxMemory() || this.offHeap != other.getOffHeap() || this.totalNumBuckets != other.getTotalNumBuckets() || this.totalMaxMemory != other.getTotalMaxMemory() || this.startupRecoveryDelay != other.getStartupRecoveryDelay() || this.recoveryDelay != other.getRecoveryDelay() || this.partitionResolver == null != (other.getPartitionResolver() == null) || this.partitionResolver != null && !this.partitionResolver.equals(other.getPartitionResolver()) || this.colocatedRegionName == null != (other.getColocatedWith() == null) || this.colocatedRegionName != null && !this.colocatedRegionName.equals(other.getColocatedWith()) || this.fixedPAttrs == null != (other.getFixedPartitionAttributes() == null) || this.fixedPAttrs != null && !this.fixedPAttrs.equals(other.getFixedPartitionAttributes())) {
            return false;
        }
        PartitionListener[] otherPListeners = other.getPartitionListeners();
        if (otherPListeners.length != (thisPListeners = this.getPartitionListeners()).length) {
            return false;
        }
        HashSet<String> otherListenerClassName = new HashSet<String>();
        for (int i = 0; i < otherPListeners.length; ++i) {
            PartitionListener listener = otherPListeners[i];
            otherListenerClassName.add(listener.getClass().getName());
        }
        HashSet<String> thisListenerClassName = new HashSet<String>();
        for (int i = 0; i < thisPListeners.length; ++i) {
            PartitionListener listener = thisPListeners[i];
            thisListenerClassName.add(listener.getClass().getName());
        }
        return thisListenerClassName.equals(otherListenerClassName);
    }

    public int hashCode() {
        return this.getRedundantCopies();
    }

    public int getRedundancy() {
        return this.redundancy;
    }

    public void setRedundantCopies(int redundancy) {
        this.redundancy = redundancy;
        this.hasRedundancy = true;
    }

    @Deprecated
    public void setLocalProperties(Properties localProps) {
        this.localProperties = localProps;
        if (localProps.get("LOCAL_MAX_MEMORY") != null) {
            this.setLocalMaxMemory(Integer.parseInt((String)localProps.get("LOCAL_MAX_MEMORY")));
        }
    }

    @Deprecated
    public void setGlobalProperties(Properties globalProps) {
        this.globalProperties = globalProps;
        String propVal = globalProps.getProperty("GLOBAL_MAX_MEMORY");
        if (propVal != null) {
            try {
                this.setTotalMaxMemory(Integer.parseInt(propVal));
            }
            catch (RuntimeException ignore) {
                this.totalMaxMemory = Integer.MAX_VALUE;
            }
        }
        if ((propVal = globalProps.getProperty("GLOBAL_MAX_BUCKETS")) != null) {
            try {
                this.setTotalNumBuckets(Integer.parseInt(propVal));
            }
            catch (RuntimeException ignore) {
                this.totalNumBuckets = 113;
            }
        }
    }

    public void addFixedPartitionAttributes(FixedPartitionAttributes fpa) {
        if (this.fixedPAttrs == null) {
            this.fixedPAttrs = new ArrayList<FixedPartitionAttributesImpl>(1);
            this.fixedPAttrs.add((FixedPartitionAttributesImpl)fpa);
            this.hasFixedPAttrs = true;
        } else {
            this.fixedPAttrs.add((FixedPartitionAttributesImpl)fpa);
        }
    }

    private void addFixedPartitionAttributes(List<FixedPartitionAttributesImpl> fpas) {
        this.fixedPAttrs = fpas;
        this.hasFixedPAttrs = true;
    }

    public void validateAttributes() {
        if (this.totalNumBuckets <= 0) {
            throw new IllegalStateException(String.format("TotalNumBuckets %s is an illegal value, please choose a value greater than 0", this.totalNumBuckets));
        }
        if (this.redundancy < 0 || this.redundancy >= 4) {
            throw new IllegalStateException(String.format("RedundantCopies %s is an illegal value, please choose a value between 0 and 3", this.redundancy));
        }
        for (String string : this.getLocalProperties().keySet()) {
            if ("LOCAL_MAX_MEMORY".equals(string)) continue;
            throw new IllegalStateException(String.format("Unknown local property: '%s'", string));
        }
        for (String string : this.getGlobalProperties().keySet()) {
            if ("GLOBAL_MAX_BUCKETS".equals(string) || "GLOBAL_MAX_MEMORY".equals(string)) continue;
            throw new IllegalStateException(String.format("Unknown global property: '%s'", string));
        }
        if (this.recoveryDelay < -1L) {
            throw new IllegalStateException("RecoveryDelay " + this.recoveryDelay + " is an illegal value, please choose a value that is greater than or equal to -1");
        }
        if (this.startupRecoveryDelay < -1L) {
            throw new IllegalStateException("StartupRecoveryDelay " + this.startupRecoveryDelay + " is an illegal value, please choose a value that is greater than or equal to -1");
        }
        if (this.fixedPAttrs != null) {
            ArrayList<FixedPartitionAttributesImpl> duplicateFPAattrsList = new ArrayList<FixedPartitionAttributesImpl>();
            HashSet<FixedPartitionAttributesImpl> hashSet = new HashSet<FixedPartitionAttributesImpl>();
            for (FixedPartitionAttributesImpl fpa : this.fixedPAttrs) {
                if (fpa == null || fpa.getPartitionName() == null) {
                    throw new IllegalStateException("Fixed partition name cannot be null".toString());
                }
                if (hashSet.contains(fpa)) {
                    duplicateFPAattrsList.add(fpa);
                    continue;
                }
                hashSet.add(fpa);
            }
            if (duplicateFPAattrsList.size() != 0) {
                throw new IllegalStateException(String.format("Partition name %s can be added only once in FixedPartitionAttributes", ((Object)duplicateFPAattrsList).toString()));
            }
        }
    }

    public void validateWhenAllAttributesAreSet(boolean isDeclarative) {
        if (this.colocatedRegionName != null && this.fixedPAttrs != null) {
            throw new IllegalStateException(String.format("FixedPartitionAttributes %s can not be specified in PartitionAttributesFactory if colocated-with is specified. ", this.fixedPAttrs));
        }
        if (this.fixedPAttrs != null && this.localMaxMemory == 0) {
            throw new IllegalStateException(String.format("FixedPartitionAttributes %s can not be defined for accessor", this.fixedPAttrs));
        }
    }

    void validateColocation(Cache cache) {
        if (this.colocatedRegionName == null) {
            return;
        }
        if (cache != null) {
            Region region = cache.getRegion(this.colocatedRegionName);
            if (region == null) {
                throw new IllegalStateException("Region specified in 'colocated-with' is not present. It should be created before setting 'colocated-with' to this region.");
            }
            if (!(region instanceof PartitionedRegion)) {
                throw new IllegalStateException("Setting the attribute 'colocated-with' is supported only for PartitionedRegions");
            }
            PartitionedRegion colocatedRegion = (PartitionedRegion)region;
            if (this.getTotalNumBuckets() != colocatedRegion.getPartitionAttributes().getTotalNumBuckets()) {
                throw new IllegalStateException("Current PartitionedRegion's TotalNumBuckets should be same as TotalNumBuckets of colocated PartitionedRegion");
            }
            if (this.getRedundancy() != colocatedRegion.getPartitionAttributes().getRedundantCopies()) {
                throw new IllegalStateException("Current PartitionedRegion's redundancy should be same as the redundancy of colocated PartitionedRegion");
            }
        }
    }

    public void merge(PartitionAttributesImpl pa) {
        if (pa.hasRedundancy) {
            this.setRedundantCopies(pa.getRedundantCopies());
        }
        if (pa.hasLocalMaxMemory) {
            this.setLocalMaxMemory(pa.getLocalMaxMemory());
        }
        if (pa.hasOffHeap) {
            this.setOffHeap(pa.getOffHeap());
        }
        if (pa.hasTotalMaxMemory) {
            this.setTotalMaxMemory(pa.getTotalMaxMemory());
        }
        if (pa.hasTotalNumBuckets) {
            this.setTotalNumBuckets(pa.getTotalNumBuckets());
        }
        if (pa.hasPartitionResolver) {
            this.setPartitionResolver(pa.getPartitionResolver());
        }
        if (pa.hasColocatedRegionName) {
            this.setColocatedWith(pa.getColocatedWith());
        }
        if (pa.hasRecoveryDelay) {
            this.setRecoveryDelay(pa.getRecoveryDelay());
        }
        if (pa.hasStartupRecoveryDelay) {
            this.setStartupRecoveryDelay(pa.getStartupRecoveryDelay());
        }
        if (pa.hasFixedPAttrs) {
            this.addFixedPartitionAttributes(pa.getFixedPartitionAttributes());
        }
        if (pa.hasPartitionListeners) {
            this.addPartitionListeners(pa.partitionListeners);
        }
    }

    public void setAll(PartitionAttributes pa) {
        this.setRedundantCopies(pa.getRedundantCopies());
        this.setLocalProperties(pa.getLocalProperties());
        this.setGlobalProperties(pa.getGlobalProperties());
        this.setLocalMaxMemory(pa.getLocalMaxMemory());
        this.setTotalMaxMemory(pa.getTotalMaxMemory());
        this.setTotalNumBuckets(pa.getTotalNumBuckets());
        this.setPartitionResolver(pa.getPartitionResolver());
        this.setColocatedWith(pa.getColocatedWith());
        this.setRecoveryDelay(pa.getRecoveryDelay());
        this.setStartupRecoveryDelay(pa.getStartupRecoveryDelay());
        this.setOffHeap(((PartitionAttributesImpl)pa).getOffHeap());
        this.addFixedPartitionAttributes(pa.getFixedPartitionAttributes());
    }

    public static void setTestAvailableOffHeapMemory(String newTestAvailableOffHeapMemory) {
        testAvailableOffHeapMemory = newTestAvailableOffHeapMemory;
    }

    private int computeOffHeapLocalMaxMemory() {
        long availableOffHeapMemoryInMB = 0L;
        if (testAvailableOffHeapMemory != null) {
            availableOffHeapMemoryInMB = OffHeapStorage.parseOffHeapMemorySize(testAvailableOffHeapMemory) / 0x100000L;
        } else {
            if (InternalDistributedSystem.getAnyInstance() == null) {
                this.localMaxMemoryExists = false;
                return 1;
            }
            String offHeapSizeConfigValue = InternalDistributedSystem.getAnyInstance().getOriginalConfig().getOffHeapMemorySize();
            availableOffHeapMemoryInMB = OffHeapStorage.parseOffHeapMemorySize(offHeapSizeConfigValue) / 0x100000L;
        }
        if (availableOffHeapMemoryInMB > Integer.MAX_VALUE) {
            logger.warn("Reduced local max memory for partition attribute when setting from available off-heap memory size");
            return Integer.MAX_VALUE;
        }
        this.localMaxMemoryExists = true;
        return (int)availableOffHeapMemoryInMB;
    }

    public int getLocalMaxMemoryDefault() {
        if (!this.offHeap) {
            return PartitionAttributesFactory.LOCAL_MAX_MEMORY_DEFAULT;
        }
        return this.computeOffHeapLocalMaxMemory();
    }
}

