/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DurableClientAttributes;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.Versioning;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClientProxyMembershipID
implements DataSerializableFixedID,
Serializable,
Externalizable {
    public static final long serialVersionUID = 7144300815346556370L;
    private static final Logger logger = LogService.getLogger();
    private static final ThreadLocal<String> POOL_NAME = new ThreadLocal();
    private static final int BYTES_32KB = 32768;
    @MakeNotStatic
    public static volatile DistributedSystem system = null;
    @MakeNotStatic
    public static DistributedMember systemMemberId;
    private static final int durable_synch_counter = 1;
    @MakeNotStatic
    private static int synch_counter;
    protected byte[] identity;
    private transient DistributedMember memberId;
    private transient String memberIdString;
    protected int uniqueId;
    private transient String _toString;

    public static void setPoolName(String poolName) {
        POOL_NAME.set(poolName);
    }

    public static String getPoolName() {
        return POOL_NAME.get();
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        if (this.isDurable()) {
            result = 37 * result + this.getDurableId().hashCode();
        } else if (this.identity != null && this.identity.length > 0) {
            for (int i = 0; i < this.identity.length; ++i) {
                result = 37 * result + this.identity[i];
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClientProxyMembershipID)) {
            return false;
        }
        ClientProxyMembershipID that = (ClientProxyMembershipID)obj;
        if (this.uniqueId != that.uniqueId) {
            return false;
        }
        boolean isDurable = this.isDurable();
        if (isDurable && !that.isDurable()) {
            return false;
        }
        if (isDurable) {
            return this.getDurableId().equals(that.getDurableId());
        }
        return Arrays.equals(this.identity, that.identity);
    }

    private boolean isCanonicalEquals(ClientProxyMembershipID that) {
        if (this == that) {
            return true;
        }
        if (this.uniqueId != that.uniqueId) {
            return false;
        }
        return Arrays.equals(this.identity, that.identity);
    }

    boolean isSameDSMember(ClientProxyMembershipID that) {
        if (that != null) {
            return this.isDurable() ? this.getDurableId().equals(that.getDurableId()) : Arrays.equals(this.identity, that.identity);
        }
        return false;
    }

    public static synchronized ClientProxyMembershipID getNewProxyMembership(DistributedSystem sys) {
        byte[] ba = ClientProxyMembershipID.initializeAndGetDSIdentity(sys);
        return new ClientProxyMembershipID(++synch_counter, ba);
    }

    public static ClientProxyMembershipID getClientId(DistributedMember member) {
        return new ClientProxyMembershipID(member);
    }

    public static byte[] initializeAndGetDSIdentity(DistributedSystem sys) {
        byte[] client_side_identity = null;
        if (sys == null) {
            throw new IllegalStateException("Attempting to handshake with CacheServer before creating DistributedSystem and Cache.");
        }
        systemMemberId = sys.getDistributedMember();
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(256, KnownVersion.CURRENT);){
            DurableClientAttributes attributes;
            if (systemMemberId != null && (attributes = systemMemberId.getDurableClientAttributes()) != null && attributes.getId().length() > 0) {
                ((InternalDistributedMember)systemMemberId).setDurableId(attributes.getId());
            }
            DataSerializer.writeObject(systemMemberId, hdos);
            client_side_identity = hdos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalGemFireException("Unable to serialize identity", ioe);
        }
        system = sys;
        return client_side_identity;
    }

    private ClientProxyMembershipID(int id, byte[] clientSideIdentity) {
        boolean specialCase = Boolean.getBoolean("gemfire.SPECIAL_DURABLE");
        String durableID = system.getProperties().getProperty("durable-client-id");
        this.uniqueId = specialCase && durableID != null && !durableID.equals("") ? 1 : id;
        this.identity = clientSideIdentity;
        this.memberId = systemMemberId;
    }

    public ClientProxyMembershipID() {
    }

    public ClientProxyMembershipID(DistributedMember member) {
        this.uniqueId = 1;
        this.memberId = member;
        this.updateID(member);
    }

    public String toString() {
        if (this.identity != null && ((InternalDistributedMember)this.getDistributedMember()).getMembershipPort() == 0) {
            return this.toStringNoCache();
        }
        if (this._toString == null) {
            this._toString = this.toStringNoCache();
        }
        return this._toString;
    }

    public String toStringNoCache() {
        DurableClientAttributes dca;
        StringBuffer sb = new StringBuffer("identity(").append(this.getDSMembership()).append(",connection=").append(this.uniqueId);
        if (this.identity != null && (dca = this.getDurableAttributes()).getId().length() > 0) {
            sb.append(",durableAttributes=").append(dca).append(')').toString();
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Assert.assertTrue(this.identity.length <= 32768);
        out.writeShort(this.identity.length);
        out.write(this.identity);
        out.writeInt(this.uniqueId);
    }

    public int getSerializedSize() {
        return 4 + this.identity.length + 4;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short identityLength = in.readShort();
        if (identityLength > 32768) {
            throw new IOException("HandShake identity length is too big");
        }
        this.identity = new byte[identityLength];
        this.read(in, this.identity);
        this.uniqueId = in.readInt();
        if (this.uniqueId == -1) {
            throw new IOException("Unexpected EOF reached. Unique ID could not be read");
        }
    }

    private void read(ObjectInput dis, byte[] toFill) throws IOException {
        int dataRead;
        int toFillLength = toFill.length;
        for (int idBytes = 0; idBytes < toFillLength; idBytes += dataRead) {
            dataRead = dis.read(toFill, idBytes, toFillLength - idBytes);
            if (dataRead != -1) continue;
            throw new IOException("Unexpected EOF reached. Distributed MembershipID could not be read");
        }
    }

    public int getDSFID() {
        return 38;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeByteArray(this.identity, out);
        out.writeInt(this.uniqueId);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.identity = DataSerializer.readByteArray(in);
        this.uniqueId = in.readInt();
    }

    public KnownVersion getClientVersion() {
        return Versioning.getKnownVersionOrDefault((Version)((InternalDistributedMember)this.getDistributedMember()).getVersion(), (KnownVersion)KnownVersion.CURRENT);
    }

    public String getDSMembership() {
        if (this.identity == null) {
            return "null";
        }
        if (((InternalDistributedMember)this.getDistributedMember()).getMembershipPort() == 0) {
            return this.getMemberIdAsString();
        }
        if (this.memberIdString == null) {
            this.memberIdString = this.getMemberIdAsString();
        }
        return this.memberIdString;
    }

    private String getMemberIdAsString() {
        String memberIdAsString = null;
        InternalDistributedMember idm = (InternalDistributedMember)this.getDistributedMember();
        if (this.getClientVersion().isOlderThan((Version)KnownVersion.GFE_90)) {
            memberIdAsString = idm.toString();
        } else {
            StringBuilder sb = new StringBuilder();
            idm.addFixedToString(sb, !SocketCreator.resolve_dns);
            memberIdAsString = sb.toString();
        }
        return memberIdAsString;
    }

    private ClientProxyMembershipID canonicalReference() {
        CacheClientProxy cp;
        CacheClientNotifier ccn = CacheClientNotifier.getInstance();
        if (ccn != null && (cp = ccn.getClientProxy(this, true)) != null && this.isCanonicalEquals(cp.getProxyID())) {
            return cp.getProxyID();
        }
        return this;
    }

    public DistributedMember getDistributedMember() {
        if (this.memberId == null) {
            try (ByteArrayDataInput dataInput = new ByteArrayDataInput(this.identity);){
                this.memberId = (DistributedMember)DataSerializer.readObject((DataInput)dataInput);
            }
            catch (Exception e) {
                logger.error("Unable to deserialize membership id", (Throwable)e);
            }
        }
        return this.memberId;
    }

    byte[] getMembershipByteArray() {
        return this.identity;
    }

    public boolean isDurable() {
        String durableClientId = this.getDistributedMember().getDurableClientAttributes().getId();
        return durableClientId != null && durableClientId.length() != 0;
    }

    protected DurableClientAttributes getDurableAttributes() {
        return this.getDistributedMember().getDurableClientAttributes();
    }

    public String getDurableId() {
        DurableClientAttributes dca = this.getDurableAttributes();
        return dca == null ? "" : dca.getId();
    }

    protected int getDurableTimeout() {
        DurableClientAttributes dca = this.getDurableAttributes();
        return dca == null ? 0 : dca.getTimeout();
    }

    public void updateDurableTimeout(int newValue) {
        InternalDistributedMember member = (InternalDistributedMember)this.getDistributedMember();
        member.setDurableTimeout(newValue);
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only applicable in client DS and in that case too multiple instances do not modify it at the same time.")
    public void updateID(DistributedMember idm) {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(256, KnownVersion.CURRENT);){
            try {
                DataSerializer.writeObject(idm, hdos);
            }
            catch (IOException e) {
                throw new InternalGemFireException("Unable to serialize member: " + this.memberId, e);
            }
            this.identity = hdos.toByteArray();
        }
        if (this.memberId != null && this.memberId == systemMemberId) {
            systemMemberId = idm;
        }
        this.memberId = idm;
        this._toString = null;
    }

    protected String getHARegionName() {
        return this.getBaseRegionName() + "_queue";
    }

    protected String getInterestRegionName() {
        return this.getBaseRegionName() + "_interest";
    }

    private String getBaseRegionName() {
        String id;
        String string = id = this.isDurable() ? this.getDurableId() : this.getDSMembership();
        if (id.indexOf(47) >= 0) {
            id = id.replace('/', ':');
        }
        StringBuffer buffer = new StringBuffer().append("_gfe_").append(this.isDurable() ? "" : "non_").append("durable_client_").append("with_id_" + id).append("_").append(this.uniqueId);
        return buffer.toString();
    }

    public static synchronized void resetUniqueIdCounter() {
        synch_counter = 0;
    }

    public Identity getIdentity() {
        return new Identity();
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public static ClientProxyMembershipID readCanonicalized(DataInput in) throws IOException, ClassNotFoundException {
        ClientProxyMembershipID result = (ClientProxyMembershipID)DataSerializer.readObject(in);
        if (result == null || result.identity == null) {
            return result;
        }
        return result.canonicalReference();
    }

    static {
        synch_counter = 0;
    }

    public class Identity {
        public int getUniqueId() {
            return ClientProxyMembershipID.this.uniqueId;
        }

        public byte[] getMemberIdBytes() {
            return ClientProxyMembershipID.this.identity;
        }

        public int hashCode() {
            int result = 17;
            int mult = 37;
            byte[] idBytes = this.getMemberIdBytes();
            if (idBytes != null && idBytes.length > 0) {
                for (int i = 0; i < idBytes.length; ++i) {
                    result = 37 * result + idBytes[i];
                }
            }
            result = 37 * result + ClientProxyMembershipID.this.uniqueId;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Identity)) {
                return false;
            }
            Identity that = (Identity)obj;
            return this.getUniqueId() == that.getUniqueId() && Arrays.equals(this.getMemberIdBytes(), that.getMemberIdBytes());
        }

        public ClientProxyMembershipID getClientProxyID() {
            return ClientProxyMembershipID.this;
        }
    }
}

