/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics.meters;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.geode.Statistics;
import org.apache.geode.internal.statistics.meters.DoubleStatisticBinding;
import org.apache.geode.internal.statistics.meters.LongStatisticBinding;
import org.apache.geode.internal.statistics.meters.StatisticBinding;

public class LegacyStatTimer
implements Timer {
    private final Clock clock;
    private final Timer underlyingTimer;
    private final StatisticBinding countStatisticBinding;
    private final StatisticBinding timeStatisticBinding;

    private LegacyStatTimer(Clock clock, Timer underlyingTimer, StatisticBinding countStatisticBinding, StatisticBinding timeStatisticBinding) {
        this.clock = clock;
        this.underlyingTimer = underlyingTimer;
        this.countStatisticBinding = countStatisticBinding;
        this.timeStatisticBinding = timeStatisticBinding;
    }

    @Override
    public Meter.Id getId() {
        return this.underlyingTimer.getId();
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.underlyingTimer.baseTimeUnit();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.underlyingTimer.record(amount, unit);
        this.countStatisticBinding.add(1.0);
        this.timeStatisticBinding.add(TimeUnit.NANOSECONDS.convert(amount, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> supplier) {
        long s = this.clock.monotonicTime();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> callable) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable runnable) {
        long s = this.clock.monotonicTime();
        try {
            runnable.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return this.countStatisticBinding.longValue();
    }

    @Override
    public double totalTime(TimeUnit unit) {
        return unit.convert(this.timeStatisticBinding.longValue(), TimeUnit.NANOSECONDS);
    }

    @Override
    public double max(TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HistogramSnapshot takeSnapshot() {
        throw new UnsupportedOperationException();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final Timer.Builder builder;
        private StatisticBinding countStatisticBinding = StatisticBinding.noOp();
        private StatisticBinding timeStatisticBinding = StatisticBinding.noOp();

        private Builder(String name) {
            this.builder = Timer.builder(name);
        }

        public Builder description(String description) {
            this.builder.description(description);
            return this;
        }

        public Builder doubleCountStatistic(Statistics statistics, int statId) {
            this.countStatisticBinding = new DoubleStatisticBinding(statistics, statId);
            return this;
        }

        public Builder longCountStatistic(Statistics statistics, int statId) {
            this.countStatisticBinding = new LongStatisticBinding(statistics, statId);
            return this;
        }

        public Builder doubleTimeStatistic(Statistics statistics, int statId) {
            this.timeStatisticBinding = new DoubleStatisticBinding(statistics, statId);
            return this;
        }

        public Builder longTimeStatistic(Statistics statistics, int statId) {
            this.timeStatisticBinding = new LongStatisticBinding(statistics, statId);
            return this;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.builder.tags((Iterable)tags);
            return this;
        }

        public Builder tag(String name, String value) {
            this.builder.tag(name, value);
            return this;
        }

        public Builder tags(String ... tags) {
            this.builder.tags(tags);
            return this;
        }

        public Timer register(MeterRegistry registry) {
            Clock clock = registry.config().clock();
            Timer underlyingTimer = this.builder.register(registry);
            return new LegacyStatTimer(clock, underlyingTimer, this.countStatisticBinding, this.timeStatisticBinding);
        }
    }
}

