/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import com.google.protobuf.ProtocolStringList;
import java.util.List;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;

public class ExecuteFunctionOnGroupRequestOperationHandler
implements ProtobufOperationHandler<FunctionAPI.ExecuteFunctionOnGroupRequest, FunctionAPI.ExecuteFunctionOnGroupResponse> {
    @Override
    public Result<FunctionAPI.ExecuteFunctionOnGroupResponse> process(ProtobufSerializationService serializationService, FunctionAPI.ExecuteFunctionOnGroupRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, DecodingException, EncodingException {
        String functionID = request.getFunctionID();
        ProtocolStringList memberNameList = request.getGroupNameList();
        Object arguments = this.getFunctionArguments(request, serializationService);
        List<Object> results = messageExecutionContext.getSecureCache().getFunctionService().executeFunctionOnGroups(functionID, arguments, memberNameList);
        FunctionAPI.ExecuteFunctionOnGroupResponse.Builder responseMessage = FunctionAPI.ExecuteFunctionOnGroupResponse.newBuilder();
        results.stream().map(serializationService::encode).forEach(arg_0 -> ((FunctionAPI.ExecuteFunctionOnGroupResponse.Builder)responseMessage).addResults(arg_0));
        return Success.of(responseMessage.build());
    }

    private Object getFunctionArguments(FunctionAPI.ExecuteFunctionOnGroupRequest request, ProtobufSerializationService serializationService) throws DecodingException {
        if (request.hasArguments()) {
            return serializationService.decode(request.getArguments());
        }
        return null;
    }
}

