/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ConnectionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorAPI;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ClearRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.DisconnectClientRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ExecuteFunctionOnGroupRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ExecuteFunctionOnMemberRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ExecuteFunctionOnRegionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRegionNamesRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetServerOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetSizeRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.KeySetOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.OqlQueryRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutIfAbsentRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.RemoveRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.security.HandshakeRequestOperationHandler;

@Experimental
public class ProtobufOperationContextRegistry {
    private final Map<ClientProtocol.Message.MessageTypeCase, ProtobufOperationContext> operationContexts = Collections.unmodifiableMap(this.generateContexts());

    public ProtobufOperationContext getOperationContext(ClientProtocol.Message.MessageTypeCase apiCase) {
        return this.operationContexts.get(apiCase);
    }

    private Map<ClientProtocol.Message.MessageTypeCase, ProtobufOperationContext> generateContexts() {
        HashMap<ClientProtocol.Message.MessageTypeCase, ProtobufOperationContext> operationContexts = new HashMap<ClientProtocol.Message.MessageTypeCase, ProtobufOperationContext>();
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.HANDSHAKEREQUEST, new ProtobufOperationContext<ConnectionAPI.HandshakeRequest, ConnectionAPI.HandshakeResponse>(ClientProtocol.Message::getHandshakeRequest, new HandshakeRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setHandshakeResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.DISCONNECTCLIENTREQUEST, new ProtobufOperationContext<ConnectionAPI.DisconnectClientRequest, ConnectionAPI.DisconnectClientResponse>(ClientProtocol.Message::getDisconnectClientRequest, new DisconnectClientRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setDisconnectClientResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETREQUEST, new ProtobufOperationContext<RegionAPI.GetRequest, RegionAPI.GetResponse>(ClientProtocol.Message::getGetRequest, new GetRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETALLREQUEST, new ProtobufOperationContext<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse>(ClientProtocol.Message::getGetAllRequest, new GetAllRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetAllResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.PUTREQUEST, new ProtobufOperationContext<RegionAPI.PutRequest, RegionAPI.PutResponse>(ClientProtocol.Message::getPutRequest, new PutRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setPutResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.PUTALLREQUEST, new ProtobufOperationContext<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse>(ClientProtocol.Message::getPutAllRequest, new PutAllRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setPutAllResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.REMOVEREQUEST, new ProtobufOperationContext<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse>(ClientProtocol.Message::getRemoveRequest, new RemoveRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setRemoveResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETREGIONNAMESREQUEST, new ProtobufOperationContext<RegionAPI.GetRegionNamesRequest, RegionAPI.GetRegionNamesResponse>(ClientProtocol.Message::getGetRegionNamesRequest, new GetRegionNamesRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetRegionNamesResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETSIZEREQUEST, new ProtobufOperationContext<RegionAPI.GetSizeRequest, RegionAPI.GetSizeResponse>(ClientProtocol.Message::getGetSizeRequest, new GetSizeRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetSizeResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETSERVERREQUEST, new ProtobufOperationContext<LocatorAPI.GetServerRequest, LocatorAPI.GetServerResponse>(ClientProtocol.Message::getGetServerRequest, new GetServerOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetServerResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.EXECUTEFUNCTIONONREGIONREQUEST, new ProtobufOperationContext<FunctionAPI.ExecuteFunctionOnRegionRequest, FunctionAPI.ExecuteFunctionOnRegionResponse>(ClientProtocol.Message::getExecuteFunctionOnRegionRequest, new ExecuteFunctionOnRegionRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setExecuteFunctionOnRegionResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.EXECUTEFUNCTIONONMEMBERREQUEST, new ProtobufOperationContext<FunctionAPI.ExecuteFunctionOnMemberRequest, FunctionAPI.ExecuteFunctionOnMemberResponse>(ClientProtocol.Message::getExecuteFunctionOnMemberRequest, new ExecuteFunctionOnMemberRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setExecuteFunctionOnMemberResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.EXECUTEFUNCTIONONGROUPREQUEST, new ProtobufOperationContext<FunctionAPI.ExecuteFunctionOnGroupRequest, FunctionAPI.ExecuteFunctionOnGroupResponse>(ClientProtocol.Message::getExecuteFunctionOnGroupRequest, new ExecuteFunctionOnGroupRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setExecuteFunctionOnGroupResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.OQLQUERYREQUEST, new ProtobufOperationContext<RegionAPI.OQLQueryRequest, RegionAPI.OQLQueryResponse>(ClientProtocol.Message::getOqlQueryRequest, new OqlQueryRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setOqlQueryResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.KEYSETREQUEST, new ProtobufOperationContext<RegionAPI.KeySetRequest, RegionAPI.KeySetResponse>(ClientProtocol.Message::getKeySetRequest, new KeySetOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setKeySetResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.CLEARREQUEST, new ProtobufOperationContext<RegionAPI.ClearRequest, RegionAPI.ClearResponse>(ClientProtocol.Message::getClearRequest, new ClearRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setClearResponse(opsResp)));
        operationContexts.put(ClientProtocol.Message.MessageTypeCase.PUTIFABSENTREQUEST, new ProtobufOperationContext<RegionAPI.PutIfAbsentRequest, RegionAPI.PutIfAbsentResponse>(ClientProtocol.Message::getPutIfAbsentRequest, new PutIfAbsentRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setPutIfAbsentResponse(opsResp)));
        return operationContexts;
    }
}

