/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.memcached.commands;

import java.nio.ByteBuffer;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.memcached.Reply;
import org.apache.geode.internal.memcached.RequestReader;
import org.apache.geode.internal.memcached.ResponseStatus;
import org.apache.geode.internal.memcached.ValueWrapper;
import org.apache.geode.internal.memcached.commands.StorageCommand;

public class PrependCommand
extends StorageCommand {
    @Override
    public ByteBuffer processStorageCommand(String key, byte[] value, int flags, Cache cache) {
        Region<Object, ValueWrapper> r = PrependCommand.getMemcachedRegion(cache);
        ValueWrapper oldValWrapper = r.get(key);
        String retVal = Reply.NOT_FOUND.toString();
        if (oldValWrapper != null) {
            byte[] oldVal = oldValWrapper.getValue();
            byte[] prependVal = value;
            byte[] newVal = new byte[oldVal.length + prependVal.length];
            System.arraycopy(prependVal, 0, newVal, 0, prependVal.length);
            System.arraycopy(oldVal, 0, newVal, prependVal.length, oldVal.length);
            r.put(key, ValueWrapper.getWrappedValue(newVal, flags));
            retVal = Reply.STORED.toString();
        }
        return asciiCharset.encode(retVal);
    }

    @Override
    public ByteBuffer processBinaryStorageCommand(Object key, byte[] value, long cas, int flags, Cache cache, RequestReader request) {
        ByteBuffer response = request.getResponse();
        Region<Object, ValueWrapper> r = PrependCommand.getMemcachedRegion(cache);
        try {
            ValueWrapper oldValWrapper = r.get(key);
            if (oldValWrapper != null) {
                byte[] oldVal = oldValWrapper.getValue();
                byte[] prependVal = value;
                byte[] newVal = new byte[oldVal.length + prependVal.length];
                System.arraycopy(prependVal, 0, newVal, 0, prependVal.length);
                System.arraycopy(oldVal, 0, newVal, prependVal.length, oldVal.length);
                ValueWrapper val = ValueWrapper.getWrappedValue(newVal, flags);
                r.put(key, val);
                if (this.isQuiet()) {
                    return null;
                }
                response.putShort(6, ResponseStatus.NO_ERROR.asShort());
                response.putLong(16, val.getVersion());
            } else {
                response.putShort(6, ResponseStatus.KEY_NOT_FOUND.asShort());
            }
        }
        catch (Exception e) {
            response = this.handleBinaryException(key, request, response, "prepend", e);
        }
        return response;
    }

    protected boolean isQuiet() {
        return false;
    }
}

