/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.security;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.security.RestrictedMethodAuthorizer;

public final class JavaBeanAccessorMethodAuthorizer
implements MethodInvocationAuthorizer {
    static final String NULL_PACKAGE_MESSAGE = "A set of allowed packages should be provided to configure the authorizer.";
    static final String NULL_AUTHORIZER_MESSAGE = "RestrictedMethodAuthorizer should be provided to create this authorizer.";
    static final String NULL_CACHE_MESSAGE = "Cache should be provided to configure the authorizer.";
    static final String GEODE_BASE_PACKAGE = "org.apache.geode";
    private static final Pattern pattern = Pattern.compile("^(get|is)($|[A-Z])+.*");
    private final RestrictedMethodAuthorizer restrictedMethodAuthorizer;
    private final Set<String> allowedPackages;

    public JavaBeanAccessorMethodAuthorizer(Cache cache, Set<String> allowedPackages) {
        Objects.requireNonNull(cache, NULL_CACHE_MESSAGE);
        Objects.requireNonNull(allowedPackages, NULL_PACKAGE_MESSAGE);
        this.restrictedMethodAuthorizer = new RestrictedMethodAuthorizer(cache);
        this.allowedPackages = Collections.unmodifiableSet(allowedPackages);
    }

    public JavaBeanAccessorMethodAuthorizer(RestrictedMethodAuthorizer restrictedMethodAuthorizer, Set<String> allowedPackages) {
        Objects.requireNonNull(restrictedMethodAuthorizer, NULL_AUTHORIZER_MESSAGE);
        Objects.requireNonNull(allowedPackages, NULL_PACKAGE_MESSAGE);
        this.restrictedMethodAuthorizer = restrictedMethodAuthorizer;
        this.allowedPackages = Collections.unmodifiableSet(allowedPackages);
    }

    @Override
    public boolean authorize(Method method, Object target) {
        if (this.restrictedMethodAuthorizer.isPermanentlyForbiddenMethod(method, target)) {
            return false;
        }
        String packageName = target.getClass().getPackage().getName();
        if (packageName.startsWith(GEODE_BASE_PACKAGE)) {
            return this.restrictedMethodAuthorizer.isAllowedGeodeMethod(method, target);
        }
        String methodName = method.getName();
        if (pattern.matcher(methodName).matches()) {
            if (this.allowedPackages.stream().anyMatch(packageName::startsWith)) {
                return true;
            }
        }
        return this.restrictedMethodAuthorizer.authorize(method, target);
    }

    public Set<String> getAllowedPackages() {
        return this.allowedPackages;
    }
}

