/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeap;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VersionedStatsRegionEntryHeapUUIDKey
extends VersionedStatsRegionEntryHeap {
    private static final AtomicLongFieldUpdater<VersionedStatsRegionEntryHeapUUIDKey> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VersionedStatsRegionEntryHeapUUIDKey.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile Object value;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VersionedStatsRegionEntryHeapUUIDKey> HIT_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VersionedStatsRegionEntryHeapUUIDKey.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VersionedStatsRegionEntryHeapUUIDKey> MISS_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VersionedStatsRegionEntryHeapUUIDKey.class, "missCount");
    private VersionSource memberId;
    private short entryVersionLowBytes;
    private short regionVersionHighBytes;
    private int regionVersionLowBytes;
    private byte entryVersionHighByte;
    private byte distributedSystemId;
    private final long keyMostSigBits;
    private final long keyLeastSigBits;

    public VersionedStatsRegionEntryHeapUUIDKey(RegionEntryContext context, UUID key, Object value) {
        super(context, value);
        this.keyMostSigBits = key.getMostSignificantBits();
        this.keyLeastSigBits = key.getLeastSignificantBits();
    }

    @Override
    protected Object getValueField() {
        return this.value;
    }

    @Override
    protected void setValueField(Object value) {
        this.value = value;
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    @Override
    public void updateStatsForGet(boolean isHit, long time) {
        this.setLastAccessed(time);
        if (isHit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    @Override
    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        HIT_COUNT_UPDATER.incrementAndGet(this);
    }

    private void incrementMissCount() {
        MISS_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        HIT_COUNT_UPDATER.set(this, 0);
        MISS_COUNT_UPDATER.set(this, 0);
    }

    @Override
    public void txDidDestroy(long timeStamp) {
        this.setLastModified(timeStamp);
        this.setLastAccessed(timeStamp);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersionHighByte << 16 & 0xFF0000 | this.entryVersionLowBytes & 0xFFFF;
    }

    @Override
    public long getRegionVersion() {
        return (long)this.regionVersionHighBytes << 32 | (long)this.regionVersionLowBytes & 0xFFFFFFFFL;
    }

    @Override
    public long getVersionTimeStamp() {
        return this.getLastModified();
    }

    @Override
    public void setVersionTimeStamp(long timeStamp) {
        this.setLastModified(timeStamp);
    }

    @Override
    public VersionSource getMemberID() {
        return this.memberId;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void setVersions(VersionTag versionTag) {
        this.memberId = versionTag.getMemberID();
        int eVersion = versionTag.getEntryVersion();
        this.entryVersionLowBytes = (short)(eVersion & 0xFFFF);
        this.entryVersionHighByte = (byte)((eVersion & 0xFF0000) >> 16);
        this.regionVersionHighBytes = versionTag.getRegionVersionHighBytes();
        this.regionVersionLowBytes = versionTag.getRegionVersionLowBytes();
        if (!versionTag.isGatewayTag() && this.distributedSystemId == versionTag.getDistributedSystemId()) {
            if (this.getVersionTimeStamp() <= versionTag.getVersionTimeStamp()) {
                this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
            } else {
                versionTag.setVersionTimeStamp(this.getVersionTimeStamp());
            }
        } else {
            this.setVersionTimeStamp(versionTag.getVersionTimeStamp());
        }
        this.distributedSystemId = (byte)(versionTag.getDistributedSystemId() & 0xFF);
    }

    @Override
    public void setMemberID(VersionSource memberId) {
        this.memberId = memberId;
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    public VersionTag asVersionTag() {
        VersionTag tag = VersionTag.create(this.memberId);
        tag.setEntryVersion(this.getEntryVersion());
        tag.setRegionVersion(this.regionVersionHighBytes, this.regionVersionLowBytes);
        tag.setVersionTimeStamp(this.getVersionTimeStamp());
        tag.setDistributedSystemId(this.distributedSystemId);
        return tag;
    }

    public void processVersionTag(InternalRegion region, VersionTag versionTag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource versionSource, InternalDistributedMember sender, boolean checkForConflicts) {
        this.basicProcessVersionTag(region, versionTag, isTombstoneFromGII, hasDelta, versionSource, sender, checkForConflicts);
    }

    @Override
    public void processVersionTag(EntryEvent cacheEvent) {
        super.processVersionTag(cacheEvent);
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.regionVersionHighBytes;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.regionVersionLowBytes;
    }

    @Override
    public Object getKey() {
        return new UUID(this.keyMostSigBits, this.keyLeastSigBits);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof UUID) {
            UUID uuid = (UUID)key;
            return uuid.getLeastSignificantBits() == this.keyLeastSigBits && uuid.getMostSignificantBits() == this.keyMostSigBits;
        }
        return false;
    }
}

