/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.kafka.LocatorHostPort;
import org.apache.geode.kafka.utils.GeodeConfigurationConstants;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.connect.storage.StringConverter;

public class GeodeConnectorConfig
extends AbstractConfig {
    public static final String DEFAULT_KEY_CONVERTER = StringConverter.class.getCanonicalName();
    public static final String DEFAULT_VALUE_CONVERTER = StringConverter.class.getCanonicalName();
    protected final int taskId;
    protected List<LocatorHostPort> locatorHostPorts;
    private Password securityClientAuthInit;
    private String securityUserName;
    private Password securityPassword;

    @VisibleForTesting
    protected GeodeConnectorConfig() {
        super(new ConfigDef(), new HashMap());
        this.taskId = 0;
    }

    public GeodeConnectorConfig(ConfigDef configDef, Map<String, String> connectorProperties) {
        super(configDef, connectorProperties);
        this.taskId = this.getInt("GEODE_TASK_ID");
        this.locatorHostPorts = this.parseLocators(this.getString("locators"));
        this.securityUserName = this.getString("security-username");
        this.securityPassword = this.getPassword("security-password");
        this.securityClientAuthInit = this.getPassword("security-client-auth-init");
        if (this.usesSecurity()) {
            this.securityClientAuthInit = this.securityClientAuthInit != null ? this.securityClientAuthInit : GeodeConfigurationConstants.DEFAULT_SECURITY_AUTH_INIT;
        }
    }

    protected static ConfigDef configurables() {
        ConfigDef configDef = new ConfigDef();
        configDef.define("GEODE_TASK_ID", ConfigDef.Type.INT, (Object)"0", (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "Internally used to identify each task", "Geode-Configurations", 1, ConfigDef.Width.MEDIUM, "Task ID");
        configDef.define("locators", ConfigDef.Type.STRING, (Object)"localhost[10334]", ConfigDef.Importance.HIGH, "A comma separated string of locators that configure which locators to connect to", "Geode-Configurations", 2, ConfigDef.Width.LONG, "Locators");
        configDef.define("security-username", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Supply a username to be used to authenticate with Geode.  Will automatically set the security-client-auth-init to use a SystemPropertyAuthInit if one isn't supplied by the user", "Geode-Configurations", 3, ConfigDef.Width.MEDIUM, "Apache Geode username");
        configDef.define("security-password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "Supply a password to be used to authenticate with Geode", "Geode-Configurations", 4, ConfigDef.Width.MEDIUM, "Apache Geode Password");
        configDef.define("security-client-auth-init", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "Point to the Java class that implements the [AuthInitialize Interface](https://geode.apache.org/docs/guide/19/managing/security/implementing_authentication.html)", "Geode-Configurations", 5, ConfigDef.Width.LONG, "Authentication Class");
        return configDef;
    }

    public static Map<String, List<String>> parseTopicToRegions(String combinedBindings) {
        return GeodeConnectorConfig.parseRegionToTopics(combinedBindings);
    }

    public static Map<String, List<String>> parseRegionToTopics(String combinedBindings) {
        if (combinedBindings == null || combinedBindings.equals("")) {
            return new HashMap<String, List<String>>();
        }
        List<String> bindings = GeodeConnectorConfig.parseBindings(combinedBindings);
        return bindings.stream().map(GeodeConnectorConfig::parseBinding).collect(Collectors.toMap(regionToTopicsArray -> regionToTopicsArray[0], regionToTopicsArray -> GeodeConnectorConfig.parseStringByComma(regionToTopicsArray[1])));
    }

    public static List<String> parseBindings(String bindings) {
        return Arrays.stream(bindings.split("](\\s)*,")).map(s -> {
            s = s.replaceAll("\\[", "");
            s = s.replaceAll("]", "");
            s = s.trim();
            return s;
        }).collect(Collectors.toList());
    }

    private static String[] parseBinding(String binding) {
        return binding.split(":");
    }

    public static List<String> parseStringByComma(String string) {
        return GeodeConnectorConfig.parseStringBy(string, ",");
    }

    public static List<String> parseStringBy(String string, String regex) {
        return Arrays.stream(string.split(regex)).map(String::trim).collect(Collectors.toList());
    }

    public static String reconstructString(Collection<String> strings) {
        return String.join((CharSequence)"],[", strings);
    }

    List<LocatorHostPort> parseLocators(String locators) {
        return Arrays.stream(locators.split(",")).map(s -> {
            String locatorString = s.trim();
            return this.parseLocator(locatorString);
        }).collect(Collectors.toList());
    }

    private LocatorHostPort parseLocator(String locatorString) {
        String[] splits = locatorString.split("\\[");
        String locator = splits[0];
        int port = Integer.parseInt(splits[1].replace("]", ""));
        return new LocatorHostPort(locator, port);
    }

    public int getTaskId() {
        return this.taskId;
    }

    public List<LocatorHostPort> getLocatorHostPorts() {
        return this.locatorHostPorts;
    }

    public String getSecurityClientAuthInit() {
        return this.securityClientAuthInit == null ? null : this.securityClientAuthInit.value();
    }

    public String getSecurityUserName() {
        return this.securityUserName;
    }

    public String getSecurityPassword() {
        return this.securityPassword == null ? null : this.securityPassword.value();
    }

    public boolean usesSecurity() {
        return this.securityClientAuthInit != null || this.securityUserName != null;
    }
}

