/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.admin.remote.RemoteObjectName;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ObjectNamesResponse
extends AdminResponse
implements Cancellable {
    private HashSet objectNames;
    private transient boolean cancelled;

    public static ObjectNamesResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        ObjectNamesResponse m = new ObjectNamesResponse();
        m.setRecipient(recipient);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildNames(Region r) {
        if (this.cancelled) {
            return;
        }
        Set nameSet = r.keySet();
        Iterator it = nameSet.iterator();
        this.objectNames = new HashSet();
        Region region = r;
        synchronized (region) {
            while (it.hasNext() && !this.cancelled) {
                Object name = it.next();
                if (name instanceof String || name instanceof Number) {
                    this.objectNames.add(name);
                    continue;
                }
                this.objectNames.add(new RemoteObjectName(name));
            }
        }
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    public Set getNameSet() {
        return new HashSet(this.objectNames);
    }

    public int getDSFID() {
        return 1040;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.objectNames, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.objectNames = (HashSet)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "ObjectNamesResponse from " + this.getRecipient();
    }
}

