/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.serialization.DSCODE;
import org.apache.geode.internal.tcp.ByteBufferInputStream;

public class PdxString
implements Comparable<PdxString>,
Sendable {
    private final byte[] bytes;
    private final int offset;
    private final byte header;

    public PdxString(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.header = bytes[offset];
        this.offset = this.calcOffset(this.header, offset);
    }

    public PdxString(String s) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(s.length());
        try {
            DataSerializer.writeString(s, new DataOutputStream(bos));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.bytes = bos.toByteArray();
        this.header = this.bytes[0];
        this.offset = this.calcOffset(this.header, 0);
    }

    private int calcOffset(int header, int offset) {
        ++offset;
        if (header == DSCODE.STRING_BYTES.toByte() || header == DSCODE.STRING.toByte()) {
            offset += 2;
        } else if (header == DSCODE.HUGE_STRING_BYTES.toByte() || header == DSCODE.HUGE_STRING.toByte()) {
            offset += 4;
        }
        return offset;
    }

    private int getLength() {
        int length = 0;
        int lenOffset = this.offset;
        if (this.header == DSCODE.STRING_BYTES.toByte() || this.header == DSCODE.STRING.toByte()) {
            byte a = this.bytes[lenOffset -= 2];
            byte b = this.bytes[lenOffset + 1];
            length = (a & 0xFF) << 8 | b & 0xFF;
        } else if (this.header == DSCODE.HUGE_STRING_BYTES.toByte() || this.header == DSCODE.HUGE_STRING.toByte()) {
            byte a = this.bytes[lenOffset -= 4];
            byte b = this.bytes[lenOffset + 1];
            byte c = this.bytes[lenOffset + 2];
            byte d = this.bytes[lenOffset + 3];
            length = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
        }
        return length;
    }

    @Override
    public int compareTo(PdxString o) {
        if (this.header != o.header) {
            int diff = this.toString().compareTo(o.toString());
            return diff;
        }
        int len1 = this.getLength();
        int len2 = o.getLength();
        int n = Math.min(len1, len2);
        int i = this.offset;
        int j = o.offset;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                byte c1 = this.bytes[k];
                byte c2 = o.bytes[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                byte c2;
                byte c1;
                if ((c1 = this.bytes[i++]) == (c2 = o.bytes[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public int hashCode() {
        int h = 0;
        int len = this.getLength();
        if (len > 0) {
            int off = this.offset;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + this.bytes[off++];
            }
        }
        return h;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof PdxString) {
            PdxString o = (PdxString)anObject;
            if (this.header != o.header) {
                return false;
            }
            int n = this.getLength();
            if (n == o.getLength()) {
                int i = this.offset;
                int j = o.offset;
                while (n-- != 0) {
                    if (this.bytes[i++] == o.bytes[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = null;
        int headerOffset = this.offset;
        try {
            --headerOffset;
            if (this.header == DSCODE.STRING_BYTES.toByte() || this.header == DSCODE.STRING.toByte()) {
                headerOffset -= 2;
            } else if (this.header == DSCODE.HUGE_STRING_BYTES.toByte() || this.header == DSCODE.HUGE_STRING.toByte()) {
                headerOffset -= 4;
            }
            ByteBuffer stringByteBuffer = ByteBuffer.wrap(this.bytes, headerOffset, this.bytes.length - headerOffset);
            s = DataSerializer.readString(new ByteBufferInputStream(stringByteBuffer));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return s;
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        int offset = this.offset;
        int len = this.getLength();
        --offset;
        ++len;
        if (this.header == DSCODE.STRING_BYTES.toByte() || this.header == DSCODE.STRING.toByte()) {
            len += 2;
            offset -= 2;
        } else if (this.header == DSCODE.HUGE_STRING_BYTES.toByte() || this.header == DSCODE.HUGE_STRING.toByte()) {
            len += 4;
            offset -= 4;
        }
        out.write(this.bytes, offset, len);
    }
}

