/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.SchemaParserFactory;
import com.linkedin.data.schema.resolver.ClasspathResourceDataSchemaResolver;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.jersey.core.util.MultivaluedMap;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.restli.common.HttpMethod;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.docgen.ResourceSchemaCollection;
import com.linkedin.restli.docgen.RestLiDocumentationRenderer;
import com.linkedin.restli.docgen.RestLiHTMLDocumentationRenderer;
import com.linkedin.restli.docgen.RestLiJSONDocumentationRenderer;
import com.linkedin.restli.docgen.RestLiResourceRelationship;
import com.linkedin.restli.docgen.VelocityTemplatingEngine;
import com.linkedin.restli.internal.server.model.ResourceModel;
import com.linkedin.restli.server.RestLiConfig;
import com.linkedin.restli.server.RestLiDocumentationRequestHandler;
import com.linkedin.restli.server.RoutingException;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DefaultDocumentationRequestHandler
implements RestLiDocumentationRequestHandler {
    private static final String DOC_PREFIX = "restli";
    private static final String DOC_VIEW_DOCS_ACTION = "docs";
    private static final String DOC_RESOURCE_TYPE = "rest";
    private static final String DOC_DATA_TYPE = "data";
    private static final String DOC_JSON_FORMAT = "json";
    private static final int BAOS_BUFFER_SIZE = 8192;
    private RestLiHTMLDocumentationRenderer _htmlRenderer;
    private RestLiJSONDocumentationRenderer _jsonRenderer;

    public void initialize(RestLiConfig config, Map<String, ResourceModel> rootResources) {
        ClasspathResourceDataSchemaResolver schemaResolver = new ClasspathResourceDataSchemaResolver(SchemaParserFactory.instance());
        ResourceSchemaCollection resourceSchemas = ResourceSchemaCollection.loadOrCreateResourceSchema(rootResources);
        RestLiResourceRelationship relationships = new RestLiResourceRelationship(resourceSchemas, (DataSchemaResolver)schemaResolver);
        this._htmlRenderer = new RestLiHTMLDocumentationRenderer(config.getServerNodeUri(), relationships, new VelocityTemplatingEngine(), (DataSchemaResolver)schemaResolver);
        this._jsonRenderer = new RestLiJSONDocumentationRenderer(relationships);
    }

    public boolean isDocumentationRequest(Request request) {
        String path = request.getURI().getRawPath();
        List pathSegments = UriComponent.decodePath((String)path, (boolean)true);
        return pathSegments.size() > 2 && DOC_PREFIX.equals(((UriComponent.PathSegment)pathSegments.get(1)).getPath()) && DOC_VIEW_DOCS_ACTION.equals(((UriComponent.PathSegment)pathSegments.get(2)).getPath()) || HttpMethod.valueOf((String)request.getMethod()) == HttpMethod.OPTIONS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestResponse processDocumentationRequest(Request request) {
        RestLiDocumentationRenderer renderer;
        String path = request.getURI().getRawPath();
        List pathSegments = UriComponent.decodePath((String)path, (boolean)true);
        String prefixSegment = null;
        String actionSegment = null;
        String typeSegment = null;
        String objectSegment = null;
        switch (pathSegments.size()) {
            case 5: {
                objectSegment = ((UriComponent.PathSegment)pathSegments.get(4)).getPath();
            }
            case 4: {
                typeSegment = ((UriComponent.PathSegment)pathSegments.get(3)).getPath();
            }
            case 3: {
                actionSegment = ((UriComponent.PathSegment)pathSegments.get(2)).getPath();
            }
            case 2: {
                prefixSegment = ((UriComponent.PathSegment)pathSegments.get(1)).getPath();
            }
        }
        assert (prefixSegment.equals(DOC_PREFIX) || HttpMethod.valueOf((String)request.getMethod()) == HttpMethod.OPTIONS);
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        if (HttpMethod.valueOf((String)request.getMethod()) == HttpMethod.OPTIONS) {
            renderer = this._jsonRenderer;
            renderer.renderResource(prefixSegment, out);
            return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
        }
        if (HttpMethod.valueOf((String)request.getMethod()) != HttpMethod.GET) throw new RoutingException(HttpStatus.S_405_METHOD_NOT_ALLOWED.getCode());
        if (!DOC_VIEW_DOCS_ACTION.equals(actionSegment)) {
            throw DefaultDocumentationRequestHandler.createRoutingError(path);
        }
        MultivaluedMap queryMap = UriComponent.decodeQuery((String)request.getURI().getQuery(), (boolean)false);
        List formatList = (List)queryMap.get((Object)"format");
        if (formatList == null) {
            renderer = this._htmlRenderer;
        } else {
            if (formatList.size() > 1) {
                throw new RoutingException(String.format("\"format\" query parameter must be unique, where multiple are specified: %s", Arrays.toString(formatList.toArray())), HttpStatus.S_400_BAD_REQUEST.getCode());
            }
            RestLiDocumentationRenderer restLiDocumentationRenderer = renderer = formatList.contains(DOC_JSON_FORMAT) ? this._jsonRenderer : this._htmlRenderer;
        }
        if (renderer == this._htmlRenderer) {
            this._htmlRenderer.setJsonFormatUri(UriBuilder.fromUri((URI)request.getURI()).queryParam("format", new Object[]{DOC_JSON_FORMAT}).build(new Object[0]));
        }
        try {
            if (typeSegment == null || typeSegment.isEmpty()) {
                renderer.renderHome(out);
                return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
            } else if (DOC_RESOURCE_TYPE.equals(typeSegment)) {
                if (objectSegment == null || objectSegment.isEmpty()) {
                    renderer.renderResourceHome(out);
                    return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
                } else {
                    renderer.renderResource(objectSegment, out);
                }
                return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
            } else {
                if (!DOC_DATA_TYPE.equals(typeSegment)) throw DefaultDocumentationRequestHandler.createRoutingError(path);
                if (objectSegment == null || objectSegment.isEmpty()) {
                    renderer.renderDataModelHome(out);
                    return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
                } else {
                    renderer.renderDataModel(objectSegment, out);
                }
            }
            return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
        }
        catch (RuntimeException e) {
            if (renderer.handleException(e, out)) return ((RestResponseBuilder)((RestResponseBuilder)new RestResponseBuilder().setStatus(HttpStatus.S_200_OK.getCode())).setHeader("Content-Type", renderer.getMIMEType())).setEntity(out.toByteArray()).build();
            throw e;
        }
    }

    private static RoutingException createRoutingError(String path) {
        return new RoutingException(String.format("Invalid documentation path %s", path), HttpStatus.S_404_NOT_FOUND.getCode());
    }
}

