/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.restli.docgen.BaseResourceSchemaVisitor;
import com.linkedin.restli.docgen.Graph;
import com.linkedin.restli.docgen.Node;
import com.linkedin.restli.docgen.ResourceSchemaCollection;
import com.linkedin.restli.docgen.ResourceSchemaVisitior;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.AssocKeySchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.IdentifierSchema;
import com.linkedin.restli.restspec.MetadataSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.server.ResourceLevel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class RestLiResourceRelationship {
    private final ResourceSchemaCollection _resourceSchemas;
    private final DataSchemaResolver _schemaResolver;
    private final PegasusSchemaParser _schemaParser;
    private final SortedMap<String, NamedDataSchema> _dataModels = new TreeMap<String, NamedDataSchema>();
    private final Graph _relationships = new Graph();

    public RestLiResourceRelationship(ResourceSchemaCollection resourceSchemas, DataSchemaResolver schemaResolver) {
        this._resourceSchemas = resourceSchemas;
        this._schemaResolver = schemaResolver;
        this._schemaParser = null;
        this.findDataModels();
    }

    public RestLiResourceRelationship(ResourceSchemaCollection resourceSchemas, PegasusSchemaParser schemaParser) {
        this._resourceSchemas = resourceSchemas;
        this._schemaResolver = null;
        this._schemaParser = schemaParser;
        this.findDataModels();
    }

    public ResourceSchemaCollection getResourceSchemaCollection() {
        return this._resourceSchemas;
    }

    public Set<String> getSchemaNames() {
        return Collections.unmodifiableSet(this._schemaParser.getResolver().bindings().keySet());
    }

    public SortedMap<String, NamedDataSchema> getDataModels() {
        return this._dataModels;
    }

    public <T> Node<T> getRelationships(T o) {
        return this._relationships.get(o);
    }

    private NamedDataSchema extractSchema(String className) {
        if (this._schemaParser == null) {
            StringBuilder errorMessage = new StringBuilder();
            NamedDataSchema schema = this._schemaResolver.findDataSchema(className, errorMessage);
            if (errorMessage.length() > 0) {
                return null;
            }
            return schema;
        }
        DataSchema schema = this._schemaParser.lookupName(className);
        return schema instanceof RecordDataSchema ? (RecordDataSchema)schema : null;
    }

    private void findDataModels() {
        BaseResourceSchemaVisitor visitor = new BaseResourceSchemaVisitor(){

            @Override
            public void visitResourceSchema(ResourceSchemaVisitior.VisitContext visitContext, ResourceSchema resourceSchema) {
                NamedDataSchema schemaSchema;
                String schema = resourceSchema.getSchema();
                if (schema != null && (schemaSchema = RestLiResourceRelationship.this.extractSchema(schema)) != null) {
                    this.connectSchemaToResource(visitContext, schemaSchema);
                }
            }

            @Override
            public void visitCollectionResource(ResourceSchemaVisitior.VisitContext visitContext, CollectionSchema collectionSchema) {
                NamedDataSchema paramsSchema;
                String params;
                IdentifierSchema id = collectionSchema.getIdentifier();
                NamedDataSchema typeSchema = RestLiResourceRelationship.this.extractSchema(id.getType());
                if (typeSchema != null) {
                    this.connectSchemaToResource(visitContext, typeSchema);
                }
                if ((params = id.getParams()) != null && (paramsSchema = RestLiResourceRelationship.this.extractSchema(params)) != null) {
                    this.connectSchemaToResource(visitContext, paramsSchema);
                }
            }

            @Override
            public void visitAssociationResource(ResourceSchemaVisitior.VisitContext visitContext, AssociationSchema associationSchema) {
                for (AssocKeySchema key : associationSchema.getAssocKeys()) {
                    NamedDataSchema keyTypeSchema = RestLiResourceRelationship.this.extractSchema(key.getType());
                    if (keyTypeSchema == null) continue;
                    this.connectSchemaToResource(visitContext, keyTypeSchema);
                }
            }

            @Override
            public void visitParameter(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, Object parentMethodSchema, ParameterSchema parameterSchema) {
                String parameterTypeString = parameterSchema.getType();
                if (this.isInlineSchema(parameterTypeString)) {
                    this.visitInlineSchema(visitContext, parameterTypeString);
                } else {
                    NamedDataSchema schema = parameterSchema.hasItems() ? RestLiResourceRelationship.this.extractSchema(parameterSchema.getItems()) : RestLiResourceRelationship.this.extractSchema(parameterTypeString);
                    if (schema != null) {
                        this.connectSchemaToResource(visitContext, schema);
                    }
                }
            }

            @Override
            public void visitFinder(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, FinderSchema finderSchema) {
                NamedDataSchema metadataTypeSchema;
                MetadataSchema metadata = finderSchema.getMetadata();
                if (metadata != null && (metadataTypeSchema = RestLiResourceRelationship.this.extractSchema(metadata.getType())) != null) {
                    this.connectSchemaToResource(visitContext, metadataTypeSchema);
                }
            }

            @Override
            public void visitAction(ResourceSchemaVisitior.VisitContext visitContext, RecordTemplate parentResource, ResourceLevel resourceLevel, ActionSchema actionSchema) {
                StringArray throwsArray;
                String returns = actionSchema.getReturns();
                if (returns != null) {
                    if (this.isInlineSchema(returns)) {
                        this.visitInlineSchema(visitContext, returns);
                    } else {
                        NamedDataSchema returnsSchema = RestLiResourceRelationship.this.extractSchema(returns);
                        if (returnsSchema != null) {
                            this.connectSchemaToResource(visitContext, returnsSchema);
                        }
                    }
                }
                if ((throwsArray = actionSchema.getThrows()) != null) {
                    for (String errorName : throwsArray) {
                        NamedDataSchema errorSchema = RestLiResourceRelationship.this.extractSchema(errorName);
                        if (errorSchema == null) continue;
                        this.connectSchemaToResource(visitContext, errorSchema);
                    }
                }
            }

            private boolean isInlineSchema(String schemaString) {
                return schemaString.startsWith("{");
            }

            private void visitInlineSchema(ResourceSchemaVisitior.VisitContext visitContext, String schemaString) {
                DataSchema valueSchema;
                DataSchema itemSchema;
                DataSchema schema = DataTemplateUtil.parseSchema((String)schemaString, (DataSchemaResolver)RestLiResourceRelationship.this._schemaResolver);
                if (schema instanceof ArrayDataSchema && (itemSchema = ((ArrayDataSchema)schema).getItems()) instanceof NamedDataSchema) {
                    this.connectSchemaToResource(visitContext, (NamedDataSchema)itemSchema);
                }
                if (schema instanceof MapDataSchema && (valueSchema = ((MapDataSchema)schema).getValues()) instanceof NamedDataSchema) {
                    this.connectSchemaToResource(visitContext, (NamedDataSchema)valueSchema);
                }
            }

            private void connectSchemaToResource(ResourceSchemaVisitior.VisitContext visitContext, final NamedDataSchema schema) {
                final Node<NamedDataSchema> schemaNode = RestLiResourceRelationship.this._relationships.get(schema);
                RestLiResourceRelationship.this._dataModels.put(schema.getFullName(), schema);
                DataSchemaTraverse traveler = new DataSchemaTraverse();
                traveler.traverse((DataSchema)schema, new DataSchemaTraverse.Callback(){

                    public void callback(List<String> path, DataSchema nestedSchema) {
                        if (nestedSchema instanceof RecordDataSchema && nestedSchema != schema) {
                            RecordDataSchema nestedRecordSchema = (RecordDataSchema)nestedSchema;
                            RestLiResourceRelationship.this._dataModels.put(nestedRecordSchema.getFullName(), nestedRecordSchema);
                            Node<RecordDataSchema> node = RestLiResourceRelationship.this._relationships.get(nestedRecordSchema);
                            schemaNode.addAdjacentNode(node);
                        }
                    }
                });
                Node<ResourceSchema> resourceNode = RestLiResourceRelationship.this._relationships.get(visitContext.getParentSchema());
                resourceNode.addAdjacentNode(schemaNode);
                schemaNode.addAdjacentNode(resourceNode);
            }
        };
        ResourceSchemaCollection.visitResources(this._resourceSchemas.getResources().values(), visitor);
    }
}

