/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.multipart;

import com.linkedin.data.ByteString;
import com.linkedin.multipart.MultiPartMIMEDataSourceWriter;
import com.linkedin.r2.message.stream.entitystream.WriteHandle;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class MultiPartMIMEInputStream
implements MultiPartMIMEDataSourceWriter {
    public static final int DEFAULT_MAXIMUM_BLOCKING_DURATION = 3000;
    public static final int DEFAULT_WRITE_CHUNK_SIZE = 5000;
    public static final int DEFAULT_ABORT_INPUT_STREAM_TIMEOUT = 5000;
    private volatile WriteHandle _writeHandle;
    private final Map<String, String> _headers;
    private final InputStream _inputStream;
    private volatile boolean _dataSourceFinished = false;
    private final ExecutorService _executorService;
    private final int _maximumBlockingTime;
    private final int _writeChunkSize;
    private final int _abortTimeout;
    private volatile Future<?> _currentReadTask = null;

    public void onInit(WriteHandle wh) {
        this._writeHandle = wh;
    }

    public void onWritePossible() {
        this._currentReadTask = this._executorService.submit(new InputStreamReaderManager());
    }

    public void onAbort(Throwable e) {
        this._executorService.submit(new InputStreamCloser());
    }

    @Override
    public Map<String, String> dataSourceHeaders() {
        return Collections.unmodifiableMap(this._headers);
    }

    private MultiPartMIMEInputStream(InputStream inputStream, ExecutorService executorService, Map<String, String> headers, int maximumBlockingTime, int writeChunkSize, int abortTimeout) {
        this._inputStream = inputStream;
        this._executorService = executorService;
        this._headers = new HashMap<String, String>(headers);
        this._maximumBlockingTime = maximumBlockingTime;
        this._writeChunkSize = writeChunkSize;
        this._abortTimeout = abortTimeout;
    }

    public static class Builder {
        private final InputStream _inputStream;
        private final ExecutorService _executorService;
        private final Map<String, String> _headers;
        private int _maximumBlockingTime = 3000;
        private int _writeChunkSize = 5000;
        private int _abortTimeout = 5000;

        public Builder(InputStream inputStream, ExecutorService executorService, Map<String, String> headers) {
            this._inputStream = inputStream;
            this._executorService = executorService;
            this._headers = headers;
        }

        public Builder withMaximumBlockingTime(int maximumBlockingTime) {
            this._maximumBlockingTime = maximumBlockingTime;
            return this;
        }

        public Builder withWriteChunkSize(int writeChunkSize) {
            this._writeChunkSize = writeChunkSize;
            return this;
        }

        public Builder withDefaultAbortInputStreamTimeout(int abortTimeout) {
            this._abortTimeout = abortTimeout;
            return this;
        }

        public MultiPartMIMEInputStream build() {
            return new MultiPartMIMEInputStream(this._inputStream, this._executorService, this._headers, this._maximumBlockingTime, this._writeChunkSize, this._abortTimeout);
        }
    }

    private class InputStreamReader
    implements Runnable {
        private final CountDownLatch _countDownLatch;
        private ByteString _result = null;
        private Throwable _error = null;

        @Override
        public void run() {
            try {
                byte[] bytes = new byte[MultiPartMIMEInputStream.this._writeChunkSize];
                int bytesRead = MultiPartMIMEInputStream.this._inputStream.read(bytes);
                if (bytesRead == -1) {
                    MultiPartMIMEInputStream.this._dataSourceFinished = true;
                    this._result = ByteString.empty();
                } else if (bytesRead == MultiPartMIMEInputStream.this._writeChunkSize) {
                    this._result = ByteString.copy((byte[])bytes);
                } else {
                    MultiPartMIMEInputStream.this._dataSourceFinished = true;
                    this._result = ByteString.copy((byte[])bytes, (int)0, (int)bytesRead);
                }
            }
            catch (IOException ioException) {
                this._error = ioException;
            }
            finally {
                this._countDownLatch.countDown();
            }
        }

        private InputStreamReader(CountDownLatch latch) {
            this._countDownLatch = latch;
        }
    }

    private class InputStreamReaderManager
    implements Runnable {
        private InputStreamReaderManager() {
        }

        @Override
        public void run() {
            while (MultiPartMIMEInputStream.this._writeHandle.remaining() > 0) {
                CountDownLatch latch = new CountDownLatch(1);
                InputStreamReader inputStreamReader = new InputStreamReader(latch);
                MultiPartMIMEInputStream.this._executorService.submit(inputStreamReader);
                try {
                    boolean nonTimeoutFinish = latch.await(MultiPartMIMEInputStream.this._maximumBlockingTime, TimeUnit.MILLISECONDS);
                    if (nonTimeoutFinish) {
                        if (inputStreamReader._result != null) {
                            if (MultiPartMIMEInputStream.this._dataSourceFinished) {
                                if (!inputStreamReader._result.equals((Object)ByteString.empty())) {
                                    MultiPartMIMEInputStream.this._writeHandle.write(inputStreamReader._result);
                                }
                                MultiPartMIMEInputStream.this._writeHandle.done();
                                try {
                                    MultiPartMIMEInputStream.this._inputStream.close();
                                }
                                catch (IOException iOException) {}
                                break;
                            }
                            MultiPartMIMEInputStream.this._writeHandle.write(inputStreamReader._result);
                            continue;
                        }
                        try {
                            MultiPartMIMEInputStream.this._inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        MultiPartMIMEInputStream.this._writeHandle.error(inputStreamReader._error);
                        break;
                    }
                    try {
                        MultiPartMIMEInputStream.this._inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    MultiPartMIMEInputStream.this._writeHandle.error((Throwable)new TimeoutException("InputStream reading timed out"));
                }
                catch (InterruptedException exception) {
                    try {
                        MultiPartMIMEInputStream.this._inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    MultiPartMIMEInputStream.this._writeHandle.error((Throwable)exception);
                }
                break;
            }
        }
    }

    private class InputStreamCloser
    implements Runnable {
        private InputStreamCloser() {
        }

        @Override
        public void run() {
            try {
                if (MultiPartMIMEInputStream.this._currentReadTask != null) {
                    MultiPartMIMEInputStream.this._currentReadTask.get(MultiPartMIMEInputStream.this._abortTimeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (TimeoutException timeoutException) {
            }
            finally {
                try {
                    MultiPartMIMEInputStream.this._inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

