/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.hive;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HivePartition;
import org.apache.gobblin.hive.HivePartitionComparator;
import org.apache.gobblin.hive.HiveRegProps;
import org.apache.gobblin.hive.HiveRegistrationUnit;
import org.apache.gobblin.hive.HiveRegistrationUnitComparator;
import org.apache.gobblin.hive.HiveTable;
import org.apache.gobblin.hive.HiveTableComparator;
import org.apache.gobblin.hive.spec.HiveSpec;
import org.apache.gobblin.hive.spec.HiveSpecWithPostActivities;
import org.apache.gobblin.hive.spec.HiveSpecWithPreActivities;
import org.apache.gobblin.hive.spec.HiveSpecWithPredicates;
import org.apache.gobblin.hive.spec.activity.Activity;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.executors.ScalingThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public abstract class HiveRegister
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HiveRegister.class);
    public static final String HIVE_REGISTER_TYPE = "hive.register.type";
    public static final String DEFAULT_HIVE_REGISTER_TYPE = "org.apache.gobblin.hive.metastore.HiveMetaStoreBasedRegister";
    public static final String HIVE_TABLE_COMPARATOR_TYPE = "hive.table.comparator.type";
    public static final String DEFAULT_HIVE_TABLE_COMPARATOR_TYPE = HiveTableComparator.class.getName();
    public static final String HIVE_PARTITION_COMPARATOR_TYPE = "hive.partition.comparator.type";
    public static final String DEFAULT_HIVE_PARTITION_COMPARATOR_TYPE = HivePartitionComparator.class.getName();
    public static final String HIVE_METASTORE_URI_KEY = "hive.metastore.uri";
    protected static final String HIVE_DB_EXTENSION = ".db";
    protected final HiveRegProps props;
    protected final Optional<String> hiveDbRootDir;
    protected final ListeningExecutorService executor;
    protected final Map<String, Future<Void>> futures = Maps.newConcurrentMap();

    protected HiveRegister(State state) {
        this.props = new HiveRegProps(state);
        this.hiveDbRootDir = this.props.getDbRootDir();
        this.executor = ExecutorsUtils.loggingDecorator((ExecutorService)ScalingThreadPoolExecutor.newScalingThreadPool((int)0, (int)this.props.getNumThreads(), (long)TimeUnit.SECONDS.toMillis(10L), (ThreadFactory)ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)this.getClass().getSimpleName()))));
    }

    public ListenableFuture<Void> register(final HiveSpec spec) {
        ListenableFuture future = this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (spec instanceof HiveSpecWithPredicates && !HiveRegister.this.evaluatePredicates((HiveSpecWithPredicates)spec)) {
                    log.info("Skipping " + spec + " since predicates return false");
                    return null;
                }
                if (spec instanceof HiveSpecWithPreActivities) {
                    for (Activity activity : ((HiveSpecWithPreActivities)spec).getPreActivities()) {
                        activity.execute(HiveRegister.this);
                    }
                }
                HiveRegister.this.registerPath(spec);
                if (spec instanceof HiveSpecWithPostActivities) {
                    for (Activity activity : ((HiveSpecWithPostActivities)spec).getPostActivities()) {
                        activity.execute(HiveRegister.this);
                    }
                }
                return null;
            }
        });
        this.futures.put(this.getSpecId(spec), (Future<Void>)future);
        return future;
    }

    private String getSpecId(HiveSpec spec) {
        Optional<HivePartition> partition = spec.getPartition();
        if (partition.isPresent()) {
            return String.format("%s.%s@%s", spec.getTable().getDbName(), spec.getTable().getTableName(), Arrays.toString(((HivePartition)partition.get()).getValues().toArray()));
        }
        return String.format("%s.%s", spec.getTable().getDbName(), spec.getTable().getTableName());
    }

    private boolean evaluatePredicates(HiveSpecWithPredicates spec) {
        for (Predicate<HiveRegister> pred : spec.getPredicates()) {
            if (pred.apply((Object)this)) continue;
            return false;
        }
        return true;
    }

    protected abstract void registerPath(HiveSpec var1) throws IOException;

    public abstract boolean createDbIfNotExists(String var1) throws IOException;

    public abstract boolean createTableIfNotExists(HiveTable var1) throws IOException;

    public abstract boolean addPartitionIfNotExists(HiveTable var1, HivePartition var2) throws IOException;

    public abstract boolean existsTable(String var1, String var2) throws IOException;

    public abstract boolean existsPartition(String var1, String var2, List<HiveRegistrationUnit.Column> var3, List<String> var4) throws IOException;

    public abstract void dropTableIfExists(String var1, String var2) throws IOException;

    public abstract void dropPartitionIfExists(String var1, String var2, List<HiveRegistrationUnit.Column> var3, List<String> var4) throws IOException;

    public abstract Optional<HiveTable> getTable(String var1, String var2) throws IOException;

    public abstract Optional<HivePartition> getPartition(String var1, String var2, List<HiveRegistrationUnit.Column> var3, List<String> var4) throws IOException;

    public abstract void alterTable(HiveTable var1) throws IOException;

    public abstract void alterPartition(HiveTable var1, HivePartition var2) throws IOException;

    public void createOrAlterTable(HiveTable table) throws IOException {
        if (!this.createTableIfNotExists(table)) {
            this.alterTable(table);
        }
    }

    public void addOrAlterPartition(HiveTable table, HivePartition partition) throws IOException {
        if (!this.addPartitionIfNotExists(table, partition)) {
            this.alterPartition(table, partition);
        }
    }

    protected HiveRegistrationUnitComparator<?> getTableComparator(HiveTable existingTable, HiveTable newTable) {
        try {
            Class<?> clazz = Class.forName(this.props.getProp(HIVE_TABLE_COMPARATOR_TYPE, DEFAULT_HIVE_TABLE_COMPARATOR_TYPE));
            return (HiveRegistrationUnitComparator)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[]{existingTable, newTable});
        }
        catch (ReflectiveOperationException e) {
            log.error("Unable to instantiate Hive table comparator", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected boolean needToUpdateTable(HiveTable existingTable, HiveTable newTable) {
        return ((HiveRegistrationUnitComparator)this.getTableComparator(existingTable, newTable).compareAll()).result();
    }

    protected HiveRegistrationUnitComparator<?> getPartitionComparator(HivePartition existingPartition, HivePartition newPartition) {
        try {
            Class<?> clazz = Class.forName(this.props.getProp(HIVE_PARTITION_COMPARATOR_TYPE, DEFAULT_HIVE_PARTITION_COMPARATOR_TYPE));
            return (HiveRegistrationUnitComparator)ConstructorUtils.invokeConstructor(clazz, (Object[])new Object[]{existingPartition, newPartition});
        }
        catch (ReflectiveOperationException e) {
            log.error("Unable to instantiate Hive partition comparator", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected boolean needToUpdatePartition(HivePartition existingPartition, HivePartition newPartition) {
        return ((HiveRegistrationUnitComparator)this.getPartitionComparator(existingPartition, newPartition).compareAll()).result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        try {
            for (Map.Entry<String, Future<Void>> entry : this.futures.entrySet()) {
                try {
                    entry.getValue().get();
                }
                catch (ExecutionException ee) {
                    throw new IOException("Failed to finish registration for " + entry.getKey(), ee.getCause());
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            ExecutorsUtils.shutdownExecutorService((ExecutorService)this.executor, (Optional)Optional.of((Object)log));
        }
    }

    public static HiveRegister get(State props) {
        Optional metastoreUri = Optional.fromNullable((Object)props.getProperties().getProperty(HIVE_METASTORE_URI_KEY));
        return HiveRegister.get(props, (Optional<String>)metastoreUri);
    }

    public static HiveRegister get(State props, Optional<String> metastoreURI) {
        return HiveRegister.get(props.getProp(HIVE_REGISTER_TYPE, DEFAULT_HIVE_REGISTER_TYPE), props, metastoreURI);
    }

    public static HiveRegister get(String hiveRegisterType, State props, Optional<String> metastoreURI) {
        try {
            return (HiveRegister)ConstructorUtils.invokeConstructor(Class.forName(hiveRegisterType), (Object[])new Object[]{props, metastoreURI});
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HiveRegProps getProps() {
        return this.props;
    }
}

