/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.GobblinHelixJobLauncher;
import org.apache.gobblin.runtime.JobLauncher;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.scheduler.BaseGobblinJob;
import org.apache.gobblin.scheduler.JobScheduler;
import org.apache.hadoop.fs.Path;
import org.apache.helix.HelixManager;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinHelixJob
extends BaseGobblinJob
implements InterruptableJob {
    private static final Logger log = LoggerFactory.getLogger(GobblinHelixJob.class);
    private Future cancellable = null;

    public void executeImpl(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        ConcurrentHashMap runningMap = (ConcurrentHashMap)dataMap.get((Object)"jobRunningMap");
        JobScheduler jobScheduler = (JobScheduler)dataMap.get((Object)"jobScheduler");
        Properties jobProps = (Properties)((Properties)dataMap.get((Object)"jobProps")).clone();
        JobListener jobListener = (JobListener)dataMap.get((Object)"jobListener");
        HelixManager helixManager = (HelixManager)dataMap.get((Object)"helixManager");
        Path appWorkDir = (Path)dataMap.get((Object)"applicationWorkDir");
        List eventMetadata = (List)dataMap.get((Object)"metadataTags");
        try {
            GobblinHelixJobLauncher jobLauncher = new GobblinHelixJobLauncher(jobProps, helixManager, appWorkDir, eventMetadata, runningMap);
            if (Boolean.valueOf(jobProps.getProperty("gobblin.cluster.job.executeInSchedulingThread", Boolean.toString(true))).booleanValue()) {
                jobScheduler.runJob(jobProps, jobListener, (JobLauncher)jobLauncher);
            } else {
                this.cancellable = jobScheduler.scheduleJobImmediately(jobProps, jobListener, (JobLauncher)jobLauncher);
            }
        }
        catch (Throwable t) {
            throw new JobExecutionException(t);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        if (this.cancellable != null) {
            try {
                if (this.cancellable.cancel(false)) {
                    return;
                }
            }
            catch (Exception e) {
                log.error("Failed to gracefully cancel job. Attempting to force cancellation.", (Throwable)e);
            }
            try {
                this.cancellable.cancel(true);
            }
            catch (Exception e) {
                throw new UnableToInterruptJobException((Throwable)e);
            }
        }
    }
}

