/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.gobblin.compaction.Compactor;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.compaction.dataset.DatasetsFinder;
import org.apache.gobblin.compaction.dataset.TimeBasedSubDirDatasetsFinder;
import org.apache.gobblin.compaction.event.CompactionSlaEventHelper;
import org.apache.gobblin.compaction.listeners.CompactorCompletionListener;
import org.apache.gobblin.compaction.listeners.CompactorCompletionListenerFactory;
import org.apache.gobblin.compaction.listeners.CompactorListener;
import org.apache.gobblin.compaction.mapreduce.MRCompactorJobPropCreator;
import org.apache.gobblin.compaction.mapreduce.MRCompactorJobRunner;
import org.apache.gobblin.compaction.verify.DataCompletenessVerifier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ClusterNameTags;
import org.apache.gobblin.util.DatasetFilterUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.FileListUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.gobblin.util.recordcount.CompactionRecordCountProvider;
import org.apache.gobblin.util.recordcount.IngestionRecordCountProvider;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MRCompactor
implements Compactor {
    private static final Logger LOG = LoggerFactory.getLogger(MRCompactor.class);
    public static final String COMPACTION_PREFIX = "compaction.";
    public static final String COMPACTION_THREAD_POOL_SIZE = "compaction.thread.pool.size";
    public static final int DEFAULT_COMPACTION_THREAD_POOL_SIZE = 30;
    public static final String COMPACTION_INPUT_DIR = "compaction.input.dir";
    public static final String COMPACTION_INPUT_SUBDIR = "compaction.input.subdir";
    public static final String DEFAULT_COMPACTION_INPUT_SUBDIR = "hourly";
    public static final String COMPACTION_DEST_DIR = "compaction.dest.dir";
    public static final String COMPACTION_DEST_SUBDIR = "compaction.dest.subdir";
    public static final String DEFAULT_COMPACTION_DEST_SUBDIR = "daily";
    public static final String COMPACTION_TMP_DEST_DIR = "compaction.tmp.dest.dir";
    public static final String DEFAULT_COMPACTION_TMP_DEST_DIR = "/tmp/gobblin-compaction";
    public static final String COMPACTION_JOB_DIR = "compaction.tmp.job.dir";
    public static final String COMPACTION_LATE_DIR_SUFFIX = "_late";
    public static final String COMPACTION_BLACKLIST = "compaction.blacklist";
    public static final String COMPACTION_WHITELIST = "compaction.whitelist";
    public static final String COMPACTION_HIGH_PRIORITY_TOPICS = "compaction.high.priority.topics";
    public static final String COMPACTION_NORMAL_PRIORITY_TOPICS = "compaction.normal.priority.topics";
    public static final String COMPACTION_JOB_RUNNER_CLASS = "compaction.job.runner.class";
    public static final String DEFAULT_COMPACTION_JOB_RUNNER_CLASS = "org.apache.gobblin.compaction.mapreduce.avro.MRCompactorAvroKeyDedupJobRunner";
    public static final String COMPACTION_TIMEZONE = "compaction.timezone";
    public static final String DEFAULT_COMPACTION_TIMEZONE = "America/Los_Angeles";
    public static final String COMPACTION_FILE_SYSTEM_URI = "compaction.file.system.uri";
    public static final String COMPACTION_MR_JOB_TIMEOUT_MINUTES = "compaction.mr.job.timeout.minutes";
    public static final long DEFAULT_COMPACTION_MR_JOB_TIMEOUT_MINUTES = Long.MAX_VALUE;
    public static final String COMPACTION_DATASETS_FINDER = "compaction.datasets.finder";
    public static final String DEFAULT_COMPACTION_DATASETS_FINDER = TimeBasedSubDirDatasetsFinder.class.getName();
    public static final String COMPACTION_DATASETS_MAX_COUNT = "compaction.datasets.max.count";
    public static final double DEFUALT_COMPACTION_DATASETS_MAX_COUNT = 1.0E9;
    public static final String COMPACTION_RENAME_SOURCE_DIR_ENABLED = "compaction.rename.source.dir.enabled";
    public static final boolean DEFAULT_COMPACTION_RENAME_SOURCE_DIR_ENABLED = false;
    public static final String COMPACTION_RENAME_SOURCE_DIR_SUFFIX = "_COMPLETE";
    public static final String COMPACTION_INPUT_RECORD_COUNT_PROVIDER = "compaction.input.record.count.provider";
    public static final String DEFAULT_COMPACTION_INPUT_RECORD_COUNT_PROVIDER = IngestionRecordCountProvider.class.getName();
    public static final String COMPACTION_OUTPUT_RECORD_COUNT_PROVIDER = "compaction.output.record.count.provider";
    public static final String DEFAULT_COMPACTION_OUTPUT_RECORD_COUNT_PROVIDER = CompactionRecordCountProvider.class.getName();
    public static final String COMPACTION_RECOMPACT_FROM_INPUT_FOR_LATE_DATA = "compaction.recompact.from.input.for.late.data";
    public static final boolean DEFAULT_COMPACTION_RECOMPACT_FROM_INPUT_FOR_LATE_DATA = false;
    public static final String COMPACTION_LATEDATA_THRESHOLD_FOR_RECOMPACT_PER_DATASET = "compaction.latedata.threshold.for.recompact.per.topic";
    public static final double DEFAULT_COMPACTION_LATEDATA_THRESHOLD_FOR_RECOMPACT_PER_DATASET = 1.0;
    public static final String COMPACTION_LATEDATA_THRESHOLD_FILE_NUM = "compaction.latedata.threshold.file.num";
    public static final int DEFAULT_COMPACTION_LATEDATA_THRESHOLD_FILE_NUM = 1000;
    public static final String COMPACTION_LATEDATA_THRESHOLD_DURATION = "compaction.latedata.threshold.duration";
    public static final String DEFAULT_COMPACTION_LATEDATA_THRESHOLD_DURATION = "24h";
    public static final String COMPACTION_RECOMPACT_CONDITION = "compaction.recompact.condition";
    public static final String DEFAULT_COMPACTION_RECOMPACT_CONDITION = "RecompactBasedOnRatio";
    public static final String COMPACTION_RECOMPACT_COMBINE_CONDITIONS = "compaction.recompact.combine.conditions";
    public static final String COMPACTION_RECOMPACT_COMBINE_CONDITIONS_OPERATION = "compaction.recompact.combine.conditions.operation";
    public static final String DEFAULT_COMPACTION_RECOMPACT_COMBINE_CONDITIONS_OPERATION = "or";
    public static final String COMPACTION_COMPLETE_LISTERNER = "compaction.complete.listener";
    public static final String DEFAULT_COMPACTION_COMPLETE_LISTERNER = "SimpleCompactorCompletionHook";
    public static final String COMPACTION_INPUT_DEDUPLICATED = "compaction.input.deduplicated";
    public static final boolean DEFAULT_COMPACTION_INPUT_DEDUPLICATED = false;
    public static final String COMPACTION_OUTPUT_DEDUPLICATED = "compaction.output.deduplicated";
    public static final boolean DEFAULT_COMPACTION_OUTPUT_DEDUPLICATED = true;
    public static final String COMPACTION_COMPLETENESS_VERIFICATION_PREFIX = "compaction.completeness.verification.";
    public static final String COMPACTION_RECOMPACT_FROM_DEST_PATHS = "compaction.recompact.from.dest.paths";
    public static final String COMPACTION_RECOMPACT_ALL_DATA = "compaction.recompact.all.data";
    public static final boolean DEFAULT_COMPACTION_RECOMPACT_FROM_DEST_PATHS = false;
    public static final boolean DEFAULT_COMPACTION_RECOMPACT_ALL_DATA = true;
    public static final String COMPACTION_COMPLETENESS_VERIFICATION_BLACKLIST = "compaction.completeness.verification.blacklist";
    public static final String COMPACTION_COMPLETENESS_VERIFICATION_WHITELIST = "compaction.completeness.verification.whitelist";
    public static final String COMPACTION_VERIFICATION_TIMEOUT_MINUTES = "compaction.completeness.verification.timeout.minutes";
    public static final long DEFAULT_COMPACTION_VERIFICATION_TIMEOUT_MINUTES = 30L;
    public static final String COMPACTION_COMPLETENESS_VERIFICATION_ENABLED = "compaction.completeness.verification.enabled";
    public static final boolean DEFAULT_COMPACTION_COMPLETENESS_VERIFICATION_ENABLED = false;
    public static final String COMPACTION_COMPLETENESS_VERIFICATION_NUM_DATASETS_VERIFIED_TOGETHER = "compaction.completeness.verification.num.datasets.verified.together";
    public static final int DEFAULT_COMPACTION_COMPLETENESS_VERIFICATION_NUM_DATASETS_VERIFIED_TOGETHER = 10;
    public static final String COMPACTION_COMPLETENESS_VERIFICATION_PUBLISH_DATA_IF_CANNOT_VERIFY = "compaction.completeness.verification.publish.data.if.cannot.verify";
    public static final boolean DEFAULT_COMPACTION_COMPLETENESS_VERIFICATION_PUBLISH_DATA_IF_CANNOT_VERIFY = false;
    public static final String COMPACTION_SHOULD_DEDUPLICATE = "compaction.should.deduplicate";
    public static final String COMPACTION_JOB_DEST_PARTITION = "compaction.job.dest.partition";
    public static final String COMPACTION_ENABLE_SUCCESS_FILE = "compaction.fileoutputcommitter.marksuccessfuljobs";
    public static final String COMPACTION_JOB_LATE_DATA_MOVEMENT_TASK = "compaction.job.late.data.movement.task";
    public static final String COMPACTION_JOB_LATE_DATA_FILES = "compaction.job.late.data.files";
    public static final String COMPACTION_COMPLETE_FILE_NAME = "_COMPACTION_COMPLETE";
    public static final String COMPACTION_LATE_FILES_DIRECTORY = "late";
    public static final String COMPACTION_JARS = "compaction.jars";
    public static final String COMPACTION_JAR_SUBDIR = "_gobblin_compaction_jars";
    public static final String COMPACTION_TRACKING_EVENTS_NAMESPACE = "compaction.tracking.events";
    public static final String COMPACTION_INPUT_PATH_TIME = "compaction.input.path.time";
    public static final String COMPACTION_FILE_EXTENSION = "compaction.extension";
    private static final long COMPACTION_JOB_WAIT_INTERVAL_SECONDS = 10L;
    private static final Map<Dataset, Job> RUNNING_MR_JOBS = Maps.newConcurrentMap();
    private final State state = new State();
    private final List<? extends Tag<?>> tags;
    private final Configuration conf;
    private final String tmpOutputDir;
    private final FileSystem fs;
    private final JobRunnerExecutor jobExecutor;
    private final Set<Dataset> datasets;
    private final Map<Dataset, MRCompactorJobRunner> jobRunnables;
    private final Closer closer;
    private final Optional<DataCompletenessVerifier> verifier;
    private final Stopwatch stopwatch;
    private final GobblinMetrics gobblinMetrics;
    private final EventSubmitter eventSubmitter;
    private final Optional<CompactorListener> compactorListener;
    private final DateTime initilizeTime;
    private final long dataVerifTimeoutMinutes;
    private final long compactionTimeoutMinutes;
    private final boolean shouldVerifDataCompl;
    private final boolean shouldPublishDataIfCannotVerifyCompl;
    private final CompactorCompletionListener compactionCompleteListener;

    public MRCompactor(Properties props, List<? extends Tag<?>> tags, Optional<CompactorListener> compactorListener) throws IOException {
        this.state.addAll(props);
        this.initilizeTime = this.getCurrentTime();
        this.tags = tags;
        this.conf = HadoopUtils.getConfFromState((State)this.state);
        this.tmpOutputDir = this.getTmpOutputDir();
        this.fs = this.getFileSystem();
        this.datasets = this.getDatasetsFinder().findDistinctDatasets();
        this.jobExecutor = this.createJobExecutor();
        this.jobRunnables = Maps.newConcurrentMap();
        this.closer = Closer.create();
        this.stopwatch = Stopwatch.createStarted();
        this.gobblinMetrics = this.initializeMetrics();
        this.eventSubmitter = new EventSubmitter.Builder(GobblinMetrics.get((String)this.state.getProp("job.name")).getMetricContext(), COMPACTION_TRACKING_EVENTS_NAMESPACE).build();
        this.compactorListener = compactorListener;
        this.dataVerifTimeoutMinutes = this.getDataVerifTimeoutMinutes();
        this.compactionTimeoutMinutes = this.getCompactionTimeoutMinutes();
        this.shouldVerifDataCompl = this.shouldVerifyDataCompleteness();
        this.compactionCompleteListener = this.getCompactionCompleteListener();
        this.verifier = this.shouldVerifDataCompl ? Optional.of((Object)this.closer.register((Closeable)new DataCompletenessVerifier(this.state))) : Optional.absent();
        this.shouldPublishDataIfCannotVerifyCompl = this.shouldPublishDataIfCannotVerifyCompl();
    }

    public DateTime getInitializeTime() {
        return this.initilizeTime;
    }

    private String getTmpOutputDir() {
        return this.state.getProp(COMPACTION_TMP_DEST_DIR, DEFAULT_COMPACTION_TMP_DEST_DIR);
    }

    private FileSystem getFileSystem() throws IOException {
        if (this.state.contains(COMPACTION_FILE_SYSTEM_URI)) {
            URI uri = URI.create(this.state.getProp(COMPACTION_FILE_SYSTEM_URI));
            return FileSystem.get((URI)uri, (Configuration)this.conf);
        }
        return FileSystem.get((Configuration)this.conf);
    }

    private DatasetsFinder getDatasetsFinder() {
        try {
            return (DatasetsFinder)Class.forName(this.state.getProp(COMPACTION_DATASETS_FINDER, DEFAULT_COMPACTION_DATASETS_FINDER)).getConstructor(State.class).newInstance(this.state);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initiailize DatasetsFinder.", e);
        }
    }

    private DateTime getCurrentTime() {
        DateTimeZone timeZone = DateTimeZone.forID((String)this.state.getProp(COMPACTION_TIMEZONE, DEFAULT_COMPACTION_TIMEZONE));
        return new DateTime(timeZone);
    }

    private JobRunnerExecutor createJobExecutor() {
        int threadPoolSize = this.getThreadPoolSize();
        PriorityBlockingQueue<Runnable> queue = new PriorityBlockingQueue<Runnable>();
        return new JobRunnerExecutor(threadPoolSize, threadPoolSize, Long.MAX_VALUE, TimeUnit.NANOSECONDS, queue);
    }

    private int getThreadPoolSize() {
        return this.state.getPropAsInt(COMPACTION_THREAD_POOL_SIZE, 30);
    }

    private GobblinMetrics initializeMetrics() {
        ImmutableList.Builder tags = ImmutableList.builder();
        tags.addAll(this.tags);
        tags.addAll((Iterable)Tag.fromMap((Map)ClusterNameTags.getClusterNameTags()));
        GobblinMetrics gobblinMetrics = GobblinMetrics.get((String)this.state.getProp("job.name"), null, (List)tags.build());
        gobblinMetrics.startMetricReporting(this.state.getProperties());
        return gobblinMetrics;
    }

    @Override
    public void compact() throws IOException {
        try {
            this.copyDependencyJarsToHdfs();
            this.processDatasets();
            this.throwExceptionsIfAnyDatasetCompactionFailed();
            this.onCompactionCompletion();
        }
        catch (Throwable t) {
            LOG.error("Caught throwable during compaction", t);
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            try {
                this.shutdownExecutors();
                this.closer.close();
            }
            finally {
                this.deleteDependencyJars();
                this.gobblinMetrics.stopMetricsReporting();
            }
        }
    }

    private CompactorCompletionListener getCompactionCompleteListener() {
        ClassAliasResolver classAliasResolver = new ClassAliasResolver(CompactorCompletionListenerFactory.class);
        String listenerName = this.state.getProp(COMPACTION_COMPLETE_LISTERNER, DEFAULT_COMPACTION_COMPLETE_LISTERNER);
        try {
            CompactorCompletionListenerFactory factory = (CompactorCompletionListenerFactory)GobblinConstructorUtils.invokeFirstConstructor((Class)classAliasResolver.resolveClass(listenerName), (List[])new List[]{ImmutableList.of()});
            return factory.createCompactorCompactionListener(this.state);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void onCompactionCompletion() {
        this.compactionCompleteListener.onCompactionCompletion(this);
    }

    private void copyDependencyJarsToHdfs() throws IOException {
        if (!this.state.contains("job.jars")) {
            return;
        }
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)this.conf);
        Path tmpJarFileDir = new Path(this.tmpOutputDir, COMPACTION_JAR_SUBDIR);
        this.state.setProp(COMPACTION_JARS, (Object)tmpJarFileDir.toString());
        this.fs.delete(tmpJarFileDir, true);
        for (String jarFile : this.state.getPropAsList("job.jars")) {
            for (FileStatus status : lfs.globStatus(new Path(jarFile))) {
                Path tmpJarFile = new Path(this.fs.makeQualified(tmpJarFileDir), status.getPath().getName());
                this.fs.copyFromLocalFile(status.getPath(), tmpJarFile);
                LOG.info(String.format("%s will be added to classpath", tmpJarFile));
            }
        }
    }

    private void deleteDependencyJars() throws IllegalArgumentException, IOException {
        if (this.state.contains(COMPACTION_JARS)) {
            this.fs.delete(new Path(this.state.getProp(COMPACTION_JARS)), true);
        }
    }

    private void processDatasets() {
        this.createJobPropsForDatasets();
        this.processCompactionJobs();
    }

    private void createJobPropsForDatasets() {
        HashSet datasetsWithProps = Sets.newHashSet();
        for (Dataset dataset : this.datasets) {
            datasetsWithProps.addAll(this.createJobPropsForDataset(dataset));
        }
        this.datasets.clear();
        this.datasets.addAll(datasetsWithProps);
    }

    private List<Dataset> createJobPropsForDataset(Dataset dataset) {
        ImmutableList datasetsWithProps;
        LOG.info("Creating compaction jobs for dataset " + dataset + " with priority " + dataset.priority());
        MRCompactorJobPropCreator jobPropCreator = this.getJobPropCreator(dataset);
        try {
            datasetsWithProps = jobPropCreator.createJobProps();
        }
        catch (Throwable t) {
            datasetsWithProps = ImmutableList.of((Object)jobPropCreator.createFailedJobProps(t));
        }
        return datasetsWithProps;
    }

    MRCompactorJobPropCreator getJobPropCreator(Dataset dataset) {
        try {
            return new MRCompactorJobPropCreator.Builder().withDataset(dataset).withFileSystem(this.fs).withState(this.state).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Dataset> getDatasets() {
        return this.datasets;
    }

    private void processCompactionJobs() {
        if (this.shouldVerifDataCompl) {
            this.verifyDataCompleteness();
        } else {
            this.setAllDatasetStatesToVerified();
        }
        this.submitCompactionJobsAndWaitForCompletion();
    }

    private boolean shouldVerifyDataCompleteness() {
        return this.state.getPropAsBoolean(COMPACTION_COMPLETENESS_VERIFICATION_ENABLED, false);
    }

    private void verifyDataCompleteness() {
        List blacklist = DatasetFilterUtils.getPatternList((State)this.state, (String)COMPACTION_COMPLETENESS_VERIFICATION_BLACKLIST);
        List whitelist = DatasetFilterUtils.getPatternList((State)this.state, (String)COMPACTION_COMPLETENESS_VERIFICATION_WHITELIST);
        int numDatasetsVerifiedTogether = this.getNumDatasetsVerifiedTogether();
        ArrayList datasetsToBeVerified = Lists.newArrayList();
        for (Dataset dataset : this.datasets) {
            if (dataset.state() != Dataset.DatasetState.UNVERIFIED) continue;
            if (this.shouldVerifyCompletenessForDataset(dataset, blacklist, whitelist)) {
                datasetsToBeVerified.add(dataset);
                if (datasetsToBeVerified.size() < numDatasetsVerifiedTogether) continue;
                ListenableFuture<DataCompletenessVerifier.Results> future = ((DataCompletenessVerifier)this.verifier.get()).verify(datasetsToBeVerified);
                this.addCallback(datasetsToBeVerified, future);
                datasetsToBeVerified = Lists.newArrayList();
                continue;
            }
            dataset.setState(Dataset.DatasetState.VERIFIED);
        }
        if (!datasetsToBeVerified.isEmpty()) {
            ListenableFuture<DataCompletenessVerifier.Results> future = ((DataCompletenessVerifier)this.verifier.get()).verify(datasetsToBeVerified);
            this.addCallback(datasetsToBeVerified, future);
        }
    }

    private boolean shouldVerifyCompletenessForDataset(Dataset dataset, List<Pattern> blacklist, List<Pattern> whitelist) {
        boolean renamingRequired = this.state.getPropAsBoolean(COMPACTION_RENAME_SOURCE_DIR_ENABLED, false);
        LOG.info("Should verify completeness with renaming source dir : " + renamingRequired);
        return !MRCompactor.datasetAlreadyCompacted(this.fs, dataset, renamingRequired) && DatasetFilterUtils.survived((String)dataset.getName(), blacklist, whitelist);
    }

    public static Set<Path> getDeepestLevelRenamedDirsWithFileExistence(FileSystem fs, Set<Path> paths) throws IOException {
        HashSet renamedDirs = Sets.newHashSet();
        for (FileStatus fileStatus : FileListUtils.listFilesRecursively((FileSystem)fs, paths)) {
            if (!fileStatus.getPath().getParent().toString().endsWith(COMPACTION_RENAME_SOURCE_DIR_SUFFIX)) continue;
            renamedDirs.add(fileStatus.getPath().getParent());
        }
        return renamedDirs;
    }

    public static Set<Path> getDeepestLevelUnrenamedDirsWithFileExistence(FileSystem fs, Set<Path> paths) throws IOException {
        HashSet unrenamed = Sets.newHashSet();
        for (FileStatus fileStatus : FileListUtils.listFilesRecursively((FileSystem)fs, paths)) {
            if (fileStatus.getPath().getParent().toString().endsWith(COMPACTION_RENAME_SOURCE_DIR_SUFFIX)) continue;
            unrenamed.add(fileStatus.getPath().getParent());
        }
        return unrenamed;
    }

    public static void renameSourceDirAsCompactionComplete(FileSystem fs, Dataset dataset) {
        try {
            for (Path path : dataset.getRenamePaths()) {
                Path newPath = new Path(path.getParent(), path.getName() + COMPACTION_RENAME_SOURCE_DIR_SUFFIX);
                LOG.info("[{}] Renaming {} to {}", new Object[]{dataset.getDatasetName(), path, newPath});
                fs.rename(path, newPath);
            }
        }
        catch (Exception e) {
            LOG.error("Rename input path failed", (Throwable)e);
        }
    }

    public static boolean datasetAlreadyCompacted(FileSystem fs, Dataset dataset, boolean renameSourceEnable) {
        if (renameSourceEnable) {
            return MRCompactor.checkAlreadyCompactedBasedOnSourceDirName(fs, dataset);
        }
        return MRCompactor.checkAlreadyCompactedBasedOnCompletionFile(fs, dataset);
    }

    private static boolean checkAlreadyCompactedBasedOnSourceDirName(FileSystem fs, Dataset dataset) {
        try {
            Set<Path> renamedDirs = MRCompactor.getDeepestLevelRenamedDirsWithFileExistence(fs, dataset.inputPaths());
            return !renamedDirs.isEmpty();
        }
        catch (IOException e) {
            LOG.error("Failed to get deepest directories from source", (Throwable)e);
            return false;
        }
    }

    private static boolean checkAlreadyCompactedBasedOnCompletionFile(FileSystem fs, Dataset dataset) {
        Path filePath = new Path(dataset.outputPath(), COMPACTION_COMPLETE_FILE_NAME);
        try {
            return fs.exists(filePath);
        }
        catch (IOException e) {
            LOG.error("Failed to verify the existence of file " + filePath, (Throwable)e);
            return false;
        }
    }

    public static long readCompactionTimestamp(FileSystem fs, Path compactionOutputPath) throws IOException {
        Path completionFilePath = new Path(compactionOutputPath, COMPACTION_COMPLETE_FILE_NAME);
        try (FSDataInputStream completionFileStream = fs.open(completionFilePath);){
            long l = completionFileStream.readLong();
            return l;
        }
    }

    private void addCallback(final List<Dataset> datasetsToBeVerified, ListenableFuture<DataCompletenessVerifier.Results> future) {
        Futures.addCallback(future, (FutureCallback)new FutureCallback<DataCompletenessVerifier.Results>(){

            public void onSuccess(DataCompletenessVerifier.Results results) {
                ArrayList datasetsToBeVerifiedAgain = Lists.newArrayList();
                block4: for (DataCompletenessVerifier.Results.Result result : results) {
                    Optional jobRunner = Optional.fromNullable(MRCompactor.this.jobRunnables.get(result.dataset()));
                    switch (result.status()) {
                        case PASSED: {
                            LOG.info("Completeness verification for dataset " + result.dataset() + " passed.");
                            MRCompactor.this.submitVerificationSuccessSlaEvent(result);
                            result.dataset().setState(Dataset.DatasetState.VERIFIED);
                            if (!jobRunner.isPresent()) continue block4;
                            ((MRCompactorJobRunner)jobRunner.get()).proceed();
                            continue block4;
                        }
                        case FAILED: {
                            if (MRCompactor.this.shouldGiveUpVerification()) {
                                LOG.info("Completeness verification for dataset " + result.dataset() + " has timed out.");
                                MRCompactor.this.submitVerificationSuccessSlaEvent(result);
                                result.dataset().setState(Dataset.DatasetState.GIVEN_UP);
                                result.dataset().addThrowable(new RuntimeException(String.format("Completeness verification for dataset %s failed or timed out.", result.dataset())));
                                continue block4;
                            }
                            LOG.info("Completeness verification for dataset " + result.dataset() + " failed. Will verify again.");
                            datasetsToBeVerifiedAgain.add(result.dataset());
                            continue block4;
                        }
                    }
                    throw new IllegalStateException("Unrecognized result status: " + (Object)((Object)result.status()));
                }
                if (!datasetsToBeVerifiedAgain.isEmpty()) {
                    ListenableFuture<DataCompletenessVerifier.Results> future2 = ((DataCompletenessVerifier)MRCompactor.this.verifier.get()).verify(datasetsToBeVerifiedAgain);
                    MRCompactor.this.addCallback(datasetsToBeVerifiedAgain, (ListenableFuture<DataCompletenessVerifier.Results>)future2);
                }
            }

            public void onFailure(Throwable t) {
                LOG.error("Failed to verify completeness for the following datasets: " + datasetsToBeVerified, t);
                if (MRCompactor.this.shouldGiveUpVerification()) {
                    for (Dataset dataset : datasetsToBeVerified) {
                        LOG.warn(String.format("Completeness verification for dataset %s has timed out.", dataset));
                        MRCompactor.this.submitFailureSlaEvent(dataset, "CompletenessCannotBeVerified");
                        dataset.setState(Dataset.DatasetState.GIVEN_UP);
                        dataset.addThrowable(new RuntimeException(String.format("Completeness verification for dataset %s failed or timed out.", dataset)));
                    }
                } else {
                    ListenableFuture<DataCompletenessVerifier.Results> future2 = ((DataCompletenessVerifier)MRCompactor.this.verifier.get()).verify(datasetsToBeVerified);
                    MRCompactor.this.addCallback(datasetsToBeVerified, (ListenableFuture<DataCompletenessVerifier.Results>)future2);
                }
            }
        });
    }

    private int getNumDatasetsVerifiedTogether() {
        return this.state.getPropAsInt(COMPACTION_COMPLETENESS_VERIFICATION_NUM_DATASETS_VERIFIED_TOGETHER, 10);
    }

    private void setAllDatasetStatesToVerified() {
        for (Dataset dataset : this.datasets) {
            dataset.compareAndSetState(Dataset.DatasetState.UNVERIFIED, Dataset.DatasetState.VERIFIED);
        }
    }

    private boolean shouldGiveUpVerification() {
        return this.stopwatch.elapsed(TimeUnit.MINUTES) >= this.dataVerifTimeoutMinutes;
    }

    private boolean shouldPublishDataIfCannotVerifyCompl() {
        return this.state.getPropAsBoolean(COMPACTION_COMPLETENESS_VERIFICATION_PUBLISH_DATA_IF_CANNOT_VERIFY, false);
    }

    private void submitCompactionJobsAndWaitForCompletion() {
        LOG.info("Submitting compaction jobs. Number of datasets: " + this.datasets.size());
        boolean allDatasetsCompleted = false;
        while (!allDatasetsCompleted) {
            allDatasetsCompleted = true;
            for (Dataset dataset : this.datasets) {
                MRCompactorJobRunner jobRunner = this.jobRunnables.get(dataset);
                if (dataset.state() == Dataset.DatasetState.VERIFIED || dataset.state() == Dataset.DatasetState.UNVERIFIED) {
                    allDatasetsCompleted = false;
                    if (jobRunner != null && jobRunner.status() != MRCompactorJobRunner.Status.ABORTED) continue;
                    this.runCompactionForDataset(dataset, dataset.state() == Dataset.DatasetState.VERIFIED);
                    continue;
                }
                if (dataset.state() != Dataset.DatasetState.GIVEN_UP) continue;
                if (this.shouldPublishDataIfCannotVerifyCompl) {
                    allDatasetsCompleted = false;
                    if (jobRunner == null || jobRunner.status() == MRCompactorJobRunner.Status.ABORTED) {
                        this.runCompactionForDataset(dataset, true);
                        continue;
                    }
                    jobRunner.proceed();
                    continue;
                }
                if (jobRunner == null) continue;
                jobRunner.abort();
            }
            if (this.stopwatch.elapsed(TimeUnit.MINUTES) >= this.compactionTimeoutMinutes) {
                LOG.error("Compaction timed-out. Killing all running jobs");
                for (MRCompactorJobRunner jobRunner : this.jobRunnables.values()) {
                    jobRunner.abort();
                }
                break;
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while waiting", e);
            }
        }
    }

    private void runCompactionForDataset(Dataset dataset, boolean proceed) {
        LOG.info("Running compaction for dataset " + dataset);
        try {
            MRCompactorJobRunner jobRunner = this.getMRCompactorJobRunner(dataset);
            this.jobRunnables.put(dataset, jobRunner);
            if (proceed) {
                jobRunner.proceed();
            }
            this.jobExecutor.execute(jobRunner);
        }
        catch (Throwable t) {
            dataset.skip(t);
        }
    }

    private MRCompactorJobRunner getMRCompactorJobRunner(Dataset dataset) {
        try {
            Class<?> cls = Class.forName(this.state.getProp(COMPACTION_JOB_RUNNER_CLASS, DEFAULT_COMPACTION_JOB_RUNNER_CLASS));
            return (MRCompactorJobRunner)cls.getDeclaredConstructor(Dataset.class, FileSystem.class).newInstance(dataset, this.fs);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate MRCompactorJobRunner", e);
        }
    }

    public static void addRunningHadoopJob(Dataset dataset, Job job) {
        RUNNING_MR_JOBS.put(dataset, job);
    }

    private long getCompactionTimeoutMinutes() {
        return this.state.getPropAsLong(COMPACTION_MR_JOB_TIMEOUT_MINUTES, Long.MAX_VALUE);
    }

    private long getDataVerifTimeoutMinutes() {
        return this.state.getPropAsLong(COMPACTION_VERIFICATION_TIMEOUT_MINUTES, 30L);
    }

    private void throwExceptionsIfAnyDatasetCompactionFailed() {
        Set<Dataset> datasetsWithThrowables = this.getDatasetsWithThrowables();
        int numDatasetsWithThrowables = 0;
        for (Dataset dataset : datasetsWithThrowables) {
            ++numDatasetsWithThrowables;
            for (Throwable t : dataset.throwables()) {
                LOG.error("Error processing dataset " + dataset, t);
                this.submitFailureSlaEvent(dataset, "CompactionFailed");
            }
        }
        if (numDatasetsWithThrowables > 0) {
            throw new RuntimeException(String.format("Failed to process %d datasets.", numDatasetsWithThrowables));
        }
    }

    private Set<Dataset> getDatasetsWithThrowables() {
        HashSet datasetsWithThrowables = Sets.newHashSet();
        for (Dataset dataset : this.datasets) {
            if (dataset.throwables().isEmpty()) continue;
            datasetsWithThrowables.add(dataset);
        }
        return datasetsWithThrowables;
    }

    private void shutdownExecutors() {
        LOG.info("Shutting down Executors");
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.jobExecutor, (Optional)Optional.of((Object)LOG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws IOException {
        try {
            for (Map.Entry<Dataset, Job> entry : RUNNING_MR_JOBS.entrySet()) {
                Job hadoopJob = entry.getValue();
                if (hadoopJob.isComplete()) continue;
                LOG.info(String.format("Killing hadoop job %s for dataset %s", hadoopJob.getJobID(), entry.getKey()));
                hadoopJob.killJob();
            }
        }
        finally {
            try {
                ExecutorsUtils.shutdownExecutorService((ExecutorService)this.jobExecutor, (Optional)Optional.of((Object)LOG), (long)0L, (TimeUnit)TimeUnit.NANOSECONDS);
            }
            finally {
                if (this.verifier.isPresent()) {
                    ((DataCompletenessVerifier)this.verifier.get()).closeNow();
                }
            }
        }
    }

    public static void modifyDatasetStateToRecompact(Dataset dataset) {
        LOG.info("{} changes to recompact mode", (Object)dataset.getDatasetName());
        State recompactState = new State();
        recompactState.setProp(COMPACTION_RECOMPACT_FROM_DEST_PATHS, (Object)Boolean.TRUE);
        recompactState.setProp(COMPACTION_JOB_LATE_DATA_MOVEMENT_TASK, (Object)Boolean.FALSE);
        dataset.modifyDatasetForRecompact(recompactState);
        dataset.setState(Dataset.DatasetState.VERIFIED);
    }

    private void submitVerificationSuccessSlaEvent(DataCompletenessVerifier.Results.Result result) {
        try {
            CompactionSlaEventHelper.getEventSubmitterBuilder(result.dataset(), (Optional<Job>)Optional.absent(), this.fs).eventSubmitter(this.eventSubmitter).eventName("CompletenessVerified").additionalMetadata(Maps.transformValues(result.verificationContext(), (Function)Functions.toStringFunction())).build().submit();
        }
        catch (Throwable t) {
            LOG.warn("Failed to submit verification success event:" + t, t);
        }
    }

    private void submitFailureSlaEvent(Dataset dataset, String eventName) {
        try {
            CompactionSlaEventHelper.getEventSubmitterBuilder(dataset, (Optional<Job>)Optional.absent(), this.fs).eventSubmitter(this.eventSubmitter).eventName(eventName).build().submit();
        }
        catch (Throwable t) {
            LOG.warn("Failed to submit failure sla event:" + t, t);
        }
    }

    private class JobRunnerExecutor
    extends ThreadPoolExecutor {
        public JobRunnerExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Preconditions.checkArgument((boolean)(r instanceof MRCompactorJobRunner), (Object)String.format("Runnable expected to be instance of %s, actual %s", MRCompactorJobRunner.class.getSimpleName(), r.getClass().getSimpleName()));
            MRCompactorJobRunner jobRunner = (MRCompactorJobRunner)r;
            MRCompactor.this.jobRunnables.remove(jobRunner.getDataset());
            if (t == null) {
                if (jobRunner.status() == MRCompactorJobRunner.Status.COMMITTED) {
                    if (jobRunner.getDataset().needToRecompact()) {
                        MRCompactor.modifyDatasetStateToRecompact(jobRunner.getDataset());
                    } else {
                        jobRunner.getDataset().setState(Dataset.DatasetState.COMPACTION_COMPLETE);
                    }
                    if (MRCompactor.this.compactorListener.isPresent()) {
                        try {
                            ((CompactorListener)MRCompactor.this.compactorListener.get()).onDatasetCompactionCompletion(jobRunner.getDataset());
                        }
                        catch (Exception e) {
                            t = e;
                        }
                    }
                } else if (jobRunner.getDataset().state() == Dataset.DatasetState.GIVEN_UP && !MRCompactor.this.shouldPublishDataIfCannotVerifyCompl) {
                    LOG.info(String.format("Dataset %s will not be compacted, since data completeness cannot be verified", jobRunner.getDataset()));
                    jobRunner.getDataset().setState(Dataset.DatasetState.COMPACTION_COMPLETE);
                } else {
                    jobRunner.getDataset().reducePriority();
                }
            }
            if (t != null) {
                this.afterExecuteWithThrowable(jobRunner, t);
            }
        }

        private void afterExecuteWithThrowable(MRCompactorJobRunner jobRunner, Throwable t) {
            jobRunner.getDataset().skip(t);
        }
    }
}

