/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.IdealState;

public abstract class IdealStateBuilder {
    private String resourceName;
    private int numPartitions;
    private int numReplica;
    private int minActiveReplica = -1;
    private long rebalanceDelayInMs = -1L;
    private Boolean delayRebalanceDisabled = null;
    private String stateModel;
    private String stateModelFactoryName = "DEFAULT";
    protected IdealState.RebalanceMode rebalancerMode;
    private String rebalancerClassName;
    private String rebalanceStrategy;
    private int maxPartitionsPerNode;
    private String nodeGroup = "*";
    private Boolean disableExternalView = null;
    private String resourceGroupName;
    private Boolean enableGroupRouting;
    protected ZNRecord _record;

    public IdealStateBuilder(String resourceName) {
        this.resourceName = resourceName;
        this._record = new ZNRecord(resourceName);
    }

    public IdealStateBuilder setNumReplica(int numReplica) {
        this.numReplica = numReplica;
        return this;
    }

    public IdealStateBuilder setMinActiveReplica(int minActiveReplica) {
        this.minActiveReplica = minActiveReplica;
        return this;
    }

    public IdealStateBuilder setRebalanceDelay(int delayInMilliseconds) {
        this.rebalanceDelayInMs = delayInMilliseconds;
        return this;
    }

    public void disableDelayRebalance() {
        this.delayRebalanceDisabled = true;
    }

    public void enableDelayRebalance() {
        this.delayRebalanceDisabled = false;
    }

    public IdealStateBuilder setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
        return this;
    }

    public IdealStateBuilder setStateModel(String stateModel) {
        this.stateModel = stateModel;
        return this;
    }

    public IdealStateBuilder setStateModelFactoryName(String stateModelFactoryName) {
        this.stateModelFactoryName = stateModelFactoryName;
        return this;
    }

    public IdealStateBuilder setMaxPartitionsPerNode(int maxPartitionsPerNode) {
        this.maxPartitionsPerNode = maxPartitionsPerNode;
        return this;
    }

    public IdealStateBuilder setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
        return this;
    }

    public IdealStateBuilder setDisableExternalView(boolean disableExternalView) {
        this.disableExternalView = disableExternalView;
        return this;
    }

    public IdealStateBuilder setRebalancerMode(IdealState.RebalanceMode rebalancerMode) {
        this.rebalancerMode = rebalancerMode;
        return this;
    }

    public IdealStateBuilder setRebalancerClass(String rebalancerClassName) {
        this.rebalancerClassName = rebalancerClassName;
        return this;
    }

    public IdealStateBuilder setRebalanceStrategy(String rebalanceStrategy) {
        this.rebalanceStrategy = rebalanceStrategy;
        return this;
    }

    public IdealStateBuilder setResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public IdealStateBuilder enableGroupRouting() {
        this.enableGroupRouting = true;
        return this;
    }

    public IdealState build() {
        IdealState idealstate = new IdealState(this._record);
        idealstate.setNumPartitions(this.numPartitions);
        idealstate.setStateModelDefRef(this.stateModel);
        idealstate.setStateModelFactoryName(this.stateModelFactoryName);
        idealstate.setRebalanceMode(this.rebalancerMode);
        idealstate.setReplicas("" + this.numReplica);
        if (this.maxPartitionsPerNode > 0) {
            idealstate.setMaxPartitionsPerInstance(this.maxPartitionsPerNode);
        }
        if (this.minActiveReplica >= 0) {
            idealstate.setMinActiveReplicas(this.minActiveReplica);
        }
        if (this.rebalancerClassName != null) {
            idealstate.setRebalancerClassName(this.rebalancerClassName);
        }
        if (this.rebalanceStrategy != null) {
            idealstate.setRebalanceStrategy(this.rebalanceStrategy);
        }
        if (this.maxPartitionsPerNode > 0) {
            idealstate.setMaxPartitionsPerInstance(this.maxPartitionsPerNode);
        }
        if (this.disableExternalView != null) {
            idealstate.setDisableExternalView(this.disableExternalView);
        }
        if (this.resourceGroupName != null) {
            idealstate.setResourceGroupName(this.resourceGroupName);
        }
        if (this.enableGroupRouting != null) {
            idealstate.enableGroupRouting(this.enableGroupRouting);
        }
        if (this.rebalanceDelayInMs >= 0L) {
            idealstate.setRebalanceDelay(this.rebalanceDelayInMs);
        }
        if (this.delayRebalanceDisabled != null) {
            idealstate.setDelayRebalanceDisabled(this.delayRebalanceDisabled);
        }
        if (!idealstate.isValid()) {
            throw new HelixException("invalid ideal-state: " + idealstate);
        }
        return idealstate;
    }
}

