/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitorMBean;
import org.apache.helix.monitoring.mbeans.InstanceMonitor;
import org.apache.helix.monitoring.mbeans.JobMonitor;
import org.apache.helix.monitoring.mbeans.PerInstanceResourceMonitor;
import org.apache.helix.monitoring.mbeans.ResourceMonitor;
import org.apache.helix.monitoring.mbeans.WorkflowMonitor;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;

public class ClusterStatusMonitor
implements ClusterStatusMonitorMBean {
    private static final Logger LOG = Logger.getLogger(ClusterStatusMonitor.class);
    public static final String CLUSTER_STATUS_KEY = "ClusterStatus";
    static final String MESSAGE_QUEUE_STATUS_KEY = "MessageQueueStatus";
    static final String RESOURCE_STATUS_KEY = "ResourceStatus";
    public static final String PARTICIPANT_STATUS_KEY = "ParticipantStatus";
    static final String CLUSTER_DN_KEY = "cluster";
    static final String RESOURCE_DN_KEY = "resourceName";
    static final String INSTANCE_DN_KEY = "instanceName";
    static final String MESSAGE_QUEUE_DN_KEY = "messageQueue";
    static final String WORKFLOW_TYPE_DN_KEY = "workflowType";
    static final String JOB_TYPE_DN_KEY = "jobType";
    static final String DEFAULT_WORKFLOW_JOB_TYPE = "DEFAULT";
    public static final String DEFAULT_TAG = "DEFAULT";
    private final String _clusterName;
    private final MBeanServer _beanServer;
    private Set<String> _liveInstances = Collections.emptySet();
    private Set<String> _instances = Collections.emptySet();
    private Set<String> _disabledInstances = Collections.emptySet();
    private Map<String, Map<String, List<String>>> _disabledPartitions = Collections.emptyMap();
    private Map<String, Long> _instanceMsgQueueSizes = Maps.newConcurrentMap();
    private final ConcurrentHashMap<String, ResourceMonitor> _resourceMbeanMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, InstanceMonitor> _instanceMbeanMap = new ConcurrentHashMap();
    private final Map<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor> _perInstanceResourceMap = new ConcurrentHashMap<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor>();
    private final Map<String, WorkflowMonitor> _perTypeWorkflowMonitorMap = new ConcurrentHashMap<String, WorkflowMonitor>();
    private final Map<String, JobMonitor> _perTypeJobMonitorMap = new ConcurrentHashMap<String, JobMonitor>();

    public ClusterStatusMonitor(String clusterName) {
        this._clusterName = clusterName;
        this._beanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.register(this, this.getObjectName(this.clusterBeanName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to regiter ClusterStatusMonitor", (Throwable)e);
        }
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s: %s", CLUSTER_STATUS_KEY, name));
    }

    public String getBeanName() {
        return "ClusterStatus " + this._clusterName;
    }

    @Override
    public long getDownInstanceGauge() {
        return this._instances.size() - this._liveInstances.size();
    }

    @Override
    public long getInstancesGauge() {
        return this._instances.size();
    }

    @Override
    public long getDisabledInstancesGauge() {
        return this._disabledInstances.size();
    }

    @Override
    public long getDisabledPartitionsGauge() {
        int numDisabled = 0;
        for (Map<String, List<String>> perInstance : this._disabledPartitions.values()) {
            for (List<String> partitions : perInstance.values()) {
                if (partitions == null) continue;
                numDisabled += partitions.size();
            }
        }
        return numDisabled;
    }

    @Override
    public long getMaxMessageQueueSizeGauge() {
        long maxQueueSize = 0L;
        for (Long queueSize : this._instanceMsgQueueSizes.values()) {
            if (queueSize <= maxQueueSize) continue;
            maxQueueSize = queueSize;
        }
        return maxQueueSize;
    }

    @Override
    public long getInstanceMessageQueueBacklog() {
        long sum = 0L;
        for (Long queueSize : this._instanceMsgQueueSizes.values()) {
            sum += queueSize.longValue();
        }
        return sum;
    }

    private void register(Object bean, ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            LOG.info((Object)("Register MBean: " + name));
            this._beanServer.registerMBean(bean, name);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not register MBean: " + name), (Throwable)e);
        }
    }

    private void unregister(ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                LOG.info((Object)("Unregistering " + name.toString()));
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not unregister MBean: " + name), (Throwable)e);
        }
    }

    public void setClusterInstanceStatus(Set<String> liveInstanceSet, Set<String> instanceSet, Set<String> disabledInstanceSet, Map<String, Map<String, List<String>>> disabledPartitions, Map<String, Set<String>> tags) {
        InstanceMonitor bean;
        HashSet toUnregister = Sets.newHashSet((Iterable)this._instanceMbeanMap.keySet());
        toUnregister.removeAll(instanceSet);
        try {
            this.unregisterInstances(toUnregister);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("Could not unregister instances from MBean server: " + toUnregister), (Throwable)e);
        }
        HashSet toRegister = Sets.newHashSet(instanceSet);
        toRegister.removeAll(this._instanceMbeanMap.keySet());
        HashSet monitorsToRegister = Sets.newHashSet();
        for (String instanceName : toRegister) {
            bean = new InstanceMonitor(this._clusterName, instanceName);
            bean.updateInstance(tags.get(instanceName), disabledPartitions.get(instanceName), liveInstanceSet.contains(instanceName), !disabledInstanceSet.contains(instanceName));
            monitorsToRegister.add(bean);
        }
        try {
            this.registerInstances(monitorsToRegister);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("Could not register instances with MBean server: " + toRegister), (Throwable)e);
        }
        this._instances = instanceSet;
        this._liveInstances = liveInstanceSet;
        this._disabledInstances = disabledInstanceSet;
        this._disabledPartitions = disabledPartitions;
        for (String instanceName : instanceSet) {
            if (!this._instanceMbeanMap.containsKey(instanceName)) continue;
            bean = this._instanceMbeanMap.get(instanceName);
            String oldSensorName = bean.getSensorName();
            bean.updateInstance(tags.get(instanceName), disabledPartitions.get(instanceName), liveInstanceSet.contains(instanceName), !disabledInstanceSet.contains(instanceName));
            String newSensorName = bean.getSensorName();
            if (oldSensorName.equals(newSensorName)) continue;
            try {
                this.unregisterInstances(Arrays.asList(instanceName));
                this.registerInstances(Arrays.asList(bean));
            }
            catch (MalformedObjectNameException e) {
                LOG.error((Object)("Could not refresh registration with MBean server: " + instanceName), (Throwable)e);
            }
        }
    }

    public void increaseMessagePerInstance(List<Message> messages) {
        HashMap<String, Long> messageCount = new HashMap<String, Long>();
        for (Message message : messages) {
            String instanceName = message.getAttribute(Message.Attributes.TGT_NAME);
            if (instanceName == null) continue;
            if (!messageCount.containsKey(instanceName)) {
                messageCount.put(instanceName, 0L);
            }
            messageCount.put(instanceName, (Long)messageCount.get(instanceName) + 1L);
        }
        for (String instance : messageCount.keySet()) {
            if (!this._instanceMbeanMap.containsKey(instance)) continue;
            this._instanceMbeanMap.get(instance).updateMessageCount((Long)messageCount.get(instance));
        }
    }

    public void setPerInstanceResourceStatus(BestPossibleStateOutput bestPossibleStates, Map<String, InstanceConfig> instanceConfigMap, Map<String, Resource> resourceMap, Map<String, StateModelDefinition> stateModelDefMap) {
        InstanceConfig config;
        String stateModelDefName;
        PerInstanceResourceMonitor bean;
        HashMap beanMap = new HashMap();
        for (String resource : bestPossibleStates.resourceSet()) {
            Map<Partition, Map<String, String>> partitionStateMap = bestPossibleStates.getResourceMap(resource);
            for (Partition partition : partitionStateMap.keySet()) {
                Map<String, String> instanceStateMap = partitionStateMap.get(partition);
                for (String instance : instanceStateMap.keySet()) {
                    String state = instanceStateMap.get(instance);
                    PerInstanceResourceMonitor.BeanName beanName = new PerInstanceResourceMonitor.BeanName(instance, resource);
                    if (!beanMap.containsKey(beanName)) {
                        beanMap.put(beanName, new HashMap());
                    }
                    ((Map)beanMap.get(beanName)).put(partition, state);
                }
            }
        }
        HashSet toUnregister = Sets.newHashSet(this._perInstanceResourceMap.keySet());
        toUnregister.removeAll(beanMap.keySet());
        try {
            this.unregisterPerInstanceResources(toUnregister);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("Fail to unregister per-instance resource from MBean server: " + toUnregister), (Throwable)e);
        }
        HashSet toRegister = Sets.newHashSet(beanMap.keySet());
        toRegister.removeAll(this._perInstanceResourceMap.keySet());
        HashSet monitorsToRegister = Sets.newHashSet();
        for (PerInstanceResourceMonitor.BeanName beanName : toRegister) {
            bean = new PerInstanceResourceMonitor(this._clusterName, beanName.instanceName(), beanName.resourceName());
            stateModelDefName = resourceMap.get(beanName.resourceName()).getStateModelDefRef();
            config = instanceConfigMap.get(beanName.instanceName());
            bean.update((Map)beanMap.get(beanName), Sets.newHashSet(config.getTags()), stateModelDefMap.get(stateModelDefName));
            monitorsToRegister.add(bean);
        }
        try {
            this.registerPerInstanceResources(monitorsToRegister);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("Fail to register per-instance resource with MBean server: " + toRegister), (Throwable)e);
        }
        for (PerInstanceResourceMonitor.BeanName beanName : this._perInstanceResourceMap.keySet()) {
            bean = this._perInstanceResourceMap.get(beanName);
            stateModelDefName = resourceMap.get(beanName.resourceName()).getStateModelDefRef();
            config = instanceConfigMap.get(beanName.instanceName());
            bean.update((Map)beanMap.get(beanName), Sets.newHashSet(config.getTags()), stateModelDefMap.get(stateModelDefName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterResource(String resourceName) {
        if (this._resourceMbeanMap.containsKey(resourceName)) {
            ClusterStatusMonitor clusterStatusMonitor = this;
            synchronized (clusterStatusMonitor) {
                if (this._resourceMbeanMap.containsKey(resourceName)) {
                    try {
                        this.unregisterResources(Arrays.asList(resourceName));
                    }
                    catch (MalformedObjectNameException e) {
                        LOG.error((Object)("Could not unregister beans for " + resourceName), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceStatus(ExternalView externalView, IdealState idealState, StateModelDefinition stateModelDef) {
        List<String> priorityList;
        String topState = null;
        if (stateModelDef != null && !(priorityList = stateModelDef.getStatesPriorityList()).isEmpty()) {
            topState = priorityList.get(0);
        }
        try {
            String resourceName = externalView.getId();
            if (!this._resourceMbeanMap.containsKey(resourceName)) {
                ClusterStatusMonitor clusterStatusMonitor = this;
                synchronized (clusterStatusMonitor) {
                    if (!this._resourceMbeanMap.containsKey(resourceName)) {
                        ResourceMonitor bean = new ResourceMonitor(this._clusterName, resourceName);
                        bean.updateResource(externalView, idealState, topState);
                        this.registerResources(Arrays.asList(bean));
                    }
                }
            }
            ResourceMonitor bean = this._resourceMbeanMap.get(resourceName);
            String oldSensorName = bean.getSensorName();
            bean.updateResource(externalView, idealState, topState);
            String newSensorName = bean.getSensorName();
            if (!oldSensorName.equals(newSensorName)) {
                this.unregisterResources(Arrays.asList(resourceName));
                this.registerResources(Arrays.asList(bean));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to set resource status, resource: " + idealState.getResourceName()), (Throwable)e);
        }
    }

    public void addMessageQueueSize(String instanceName, long msgQueueSize) {
        this._instanceMsgQueueSizes.put(instanceName, msgQueueSize);
    }

    public void reset() {
        LOG.info((Object)"Reset ClusterStatusMonitor");
        try {
            this.unregisterResources(this._resourceMbeanMap.keySet());
            this._resourceMbeanMap.clear();
            this._instanceMsgQueueSizes.clear();
            this.unregisterInstances(this._instanceMbeanMap.keySet());
            this._instanceMbeanMap.clear();
            this.unregisterPerInstanceResources(this._perInstanceResourceMap.keySet());
            this.unregister(this.getObjectName(this.clusterBeanName()));
            this.unregisterWorkflows(this._perTypeWorkflowMonitorMap.keySet());
            this.unregisterJobs(this._perTypeJobMonitorMap.keySet());
        }
        catch (Exception e) {
            LOG.error((Object)("Fail to reset ClusterStatusMonitor, cluster: " + this._clusterName), (Throwable)e);
        }
    }

    public void refreshWorkflowsStatus(TaskDriver driver) {
        for (WorkflowMonitor workflowMonitor : this._perTypeWorkflowMonitorMap.values()) {
            workflowMonitor.resetGauges();
        }
        Map<String, WorkflowConfig> workflowConfigMap = driver.getWorkflows();
        for (String workflow : workflowConfigMap.keySet()) {
            if (workflowConfigMap.get(workflow).isRecurring() || workflow.isEmpty()) continue;
            WorkflowContext workflowContext = driver.getWorkflowContext(workflow);
            TaskState currentState = workflowContext == null ? TaskState.NOT_STARTED : workflowContext.getWorkflowState();
            this.updateWorkflowGauges(workflowConfigMap.get(workflow), currentState);
        }
    }

    public void updateWorkflowCounters(WorkflowConfig workflowConfig, TaskState to) {
        String workflowType = workflowConfig.getWorkflowType();
        workflowType = this.preProcessWorkflow(workflowType);
        this._perTypeWorkflowMonitorMap.get(workflowType).updateWorkflowCounters(to);
    }

    private void updateWorkflowGauges(WorkflowConfig workflowConfig, TaskState current) {
        String workflowType = workflowConfig.getWorkflowType();
        workflowType = this.preProcessWorkflow(workflowType);
        this._perTypeWorkflowMonitorMap.get(workflowType).updateWorkflowGauges(current);
    }

    private String preProcessWorkflow(String workflowType) {
        if (workflowType == null || workflowType.length() == 0) {
            workflowType = "DEFAULT";
        }
        if (!this._perTypeWorkflowMonitorMap.containsKey(workflowType)) {
            WorkflowMonitor monitor = new WorkflowMonitor(this._clusterName, workflowType);
            try {
                this.registerWorkflow(monitor);
            }
            catch (MalformedObjectNameException e) {
                LOG.error((Object)("Failed to register object for workflow type : " + workflowType), (Throwable)e);
            }
            this._perTypeWorkflowMonitorMap.put(workflowType, monitor);
        }
        return workflowType;
    }

    public void refreshJobsStatus(TaskDriver driver) {
        for (JobMonitor jobMonitor : this._perTypeJobMonitorMap.values()) {
            jobMonitor.resetJobGauge();
        }
        for (String workflow : driver.getWorkflows().keySet()) {
            if (workflow.isEmpty()) continue;
            WorkflowConfig workflowConfig = driver.getWorkflowConfig(workflow);
            Set<String> allJobs = workflowConfig.getJobDag().getAllNodes();
            WorkflowContext workflowContext = driver.getWorkflowContext(workflow);
            for (String job : allJobs) {
                TaskState currentState = workflowContext == null ? TaskState.NOT_STARTED : workflowContext.getJobState(job);
                this.updateJobGauges(workflowConfig.getJobTypes() == null ? null : workflowConfig.getJobTypes().get(job), currentState);
            }
        }
    }

    public void updateJobCounters(JobConfig jobConfig, TaskState to) {
        String jobType = jobConfig.getJobType();
        jobType = this.preProcessJobMonitor(jobType);
        this._perTypeJobMonitorMap.get(jobType).updateJobCounters(to);
    }

    private void updateJobGauges(String jobType, TaskState current) {
        jobType = this.preProcessJobMonitor(jobType);
        this._perTypeJobMonitorMap.get(jobType).updateJobGauge(current);
    }

    private String preProcessJobMonitor(String jobType) {
        if (jobType == null || jobType.length() == 0) {
            jobType = "DEFAULT";
        }
        if (!this._perTypeJobMonitorMap.containsKey(jobType)) {
            JobMonitor monitor = new JobMonitor(this._clusterName, jobType);
            try {
                this.registerJob(monitor);
            }
            catch (MalformedObjectNameException e) {
                LOG.error((Object)("Failed to register job type : " + jobType), (Throwable)e);
            }
            this._perTypeJobMonitorMap.put(jobType, monitor);
        }
        return jobType;
    }

    private synchronized void registerInstances(Collection<InstanceMonitor> instances) throws MalformedObjectNameException {
        for (InstanceMonitor monitor : instances) {
            String instanceName = monitor.getInstanceName();
            String beanName = this.getInstanceBeanName(instanceName);
            this.register(monitor, this.getObjectName(beanName));
            this._instanceMbeanMap.put(instanceName, monitor);
        }
    }

    private synchronized void unregisterInstances(Collection<String> instances) throws MalformedObjectNameException {
        for (String instanceName : instances) {
            String beanName = this.getInstanceBeanName(instanceName);
            this.unregister(this.getObjectName(beanName));
        }
        this._instanceMbeanMap.keySet().removeAll(instances);
    }

    private synchronized void registerResources(Collection<ResourceMonitor> resources) throws MalformedObjectNameException {
        for (ResourceMonitor monitor : resources) {
            String resourceName = monitor.getResourceName();
            String beanName = this.getResourceBeanName(resourceName);
            this.register(monitor, this.getObjectName(beanName));
            this._resourceMbeanMap.put(resourceName, monitor);
        }
    }

    private synchronized void unregisterResources(Collection<String> resources) throws MalformedObjectNameException {
        for (String resourceName : resources) {
            String beanName = this.getResourceBeanName(resourceName);
            this.unregister(this.getObjectName(beanName));
        }
        this._resourceMbeanMap.keySet().removeAll(resources);
    }

    private synchronized void registerPerInstanceResources(Collection<PerInstanceResourceMonitor> monitors) throws MalformedObjectNameException {
        for (PerInstanceResourceMonitor monitor : monitors) {
            String instanceName = monitor.getInstanceName();
            String resourceName = monitor.getResourceName();
            String beanName = this.getPerInstanceResourceBeanName(instanceName, resourceName);
            this.register(monitor, this.getObjectName(beanName));
            this._perInstanceResourceMap.put(new PerInstanceResourceMonitor.BeanName(instanceName, resourceName), monitor);
        }
    }

    private synchronized void unregisterPerInstanceResources(Collection<PerInstanceResourceMonitor.BeanName> beanNames) throws MalformedObjectNameException {
        for (PerInstanceResourceMonitor.BeanName beanName : beanNames) {
            this.unregister(this.getObjectName(this.getPerInstanceResourceBeanName(beanName.instanceName(), beanName.resourceName())));
        }
        this._perInstanceResourceMap.keySet().removeAll(beanNames);
    }

    private synchronized void registerWorkflow(WorkflowMonitor workflowMonitor) throws MalformedObjectNameException {
        String workflowBeanName = this.getWorkflowBeanName(workflowMonitor.getWorkflowType());
        this.register(workflowMonitor, this.getObjectName(workflowBeanName));
    }

    private synchronized void unregisterWorkflows(Collection<String> workflowMonitors) throws MalformedObjectNameException {
        for (String workflowMonitor : workflowMonitors) {
            String workflowBeanName = this.getWorkflowBeanName(workflowMonitor);
            this.unregister(this.getObjectName(workflowBeanName));
            this._perTypeWorkflowMonitorMap.remove(workflowMonitor);
        }
    }

    private synchronized void registerJob(JobMonitor jobMonitor) throws MalformedObjectNameException {
        String jobBeanName = this.getJobBeanName(jobMonitor.getJobType());
        this.register(jobMonitor, this.getObjectName(jobBeanName));
    }

    private synchronized void unregisterJobs(Collection<String> jobMonitors) throws MalformedObjectNameException {
        for (String jobMonitor : jobMonitors) {
            String jobBeanName = this.getJobBeanName(jobMonitor);
            this.unregister(this.getObjectName(jobBeanName));
            this._perTypeJobMonitorMap.remove(jobMonitor);
        }
    }

    public String clusterBeanName() {
        return String.format("%s=%s", CLUSTER_DN_KEY, this._clusterName);
    }

    private String getInstanceBeanName(String instanceName) {
        return String.format("%s,%s=%s", this.clusterBeanName(), INSTANCE_DN_KEY, instanceName);
    }

    private String getResourceBeanName(String resourceName) {
        return String.format("%s,%s=%s", this.clusterBeanName(), RESOURCE_DN_KEY, resourceName);
    }

    public String getPerInstanceResourceBeanName(String instanceName, String resourceName) {
        return String.format("%s,%s", this.clusterBeanName(), new PerInstanceResourceMonitor.BeanName(instanceName, resourceName).toString());
    }

    public String getWorkflowBeanName(String workflowType) {
        return String.format("%s, %s=%s", this.clusterBeanName(), WORKFLOW_TYPE_DN_KEY, workflowType);
    }

    public String getJobBeanName(String jobType) {
        return String.format("%s, %s=%s", this.clusterBeanName(), JOB_TYPE_DN_KEY, jobType);
    }

    @Override
    public String getSensorName() {
        return "ClusterStatus." + this._clusterName;
    }
}

