/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.RemoteInvocationException;
import com.linkedin.restli.client.BatchRequest;
import com.linkedin.restli.client.BatchingKey;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.RestLiDecodingException;
import com.linkedin.restli.client.RestLiResponseException;
import com.linkedin.restli.client.response.BatchKVResponse;
import com.linkedin.restli.common.BatchResponse;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.internal.client.ResponseImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchGetRequestUtil {
    public static <T extends RecordTemplate> Map<String, Object> getBatchQueryParam(List<? extends BatchRequest<T>> requests, boolean batchFields) {
        if (requests.size() < 2) {
            throw new IllegalArgumentException("Must have at least two requests to batch");
        }
        BatchRequest<T> firstRequest = requests.get(0);
        BatchingKey<T, BatchRequest<T>> batchKey = new BatchingKey<T, BatchRequest<T>>(firstRequest, batchFields);
        HashSet<Object> ids = new HashSet<Object>();
        Set<Object> fields = batchFields ? new HashSet() : firstRequest.getFields();
        for (BatchRequest<T> request : requests) {
            batchKey.validate(request);
            Set<Object> requestIds = request.getObjectIds();
            Set<PathSpec> requestFields = request.getFields();
            if (requestIds != null && !requestIds.isEmpty()) {
                ids.addAll(requestIds);
            }
            if (!batchFields) continue;
            if (requestFields == null || requestFields.isEmpty()) {
                fields = null;
                continue;
            }
            if (fields == null) continue;
            fields.addAll(requestFields);
        }
        Map<String, Object> queryParams = BatchGetRequestUtil.getQueryParamsForBatchingKey(firstRequest);
        queryParams.put("ids", ids);
        if (fields != null && !fields.isEmpty()) {
            queryParams.put("fields", fields.toArray(new PathSpec[fields.size()]));
        }
        return queryParams;
    }

    public static Map<String, Object> getQueryParamsForBatchingKey(BatchRequest<?> request) {
        HashMap<String, Object> params = new HashMap<String, Object>(request.getQueryParamsObjects());
        params.remove("ids");
        params.remove("fields");
        return params;
    }

    public static <K, V extends RecordTemplate> Response<V> unbatchKVResponse(Request<BatchKVResponse<K, V>> request, Response<BatchKVResponse<K, V>> batchResponse, K id) throws RemoteInvocationException {
        BatchKVResponse<K, V> batchEntity = batchResponse.getEntity();
        ErrorResponse errorResponse = batchEntity.getErrors().get(id);
        if (errorResponse != null) {
            throw new RestLiResponseException(errorResponse);
        }
        RecordTemplate entityResult = (RecordTemplate)batchEntity.getResults().get(id);
        if (entityResult == null) {
            throw new RestLiDecodingException("No result or error for base URI " + request.getBaseUriTemplate() + ", id " + id + ". Verify that the batchGet endpoint returns response keys that match batchGet request IDs.", null);
        }
        return new ResponseImpl<RecordTemplate>(batchResponse, entityResult);
    }

    public static <T extends RecordTemplate> Response<T> unbatchResponse(Request<BatchResponse<T>> request, Response<BatchResponse<T>> batchResponse, Object id) throws RemoteInvocationException {
        BatchResponse<T> batchEntity = batchResponse.getEntity();
        ErrorResponse errorResponse = (ErrorResponse)batchEntity.getErrors().get(id);
        if (errorResponse != null) {
            throw new RestLiResponseException(errorResponse);
        }
        RecordTemplate entityResult = (RecordTemplate)batchEntity.getResults().get(id);
        if (entityResult == null) {
            throw new RestLiDecodingException("No result or error for base URI " + request.getBaseUriTemplate() + ", id " + id + ". Verify that the batchGet endpoint returns response keys that match batchGet request IDs.", null);
        }
        return new ResponseImpl<RecordTemplate>(batchResponse, entityResult);
    }
}

