/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp;

import azkaban.execapp.JobRunner;
import azkaban.execapp.event.Event;
import azkaban.execapp.event.EventHandler;
import azkaban.execapp.event.EventListener;
import azkaban.execapp.event.FlowWatcher;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.flow.FlowProps;
import azkaban.jobtype.JobTypeManager;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManagerException;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.SwapQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class FlowRunner
extends EventHandler
implements Runnable {
    private static final Layout DEFAULT_LAYOUT = new PatternLayout("%d{dd-MM-yyyy HH:mm:ss z} %c{1} %p - %m\n");
    private static final long CHECK_WAIT_MS = 300000L;
    private Logger logger;
    private Layout loggerLayout = DEFAULT_LAYOUT;
    private Appender flowAppender;
    private File logFile;
    private ExecutorService executorService;
    private ExecutorLoader executorLoader;
    private ProjectLoader projectLoader;
    private int execId;
    private File execDir;
    private final ExecutableFlow flow;
    private Thread flowRunnerThread;
    private int numJobThreads = 10;
    private ExecutionOptions.FailureAction failureAction;
    private Object mainSyncObj = new Object();
    private Map<String, Props> sharedProps = new HashMap<String, Props>();
    private Props globalProps;
    private final JobTypeManager jobtypeManager;
    private JobRunnerEventListener listener = new JobRunnerEventListener();
    private Set<JobRunner> activeJobRunners = Collections.newSetFromMap(new ConcurrentHashMap());
    private SwapQueue<ExecutableNode> finishedNodes;
    private Integer pipelineLevel = null;
    private Integer pipelineExecId = null;
    private FlowWatcher watcher = null;
    private Set<String> proxyUsers = null;
    private boolean validateUserProxy;
    private String jobLogFileSize = "5MB";
    private int jobLogNumFiles = 4;
    private boolean flowPaused = false;
    private boolean flowFailed = false;
    private boolean flowFinished = false;
    private boolean flowKilled = false;
    private boolean retryFailedJobs = false;

    public FlowRunner(ExecutableFlow flow, ExecutorLoader executorLoader, ProjectLoader projectLoader, JobTypeManager jobtypeManager) throws ExecutorManagerException {
        this(flow, executorLoader, projectLoader, jobtypeManager, null);
    }

    public FlowRunner(ExecutableFlow flow, ExecutorLoader executorLoader, ProjectLoader projectLoader, JobTypeManager jobtypeManager, ExecutorService executorService) throws ExecutorManagerException {
        this.execId = flow.getExecutionId();
        this.flow = flow;
        this.executorLoader = executorLoader;
        this.projectLoader = projectLoader;
        this.execDir = new File(flow.getExecutionPath());
        this.jobtypeManager = jobtypeManager;
        ExecutionOptions options = flow.getExecutionOptions();
        this.pipelineLevel = options.getPipelineLevel();
        this.pipelineExecId = options.getPipelineExecutionId();
        this.failureAction = options.getFailureAction();
        this.proxyUsers = flow.getProxyUsers();
        this.executorService = executorService;
        this.finishedNodes = new SwapQueue();
    }

    public FlowRunner setFlowWatcher(FlowWatcher watcher) {
        this.watcher = watcher;
        return this;
    }

    public FlowRunner setGlobalProps(Props globalProps) {
        this.globalProps = globalProps;
        return this;
    }

    public FlowRunner setNumJobThreads(int jobs) {
        this.numJobThreads = jobs;
        return this;
    }

    public FlowRunner setJobLogSettings(String jobLogFileSize, int jobLogNumFiles) {
        this.jobLogFileSize = jobLogFileSize;
        this.jobLogNumFiles = jobLogNumFiles;
        return this;
    }

    public FlowRunner setValidateProxyUser(boolean validateUserProxy) {
        this.validateUserProxy = validateUserProxy;
        return this;
    }

    public File getExecutionDir() {
        return this.execDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(this.numJobThreads);
            }
            this.setupFlowExecution();
            this.flow.setStartTime(System.currentTimeMillis());
            this.updateFlowReference();
            this.logger.info((Object)"Updating initial flow directory.");
            this.updateFlow();
            this.logger.info((Object)"Fetching job and shared properties.");
            this.loadAllProperties();
            this.fireEventListeners(Event.create(this, Event.Type.FLOW_STARTED));
            this.runFlow();
        }
        catch (Throwable t) {
            if (this.logger != null) {
                this.logger.error((Object)"An error has occurred during the running of the flow. Quiting.", t);
            }
            this.flow.setStatus(Status.FAILED);
        }
        finally {
            if (this.watcher != null) {
                this.logger.info((Object)"Watcher is attached. Stopping watcher.");
                this.watcher.stopWatcher();
                this.logger.info((Object)("Watcher cancelled status is " + this.watcher.isWatchCancelled()));
            }
            this.flow.setEndTime(System.currentTimeMillis());
            this.logger.info((Object)("Setting end time for flow " + this.execId + " to " + System.currentTimeMillis()));
            this.closeLogger();
            this.updateFlow();
            this.fireEventListeners(Event.create(this, Event.Type.FLOW_FINISHED));
        }
    }

    private void setupFlowExecution() {
        Map<String, String> flowParam;
        int projectId = this.flow.getProjectId();
        int version = this.flow.getVersion();
        String flowId = this.flow.getFlowId();
        Props commonFlowProps = PropsUtils.addCommonFlowProperties(this.globalProps, this.flow);
        if (this.flow.getJobSource() != null) {
            String source = this.flow.getJobSource();
            Props flowProps = this.sharedProps.get(source);
            flowProps.setParent(commonFlowProps);
            commonFlowProps = flowProps;
        }
        if ((flowParam = this.flow.getExecutionOptions().getFlowParameters()) != null && !flowParam.isEmpty()) {
            commonFlowProps = new Props(commonFlowProps, flowParam);
        }
        this.flow.setInputProps(commonFlowProps);
        this.createLogger(flowId);
        if (this.watcher != null) {
            this.watcher.setLogger(this.logger);
        }
        this.logger.info((Object)("Running execid:" + this.execId + " flow:" + flowId + " project:" + projectId + " version:" + version));
        if (this.pipelineExecId != null) {
            this.logger.info((Object)("Running simulateously with " + this.pipelineExecId + ". Pipelining level " + this.pipelineLevel));
        }
        this.flowRunnerThread = Thread.currentThread();
        this.flowRunnerThread.setName("FlowRunner-exec-" + this.flow.getExecutionId());
    }

    private void updateFlowReference() throws ExecutorManagerException {
        this.logger.info((Object)"Update active reference");
        if (!this.executorLoader.updateExecutableReference(this.execId, System.currentTimeMillis())) {
            throw new ExecutorManagerException("The executor reference doesn't exist. May have been killed prematurely.");
        }
    }

    private void updateFlow() {
        this.updateFlow(System.currentTimeMillis());
    }

    private synchronized void updateFlow(long time) {
        try {
            this.flow.setUpdateTime(time);
            this.executorLoader.updateExecutableFlow(this.flow);
        }
        catch (ExecutorManagerException e) {
            this.logger.error((Object)"Error updating flow.", (Throwable)e);
        }
    }

    private void createLogger(String flowId) {
        String loggerName = this.execId + "." + flowId;
        this.logger = Logger.getLogger((String)loggerName);
        String logName = "_flow." + loggerName + ".log";
        this.logFile = new File(this.execDir, logName);
        String absolutePath = this.logFile.getAbsolutePath();
        this.flowAppender = null;
        try {
            this.flowAppender = new FileAppender(this.loggerLayout, absolutePath, false);
            this.logger.addAppender(this.flowAppender);
        }
        catch (IOException e) {
            this.logger.error((Object)("Could not open log file in " + this.execDir), (Throwable)e);
        }
    }

    private void closeLogger() {
        if (this.logger != null) {
            this.logger.removeAppender(this.flowAppender);
            this.flowAppender.close();
            try {
                this.executorLoader.uploadLogFile(this.execId, "", 0, this.logFile);
            }
            catch (ExecutorManagerException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadAllProperties() throws IOException {
        Props props;
        String source;
        for (FlowProps fprops : this.flow.getFlowProps()) {
            source = fprops.getSource();
            File propsPath = new File(this.execDir, source);
            props = new Props(null, propsPath);
            this.sharedProps.put(source, props);
        }
        for (FlowProps fprops : this.flow.getFlowProps()) {
            if (fprops.getInheritedSource() == null) continue;
            source = fprops.getSource();
            String inherit = fprops.getInheritedSource();
            props = this.sharedProps.get(source);
            Props inherits = this.sharedProps.get(inherit);
            props.setParent(inherits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFlow() throws Exception {
        this.logger.info((Object)"Starting flows");
        this.runReadyJob(this.flow);
        this.updateFlow();
        while (!this.flowFinished) {
            Object object = this.mainSyncObj;
            synchronized (object) {
                if (this.flowPaused) {
                    try {
                        this.mainSyncObj.wait(300000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
                if (this.retryFailedJobs) {
                    this.retryAllFailures();
                } else if (!this.progressGraph()) {
                    try {
                        this.mainSyncObj.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.logger.info((Object)"Finishing up flow. Awaiting Termination");
        this.executorService.shutdown();
        this.updateFlow();
        this.logger.info((Object)"Finished Flow");
    }

    private void retryAllFailures() throws IOException {
        this.logger.info((Object)"Restarting all failed jobs");
        this.retryFailedJobs = false;
        this.flowKilled = false;
        this.flowFailed = false;
        this.flow.setStatus(Status.RUNNING);
        ArrayList<ExecutableNode> retryJobs = new ArrayList<ExecutableNode>();
        this.resetFailedState(this.flow, retryJobs);
        for (ExecutableNode node : retryJobs) {
            if (node.getStatus() == Status.READY || node.getStatus() == Status.DISABLED) {
                this.runReadyJob(node);
            } else if (node.getStatus() == Status.SUCCEEDED) {
                for (String outNodeId : node.getOutNodes()) {
                    ExecutableFlowBase base = node.getParentFlow();
                    this.runReadyJob(base.getExecutableNode(outNodeId));
                }
            }
            this.runReadyJob(node);
        }
        this.updateFlow();
    }

    private boolean progressGraph() throws IOException {
        this.finishedNodes.swap();
        HashSet<ExecutableNode> nodesToCheck = new HashSet<ExecutableNode>();
        for (ExecutableNode node : this.finishedNodes) {
            Set<String> outNodeIds = node.getOutNodes();
            ExecutableFlowBase parentFlow = node.getParentFlow();
            if (node.getStatus() == Status.FAILED) {
                if (!this.retryJobIfPossible(node)) {
                    this.propagateStatus(node.getParentFlow(), Status.FAILED_FINISHING);
                    if (this.failureAction == ExecutionOptions.FailureAction.CANCEL_ALL) {
                        this.kill();
                    }
                    this.flowFailed = true;
                } else {
                    nodesToCheck.add(node);
                    continue;
                }
            }
            if (outNodeIds.isEmpty()) {
                this.finalizeFlow(parentFlow);
                this.finishExecutableNode(parentFlow);
                if (!(parentFlow instanceof ExecutableFlow)) {
                    outNodeIds = parentFlow.getOutNodes();
                    parentFlow = parentFlow.getParentFlow();
                }
            }
            for (String nodeId : outNodeIds) {
                ExecutableNode outNode = parentFlow.getExecutableNode(nodeId);
                nodesToCheck.add(outNode);
            }
        }
        boolean jobsRun = false;
        for (ExecutableNode node : nodesToCheck) {
            if (Status.isStatusFinished(node.getStatus()) || Status.isStatusRunning(node.getStatus())) continue;
            jobsRun |= this.runReadyJob(node);
        }
        if (jobsRun || this.finishedNodes.getSize() > 0) {
            this.updateFlow();
            return true;
        }
        return false;
    }

    private boolean runReadyJob(ExecutableNode node) throws IOException {
        if (Status.isStatusFinished(node.getStatus()) || Status.isStatusRunning(node.getStatus())) {
            return false;
        }
        Status nextNodeStatus = this.getImpliedStatus(node);
        if (nextNodeStatus == null) {
            return false;
        }
        if (nextNodeStatus == Status.CANCELLED) {
            this.logger.info((Object)("Cancelling '" + node.getNestedId() + "' due to prior errors."));
            node.cancelNode(System.currentTimeMillis());
            this.finishExecutableNode(node);
        } else if (nextNodeStatus == Status.SKIPPED) {
            this.logger.info((Object)("Skipping disabled job '" + node.getId() + "'."));
            node.skipNode(System.currentTimeMillis());
            this.finishExecutableNode(node);
        } else if (nextNodeStatus == Status.READY) {
            if (node instanceof ExecutableFlowBase) {
                ExecutableFlowBase flow = (ExecutableFlowBase)node;
                this.logger.info((Object)("Running flow '" + flow.getNestedId() + "'."));
                flow.setStatus(Status.RUNNING);
                flow.setStartTime(System.currentTimeMillis());
                this.prepareJobProperties(flow);
                for (String startNodeId : ((ExecutableFlowBase)node).getStartNodes()) {
                    ExecutableNode startNode = flow.getExecutableNode(startNodeId);
                    this.runReadyJob(startNode);
                }
            } else {
                this.runExecutableNode(node);
            }
        }
        return true;
    }

    private boolean retryJobIfPossible(ExecutableNode node) {
        if (node instanceof ExecutableFlowBase) {
            return false;
        }
        if (node.getRetries() > node.getAttempt()) {
            this.logger.info((Object)("Job '" + node.getId() + "' will be retried. Attempt " + node.getAttempt() + " of " + node.getRetries()));
            node.setDelayedExecution(node.getRetryBackoff());
            node.resetForRetry();
            return true;
        }
        if (node.getRetries() > 0) {
            this.logger.info((Object)("Job '" + node.getId() + "' has run out of retry attempts"));
            node.setDelayedExecution(0L);
        }
        return false;
    }

    private void propagateStatus(ExecutableFlowBase base, Status status) {
        if (!Status.isStatusFinished(base.getStatus())) {
            this.logger.info((Object)("Setting " + base.getNestedId() + " to " + (Object)((Object)status)));
            base.setStatus(status);
            if (base.getParentFlow() != null) {
                this.propagateStatus(base.getParentFlow(), status);
            }
        }
    }

    private void finishExecutableNode(ExecutableNode node) {
        this.finishedNodes.add(node);
        this.fireEventListeners(Event.create(this, Event.Type.JOB_FINISHED, node));
    }

    private void finalizeFlow(ExecutableFlowBase flow) {
        String id = flow == this.flow ? "" : flow.getNestedId();
        boolean succeeded = true;
        Props previousOutput = null;
        for (String end : flow.getEndNodes()) {
            Props output;
            ExecutableNode node = flow.getExecutableNode(end);
            if (node.getStatus() == Status.KILLED || node.getStatus() == Status.FAILED || node.getStatus() == Status.CANCELLED) {
                succeeded = false;
            }
            if ((output = node.getOutputProps()) == null) continue;
            output = Props.clone(output);
            output.setParent(previousOutput);
            previousOutput = output;
        }
        flow.setOutputProps(previousOutput);
        if (!succeeded && flow.getStatus() == Status.RUNNING) {
            flow.setStatus(Status.KILLED);
        }
        flow.setEndTime(System.currentTimeMillis());
        flow.setUpdateTime(System.currentTimeMillis());
        long durationSec = (flow.getEndTime() - flow.getStartTime()) / 1000L;
        switch (flow.getStatus()) {
            case FAILED_FINISHING: {
                this.logger.info((Object)("Setting flow '" + id + "' status to FAILED in " + durationSec + " seconds"));
                flow.setStatus(Status.FAILED);
                break;
            }
            case FAILED: 
            case KILLED: 
            case CANCELLED: 
            case FAILED_SUCCEEDED: {
                this.logger.info((Object)("Flow '" + id + "' is set to " + flow.getStatus().toString() + " in " + durationSec + " seconds"));
                break;
            }
            default: {
                flow.setStatus(Status.SUCCEEDED);
                this.logger.info((Object)("Flow '" + id + "' is set to " + flow.getStatus().toString() + " in " + durationSec + " seconds"));
            }
        }
        if (flow instanceof ExecutableFlow) {
            this.flowFinished = true;
        }
    }

    private void prepareJobProperties(ExecutableNode node) throws IOException {
        Props jobSource;
        Props outputProps;
        Map<String, String> flowParam;
        Props shared;
        String sharedProps;
        if (node instanceof ExecutableFlow) {
            return;
        }
        Props props = null;
        ExecutableFlowBase parentFlow = node.getParentFlow();
        if (parentFlow != null) {
            props = parentFlow.getInputProps();
        }
        if ((sharedProps = node.getPropsSource()) != null && (shared = this.sharedProps.get(sharedProps)) != null) {
            shared = Props.clone(shared);
            shared.setEarliestAncestor(props);
            props = shared;
        }
        if ((flowParam = this.flow.getExecutionOptions().getFlowParameters()) != null && !flowParam.isEmpty()) {
            props = new Props(props, flowParam);
        }
        if ((outputProps = this.collectOutputProps(node)) != null) {
            outputProps.setEarliestAncestor(props);
            props = outputProps;
        }
        if ((jobSource = this.loadJobProps(node)) != null) {
            jobSource.setParent(props);
            props = jobSource;
        }
        node.setInputProps(props);
    }

    private Props loadJobProps(ExecutableNode node) throws IOException {
        Props props = null;
        String source = node.getJobSource();
        if (source == null) {
            return null;
        }
        try {
            props = this.projectLoader.fetchProjectProperty(this.flow.getProjectId(), this.flow.getVersion(), node.getId() + ".jor");
        }
        catch (ProjectManagerException e) {
            e.printStackTrace();
            this.logger.error((Object)("Error loading job override property for job " + node.getId()));
        }
        File path = new File(this.execDir, source);
        if (props == null) {
            try {
                props = new Props(null, path);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.error((Object)("Error loading job file " + source + " for job " + node.getId()));
            }
        }
        if (path.getPath() != null) {
            props.setSource(path.getPath());
        }
        return props;
    }

    private void runExecutableNode(ExecutableNode node) throws IOException {
        this.prepareJobProperties(node);
        node.setStatus(Status.QUEUED);
        JobRunner runner = this.createJobRunner(node);
        this.logger.info((Object)("Submitting job '" + node.getNestedId() + "' to run."));
        try {
            this.executorService.submit(runner);
            this.activeJobRunners.add(runner);
        }
        catch (RejectedExecutionException e) {
            this.logger.error((Object)e);
        }
    }

    public Status getImpliedStatus(ExecutableNode node) {
        if (Status.isStatusRunning(node.getStatus()) || node.getStatus() == Status.SUCCEEDED) {
            return null;
        }
        ExecutableFlowBase flow = node.getParentFlow();
        boolean shouldKill = false;
        for (String dependency : node.getInNodes()) {
            ExecutableNode dependencyNode = flow.getExecutableNode(dependency);
            Status depStatus = dependencyNode.getStatus();
            if (!Status.isStatusFinished(depStatus)) {
                return null;
            }
            if (depStatus != Status.FAILED && depStatus != Status.CANCELLED && depStatus != Status.KILLED) continue;
            shouldKill = true;
        }
        if (node.getStatus() == Status.DISABLED || node.getStatus() == Status.SKIPPED) {
            return Status.SKIPPED;
        }
        if (this.flowFailed && this.failureAction == ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING) {
            return Status.CANCELLED;
        }
        if (shouldKill || this.isKilled()) {
            return Status.CANCELLED;
        }
        return Status.READY;
    }

    private Props collectOutputProps(ExecutableNode node) {
        Props previousOutput = null;
        for (String dependency : node.getInNodes()) {
            Props output = node.getParentFlow().getExecutableNode(dependency).getOutputProps();
            if (output == null) continue;
            output = Props.clone(output);
            output.setParent(previousOutput);
            previousOutput = output;
        }
        return previousOutput;
    }

    private JobRunner createJobRunner(ExecutableNode node) {
        File path = new File(this.execDir, node.getJobSource());
        JobRunner jobRunner = new JobRunner(node, path.getParentFile(), this.executorLoader, this.jobtypeManager);
        if (this.watcher != null) {
            jobRunner.setPipeline(this.watcher, this.pipelineLevel);
        }
        if (this.validateUserProxy) {
            jobRunner.setValidatedProxyUsers(this.proxyUsers);
        }
        jobRunner.setDelayStart(node.getDelayedExecution());
        jobRunner.setLogSettings(this.logger, this.jobLogFileSize, this.jobLogNumFiles);
        jobRunner.addListener(this.listener);
        return jobRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            if (!this.flowFinished) {
                this.logger.info((Object)("Flow paused by " + user));
                this.flowPaused = true;
                this.flow.setStatus(Status.PAUSED);
                this.updateFlow();
            } else {
                this.logger.info((Object)("Cannot pause finished flow. Called by user " + user));
            }
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            if (!this.flowPaused) {
                this.logger.info((Object)"Cannot resume flow that isn't paused");
            } else {
                this.logger.info((Object)("Flow resumed by " + user));
                this.flowPaused = false;
                if (this.flowFailed) {
                    this.flow.setStatus(Status.FAILED_FINISHING);
                } else if (this.flowKilled) {
                    this.flow.setStatus(Status.KILLED);
                } else {
                    this.flow.setStatus(Status.RUNNING);
                }
                this.updateFlow();
            }
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            this.logger.info((Object)("Flow killed by " + user));
            this.flow.setStatus(Status.KILLED);
            this.kill();
            this.updateFlow();
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill() {
        Object object = this.mainSyncObj;
        synchronized (object) {
            this.logger.info((Object)("Kill has been called on flow " + this.execId));
            this.flowPaused = false;
            this.flowKilled = true;
            if (this.watcher != null) {
                this.logger.info((Object)"Watcher is attached. Stopping watcher.");
                this.watcher.stopWatcher();
                this.logger.info((Object)("Watcher cancelled status is " + this.watcher.isWatchCancelled()));
            }
            this.logger.info((Object)("Killing " + this.activeJobRunners.size() + " jobs."));
            for (JobRunner runner : this.activeJobRunners) {
                runner.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryFailures(String user) {
        Object object = this.mainSyncObj;
        synchronized (object) {
            this.logger.info((Object)("Retrying failures invoked by " + user));
            this.retryFailedJobs = true;
            this.interrupt();
        }
    }

    private void resetFailedState(ExecutableFlowBase flow, List<ExecutableNode> nodesToRetry) {
        ExecutableNode node;
        LinkedList<ExecutableNode> queue = new LinkedList<ExecutableNode>();
        for (String id : flow.getEndNodes()) {
            node = flow.getExecutableNode(id);
            queue.add(node);
        }
        long maxStartTime = -1L;
        while (!queue.isEmpty()) {
            Status oldStatus;
            block16: {
                long currentTime;
                block17: {
                    block15: {
                        node = (ExecutableNode)queue.poll();
                        oldStatus = node.getStatus();
                        maxStartTime = Math.max(node.getStartTime(), maxStartTime);
                        currentTime = System.currentTimeMillis();
                        if (node.getStatus() == Status.SUCCEEDED) {
                            nodesToRetry.add(node);
                            continue;
                        }
                        if (node.getStatus() == Status.RUNNING) continue;
                        if (node.getStatus() != Status.SKIPPED) break block15;
                        node.setStatus(Status.DISABLED);
                        node.setEndTime(-1L);
                        node.setStartTime(-1L);
                        node.setUpdateTime(currentTime);
                        break block16;
                    }
                    if (!(node instanceof ExecutableFlowBase)) break block17;
                    ExecutableFlowBase base = (ExecutableFlowBase)node;
                    switch (base.getStatus()) {
                        case CANCELLED: {
                            node.setStatus(Status.READY);
                            node.setEndTime(-1L);
                            node.setStartTime(-1L);
                            node.setUpdateTime(currentTime);
                            break block16;
                        }
                        case FAILED_FINISHING: 
                        case FAILED: 
                        case KILLED: {
                            this.resetFailedState(base, nodesToRetry);
                            break;
                        }
                    }
                    continue;
                }
                if (node.getStatus() == Status.CANCELLED) {
                    node.setStatus(Status.READY);
                    node.setStartTime(-1L);
                    node.setEndTime(-1L);
                    node.setUpdateTime(currentTime);
                } else if (node.getStatus() == Status.FAILED || node.getStatus() == Status.KILLED) {
                    node.resetForRetry();
                    nodesToRetry.add(node);
                }
            }
            if (!(node instanceof ExecutableFlowBase) && node.getStatus() != oldStatus) {
                this.logger.info((Object)("Resetting job '" + node.getNestedId() + "' from " + (Object)((Object)oldStatus) + " to " + (Object)((Object)node.getStatus())));
            }
            for (String inId : node.getInNodes()) {
                ExecutableNode nodeUp = flow.getExecutableNode(inId);
                queue.add(nodeUp);
            }
        }
        Status oldFlowState = flow.getStatus();
        if (maxStartTime == -1L) {
            flow.setStatus(Status.READY);
        } else {
            flow.setStatus(Status.RUNNING);
            for (String id : flow.getStartNodes()) {
                ExecutableNode node2 = flow.getExecutableNode(id);
                if (node2.getStatus() != Status.READY && node2.getStatus() != Status.DISABLED) continue;
                nodesToRetry.add(node2);
            }
        }
        flow.setUpdateTime(System.currentTimeMillis());
        flow.setEndTime(-1L);
        flow.setStartTime(maxStartTime);
        this.logger.info((Object)("Resetting flow '" + flow.getNestedId() + "' from " + (Object)((Object)oldFlowState) + " to " + (Object)((Object)flow.getStatus())));
    }

    private void interrupt() {
        this.flowRunnerThread.interrupt();
    }

    public boolean isKilled() {
        return this.flowKilled;
    }

    public ExecutableFlow getExecutableFlow() {
        return this.flow;
    }

    public File getFlowLogFile() {
        return this.logFile;
    }

    public File getJobLogFile(String jobId, int attempt) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        File path = new File(this.execDir, node.getJobSource());
        String logFileName = JobRunner.createLogFileName(node, attempt);
        File logFile = new File(path.getParentFile(), logFileName);
        if (!logFile.exists()) {
            return null;
        }
        return logFile;
    }

    public File getJobAttachmentFile(String jobId, int attempt) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        File path = new File(this.execDir, node.getJobSource());
        String attachmentFileName = JobRunner.createAttachmentFileName(node, attempt);
        File attachmentFile = new File(path.getParentFile(), attachmentFileName);
        if (!attachmentFile.exists()) {
            return null;
        }
        return attachmentFile;
    }

    public File getJobMetaDataFile(String jobId, int attempt) {
        ExecutableNode node = this.flow.getExecutableNodePath(jobId);
        File path = new File(this.execDir, node.getJobSource());
        String metaDataFileName = JobRunner.createMetaDataFileName(node, attempt);
        File metaDataFile = new File(path.getParentFile(), metaDataFileName);
        if (!metaDataFile.exists()) {
            return null;
        }
        return metaDataFile;
    }

    public boolean isRunnerThreadAlive() {
        if (this.flowRunnerThread != null) {
            return this.flowRunnerThread.isAlive();
        }
        return false;
    }

    public boolean isThreadPoolShutdown() {
        return this.executorService.isShutdown();
    }

    public int getNumRunningJobs() {
        return this.activeJobRunners.size();
    }

    private class JobRunnerEventListener
    implements EventListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void handleEvent(Event event) {
            JobRunner runner = (JobRunner)event.getRunner();
            if (event.getType() == Event.Type.JOB_STATUS_CHANGED) {
                FlowRunner.this.updateFlow();
            } else if (event.getType() == Event.Type.JOB_FINISHED) {
                ExecutableNode node = runner.getNode();
                long seconds = (node.getEndTime() - node.getStartTime()) / 1000L;
                Object object = FlowRunner.this.mainSyncObj;
                synchronized (object) {
                    FlowRunner.this.logger.info((Object)("Job " + node.getNestedId() + " finished with status " + (Object)((Object)node.getStatus()) + " in " + seconds + " seconds"));
                    if (FlowRunner.this.flowPaused && node.getStatus() == Status.FAILED && FlowRunner.this.failureAction == ExecutionOptions.FailureAction.CANCEL_ALL) {
                        FlowRunner.this.flowPaused = false;
                    }
                    FlowRunner.this.finishedNodes.add(node);
                    node.getParentFlow().setUpdateTime(System.currentTimeMillis());
                    FlowRunner.this.interrupt();
                    FlowRunner.this.fireEventListeners(event);
                }
            }
        }
    }
}

