/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.List;
import org.apache.gobblin.metrics.kafka.Pusher;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPusher<M>
implements Pusher<M> {
    private static final Logger log = LoggerFactory.getLogger(LoggingPusher.class);
    private final String brokers;
    private final String topic;
    private static final String KAFKA_TOPIC = "kafka.topic";
    private static final String NO_BROKERS = "NoBrokers";
    private static final String NO_TOPIC = "NoTopic";

    public LoggingPusher() {
        this(NO_BROKERS, NO_TOPIC, (Optional<Config>)Optional.absent());
    }

    public LoggingPusher(Config config) {
        this.brokers = ConfigUtils.getString((Config)config, (String)"kafka.brokers", (String)NO_BROKERS);
        this.topic = ConfigUtils.getString((Config)config, (String)KAFKA_TOPIC, (String)NO_TOPIC);
    }

    public LoggingPusher(String brokers, String topic, Optional<Config> kafkaConfig) {
        this.brokers = brokers;
        this.topic = topic;
    }

    @Override
    public void pushMessages(List<M> messages) {
        for (M message : messages) {
            log.info("Pushing to {}:{}: {}", new Object[]{this.brokers, this.topic, message.toString()});
        }
    }

    @Override
    public void close() throws IOException {
    }
}

