/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentKafkaSchemaRegistry
extends KafkaSchemaRegistry<Integer, Schema> {
    private static final Logger log = LoggerFactory.getLogger(ConfluentKafkaSchemaRegistry.class);
    public static final String CONFLUENT_MAX_SCHEMAS_PER_SUBJECT = "kafka.schema_registry.confluent.max_schemas_per_subject";
    public static final String CONFLUENT_SCHEMA_NAME_SUFFIX = "kafka.schema_registry.confluent.schema_name_suffix";
    private static final String DEFAULT_CONFLUENT_SCHEMA_NAME_SUFFIX = "-value";
    private final SchemaRegistryClient schemaRegistryClient;
    private final String schemaNameSuffix;

    public ConfluentKafkaSchemaRegistry(Properties props) {
        this(props, (SchemaRegistryClient)new CachedSchemaRegistryClient(props.getProperty("kafka.schema.registry.url"), Integer.parseInt(props.getProperty(CONFLUENT_MAX_SCHEMAS_PER_SUBJECT, String.valueOf(Integer.MAX_VALUE)))));
    }

    @VisibleForTesting
    ConfluentKafkaSchemaRegistry(Properties props, SchemaRegistryClient schemaRegistryClient) {
        super(props);
        this.schemaRegistryClient = schemaRegistryClient;
        this.schemaNameSuffix = props.getProperty(CONFLUENT_SCHEMA_NAME_SUFFIX, DEFAULT_CONFLUENT_SCHEMA_NAME_SUFFIX);
    }

    @Override
    protected Schema fetchSchemaByKey(Integer key) throws SchemaRegistryException {
        try {
            return this.schemaRegistryClient.getByID(key.intValue());
        }
        catch (RestClientException | IOException e) {
            throw new SchemaRegistryException(e);
        }
    }

    @Override
    public Schema getLatestSchemaByTopic(String topic) throws SchemaRegistryException {
        String schemaName = topic + this.schemaNameSuffix;
        try {
            return new Schema.Parser().parse(this.schemaRegistryClient.getLatestSchemaMetadata(schemaName).getSchema());
        }
        catch (RestClientException | IOException e) {
            log.error("Failed to get schema for topic " + topic + "; subject " + schemaName);
            throw new SchemaRegistryException(e);
        }
    }

    @Override
    public Integer register(Schema schema) throws SchemaRegistryException {
        return this.register(schema, schema.getName());
    }

    @Override
    public Integer register(Schema schema, String name) throws SchemaRegistryException {
        try {
            String schemaName = name + this.schemaNameSuffix;
            return this.schemaRegistryClient.register(schemaName, schema);
        }
        catch (RestClientException | IOException e) {
            throw new SchemaRegistryException(e);
        }
    }

    public SchemaRegistryClient getSchemaRegistryClient() {
        return this.schemaRegistryClient;
    }
}

