/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class UnionDataSchema
extends ComplexDataSchema {
    private List<DataSchema> _types = _emptyTypes;
    private Map<String, Integer> _typesToIndexMap = _emptyTypesToIndexMap;
    private Map<String, Integer> _namesToIndexMap = _emptyTypesToIndexMap;
    private Set<DataSchema> _typesDeclaredInline = _emptyTypeDeclaredInline;
    private static final List<DataSchema> _emptyTypes = Collections.emptyList();
    private static final Map<String, Integer> _emptyTypesToIndexMap = Collections.emptyMap();
    private static final Set<DataSchema> _emptyTypeDeclaredInline = Collections.emptySet();

    public UnionDataSchema() {
        super(DataSchema.Type.UNION);
    }

    public boolean setTypes(List<DataSchema> types, StringBuilder errorMessageBuilder) {
        boolean ok = false;
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>(types.size() * 2);
        HashMap<String, Integer> nameMap = new HashMap<String, Integer>(types.size() * 2);
        int index = 0;
        for (DataSchema type : types) {
            String member;
            Integer existing;
            if (type.getDereferencedType() == DataSchema.Type.UNION) {
                errorMessageBuilder.append(type).append(" union cannot be inside another union.\n");
                ok = false;
            }
            if ((existing = typeMap.put(member = type.getUnionMemberKey(), index)) != null) {
                errorMessageBuilder.append(type).append(" appears more than once in a union.\n");
                ok = false;
            } else {
                String name = UnionDataSchema.avroUnionMemberKey(type);
                existing = nameMap.put(name, index);
                if (existing != null) {
                    errorMessageBuilder.append(type).append(" has name " + name + " that appears more than once in a union, this may cause compatibility problems with Avro.\n");
                    ok = false;
                }
            }
            ++index;
        }
        this._types = Collections.unmodifiableList(types);
        this._typesToIndexMap = Collections.unmodifiableMap(typeMap);
        this._namesToIndexMap = Collections.unmodifiableMap(nameMap);
        if (!ok) {
            this.setHasError();
        }
        return ok;
    }

    public List<DataSchema> getTypes() {
        return this._types;
    }

    public int index(String type) {
        Integer index = this._typesToIndexMap.get(type);
        return index == null ? -1 : index;
    }

    public boolean contains(String type) {
        return this._typesToIndexMap.containsKey(type);
    }

    public DataSchema getType(String type) {
        Integer index = this._typesToIndexMap.get(type);
        return index != null ? this._types.get(index) : null;
    }

    public DataSchema getTypeByName(String typeName) {
        Integer index = this._namesToIndexMap.get(typeName);
        return index != null ? this._types.get(index) : null;
    }

    public void setTypesDeclaredInline(Set<DataSchema> typesDeclaredInline) {
        this._typesDeclaredInline = Collections.unmodifiableSet(typesDeclaredInline);
    }

    public boolean isTypeDeclaredInline(DataSchema type) {
        return this._typesDeclaredInline.contains(type);
    }

    @Override
    public String getUnionMemberKey() {
        return "union";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == UnionDataSchema.class) {
            UnionDataSchema other = (UnionDataSchema)object;
            return super.equals(other) && this._types.equals(other._types);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._types.hashCode();
    }

    public static String avroUnionMemberKey(DataSchema schema) {
        DataSchema dereferencedSchema = schema.getDereferencedDataSchema();
        String name = dereferencedSchema instanceof NamedDataSchema ? ((NamedDataSchema)dereferencedSchema).getName() : dereferencedSchema.getUnionMemberKey();
        return name;
    }
}

