/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.tools.compatibility;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.compatibility.CompatibilityChecker;
import com.linkedin.data.schema.compatibility.CompatibilityMessage;
import com.linkedin.data.schema.compatibility.CompatibilityOptions;
import com.linkedin.data.schema.compatibility.CompatibilityResult;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.restli.common.validation.CreateOnly;
import com.linkedin.restli.common.validation.ReadOnly;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AlternativeKeySchema;
import com.linkedin.restli.restspec.AssocKeySchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.CustomAnnotationContentSchema;
import com.linkedin.restli.restspec.CustomAnnotationContentSchemaMap;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.IdentifierSchema;
import com.linkedin.restli.restspec.MetadataSchema;
import com.linkedin.restli.restspec.ParameterSchema;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestSpecAnnotation;
import com.linkedin.restli.restspec.RestSpecCodec;
import com.linkedin.restli.restspec.SimpleSchema;
import com.linkedin.restli.tools.compatibility.CompatibilityInfoMap;
import com.linkedin.restli.tools.idlcheck.CompatibilityInfo;
import com.linkedin.restli.tools.idlcheck.CompatibilityLevel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ResourceCompatibilityChecker {
    private final ResourceSchema _prevSchema;
    private final ResourceSchema _currSchema;
    private final DataSchemaResolver _prevSchemaResolver;
    private final DataSchemaResolver _currSchemaResolver;
    private boolean _checked;
    private CompatibilityInfoMap _infoMap = new CompatibilityInfoMap();
    private Stack<Object> _infoPath = new Stack();
    private Set<String> _namedSchemasChecked = new HashSet<String>();
    private static final CompatibilityOptions defaultOptions = new CompatibilityOptions().setMode(CompatibilityOptions.Mode.SCHEMA).setAllowPromotions(false);

    public ResourceCompatibilityChecker(ResourceSchema prevSchema, DataSchemaResolver prevSchemaResolver, ResourceSchema currSchema, DataSchemaResolver currSchemaResolver) {
        this._prevSchema = prevSchema;
        this._currSchema = currSchema;
        this._prevSchemaResolver = prevSchemaResolver;
        this._currSchemaResolver = currSchemaResolver;
        this._checked = false;
        this._infoPath.push("");
    }

    public boolean check(CompatibilityLevel level) {
        if (!this._checked) {
            this.runCheck();
        }
        return this._infoMap.isCompatible(level);
    }

    public void check() {
        if (!this._checked) {
            this.runCheck();
        }
    }

    public CompatibilityInfoMap getInfoMap() {
        return this._infoMap;
    }

    private void runCheck() {
        ValidationOptions valOptions = new ValidationOptions();
        boolean valResult = this.validateData(this._prevSchema.data(), (DataSchema)this._prevSchema.schema(), valOptions);
        if (valResult &= this.validateData(this._currSchema.data(), (DataSchema)this._currSchema.schema(), valOptions)) {
            this.checkResourceSchema(this._prevSchema, this._currSchema);
        }
        this._checked = true;
    }

    private boolean validateData(DataMap object, DataSchema schema, ValidationOptions options) {
        ValidationResult valResult = ValidateDataAgainstSchema.validate((Object)object, (DataSchema)schema, (ValidationOptions)options);
        if (valResult.isValid()) {
            return true;
        }
        Collection valErrorMessages = valResult.getMessages();
        for (Message message : valErrorMessages) {
            this._infoMap.addRestSpecInfo(message);
        }
        return false;
    }

    private boolean isOptionalityCompatible(RecordDataSchema.Field field, Object leader, Object follower) {
        boolean isCompatible;
        boolean isLeaderNull = leader == null;
        boolean isFollowerNull = follower == null;
        boolean bl = isCompatible = isLeaderNull || !isFollowerNull || !field.getOptional();
        if (isCompatible && isLeaderNull != isFollowerNull) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.OPTIONAL_VALUE, this._infoPath, field.getName());
        }
        return isCompatible;
    }

    private boolean checkEqualSingleValue(RecordDataSchema.Field field, Object prevData, Object currData) {
        assert (field != null);
        if (!this.isOptionalityCompatible(field, prevData, currData)) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.VALUE_WRONG_OPTIONALITY, this._infoPath, field.getName());
            return false;
        }
        if (prevData != null && !prevData.equals(currData)) {
            this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.VALUE_NOT_EQUAL, this._infoPath, prevData, currData);
            return false;
        }
        return true;
    }

    private boolean checkDoc(RecordDataSchema.Field field, Object prevData, Object currData) {
        assert (field != null);
        if (prevData == null != (currData == null)) {
            this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.DOC_NOT_EQUAL, this._infoPath, new Object[0]);
            return false;
        }
        if (prevData != null && !prevData.equals(currData)) {
            this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.DOC_NOT_EQUAL, this._infoPath, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkPagingSupport(Boolean prevPaging, Boolean currPaging) {
        if (prevPaging == currPaging) {
            return true;
        }
        if ((prevPaging == null || !prevPaging.booleanValue()) && currPaging != null && currPaging.booleanValue()) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.PAGING_ADDED, this._infoPath, new Object[0]);
            return false;
        }
        if (prevPaging != null && prevPaging.booleanValue() && (currPaging == null || !currPaging.booleanValue())) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.PAGING_REMOVED, this._infoPath, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkArrayContainment(RecordDataSchema.Field field, List<? extends Object> container, List<? extends Object> containee) {
        assert (field != null);
        if (!this.isOptionalityCompatible(field, containee, container)) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.VALUE_WRONG_OPTIONALITY, this._infoPath, field.getName());
            return false;
        }
        if (containee == null) {
            return true;
        }
        boolean isContained = container.containsAll(containee);
        if (isContained) {
            if (container.size() > containee.size()) {
                HashSet<? extends Object> diff = new HashSet<Object>(container);
                diff.removeAll(containee);
                this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.SUPERSET, this._infoPath, diff);
            }
            return true;
        }
        this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.ARRAY_NOT_CONTAIN, this._infoPath, containee);
        return false;
    }

    private boolean checkType(Object pathTail, String prevType, String currType, boolean allowNull) {
        if (prevType == null && currType == null && allowNull) {
            return true;
        }
        if (prevType == null || currType == null) {
            this._infoMap.addRestSpecInfo(pathTail, CompatibilityInfo.Type.TYPE_MISSING, this._infoPath, new Object[0]);
            return false;
        }
        try {
            DataSchema prevSchema = RestSpecCodec.textToSchema((String)prevType, (DataSchemaResolver)this._prevSchemaResolver);
            DataSchema currSchema = RestSpecCodec.textToSchema((String)currType, (DataSchemaResolver)this._currSchemaResolver);
            CompatibilityResult compatibilityResult = CompatibilityChecker.checkCompatibility((DataSchema)prevSchema, (DataSchema)currSchema, (CompatibilityOptions)defaultOptions);
            if (!compatibilityResult.getMessages().isEmpty()) {
                if (prevType.equals(currType) && prevSchema instanceof NamedDataSchema) {
                    if (!this._namedSchemasChecked.contains(prevType)) {
                        this.addNamedCompatibilityMessages(compatibilityResult.getMessages());
                        this._namedSchemasChecked.add(prevType);
                    }
                    return compatibilityResult.isError();
                }
                this.addCompatibilityMessages(pathTail, compatibilityResult.getMessages());
                return compatibilityResult.isError();
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            this._infoMap.addRestSpecInfo(pathTail, CompatibilityInfo.Type.TYPE_UNKNOWN, this._infoPath, e.getMessage());
            return false;
        }
    }

    private void addNamedCompatibilityMessages(Collection<CompatibilityMessage> messages) {
        for (CompatibilityMessage message : messages) {
            this._infoMap.addModelInfo(message);
        }
    }

    private void addCompatibilityMessages(Object pathTail, Collection<CompatibilityMessage> messages) {
        for (CompatibilityMessage message : messages) {
            this._infoMap.addRestSpecInfo(pathTail, message, this._infoPath);
        }
    }

    private boolean checkParameterOptionality(RecordDataSchema.Field field, Boolean prevOptional, Boolean currOptional) {
        assert (field != null);
        if (!this.isOptionalityCompatible(field, currOptional, prevOptional)) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.VALUE_WRONG_OPTIONALITY, this._infoPath, field.getName());
            return false;
        }
        if (currOptional == null) {
            return true;
        }
        if (prevOptional.booleanValue() && !currOptional.booleanValue()) {
            this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.PARAMETER_WRONG_OPTIONALITY, this._infoPath, new Object[0]);
            return false;
        }
        if (!prevOptional.booleanValue() && currOptional.booleanValue()) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.OPTIONAL_PARAMETER, this._infoPath, new Object[0]);
        }
        return true;
    }

    private <T extends RecordTemplate> void checkRecordTemplate(T prevRec, T currRec) {
        Class<?> prevClass = prevRec.getClass();
        if (prevClass == ResourceSchema.class) {
            this.checkResourceSchema((ResourceSchema)prevRec, (ResourceSchema)currRec);
        } else if (prevClass == CollectionSchema.class) {
            this.checkCollectionSchema((CollectionSchema)prevRec, (CollectionSchema)currRec);
        } else if (prevClass == IdentifierSchema.class) {
            this.checkIdentifierSchema((IdentifierSchema)prevRec, (IdentifierSchema)currRec);
        } else if (prevClass == FinderSchema.class) {
            this.checkFinderSchema((FinderSchema)prevRec, (FinderSchema)currRec);
        } else if (prevClass == ParameterSchema.class) {
            this.checkParameterSchema((ParameterSchema)prevRec, (ParameterSchema)currRec);
        } else if (prevClass == MetadataSchema.class) {
            this.checkMetadataSchema((MetadataSchema)prevRec, (MetadataSchema)currRec);
        } else if (prevClass == ActionSchema.class) {
            this.checkActionSchema((ActionSchema)prevRec, (ActionSchema)currRec);
        } else if (prevClass == EntitySchema.class) {
            this.checkEntitySchema((EntitySchema)prevRec, (EntitySchema)currRec);
        } else if (prevClass == AssociationSchema.class) {
            this.checkAssociationSchema((AssociationSchema)prevRec, (AssociationSchema)currRec);
        } else if (prevClass == SimpleSchema.class) {
            this.checkSimpleSchema((SimpleSchema)prevRec, (SimpleSchema)currRec);
        } else if (prevClass == AssocKeySchema.class) {
            this.checkAssocKeySchema((AssocKeySchema)prevRec, (AssocKeySchema)currRec);
        } else if (prevClass == ActionsSetSchema.class) {
            this.checkActionsSetSchema((ActionsSetSchema)prevRec, (ActionsSetSchema)currRec);
        } else if (prevClass == RestMethodSchema.class) {
            this.checkRestMethodSchema((RestMethodSchema)prevRec, (RestMethodSchema)currRec);
        } else if (prevClass == AlternativeKeySchema.class) {
            this.checkAlternativeKeySchema((AlternativeKeySchema)prevRec, (AlternativeKeySchema)currRec);
        } else {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.OTHER_ERROR, this._infoPath, "Unknown schema type: \"" + prevRec.getClass() + "\"");
        }
    }

    private <T extends RecordTemplate> boolean checkComplexField(RecordDataSchema.Field field, T prevRec, T currRec) {
        assert (field != null);
        if (!this.isOptionalityCompatible(field, prevRec, currRec)) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.VALUE_WRONG_OPTIONALITY, this._infoPath, field.getName());
            return false;
        }
        if (prevRec != null) {
            this._infoPath.push(field.getName());
            this.checkRecordTemplate(prevRec, currRec);
            this._infoPath.pop();
        }
        return true;
    }

    private <T extends WrappingArrayTemplate<? extends RecordTemplate>> boolean checkComplexArrayField(RecordDataSchema.Field field, String keyName, T prevArray, T currArray, HashMap<String, Integer> currRemainder, boolean checkRemainder) {
        assert (field != null);
        assert (currRemainder != null);
        if (!this.isOptionalityCompatible(field, prevArray, currArray)) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.VALUE_WRONG_OPTIONALITY, this._infoPath, field.getName());
            return false;
        }
        if (prevArray == null) {
            return true;
        }
        assert (prevArray.getClass() == currArray.getClass());
        this._infoPath.push(field.getName());
        for (int i = 0; i < currArray.size(); ++i) {
            currRemainder.put(((RecordTemplate)currArray.get(i)).data().getString(keyName), i);
        }
        for (RecordTemplate prevElement : prevArray) {
            String prevKey = prevElement.data().getString(keyName);
            Integer currIndex = currRemainder.get(prevKey);
            if (currIndex == null) {
                this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.ARRAY_MISSING_ELEMENT, this._infoPath, prevKey);
                continue;
            }
            RecordTemplate currElement = (RecordTemplate)currArray.get(currIndex.intValue());
            currRemainder.remove(prevKey);
            this._infoPath.push(prevKey);
            this.checkRecordTemplate(prevElement, currElement);
            this._infoPath.pop();
        }
        if (checkRemainder && !currRemainder.isEmpty()) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.SUPERSET, this._infoPath, currRemainder.keySet());
        }
        this._infoPath.pop();
        return true;
    }

    private <T extends WrappingArrayTemplate<? extends RecordTemplate>> boolean checkComplexArrayField(RecordDataSchema.Field field, String keyName, T prevArray, T currArray) {
        return this.checkComplexArrayField(field, keyName, prevArray, currArray, new HashMap<String, Integer>(), true);
    }

    private <T extends WrappingArrayTemplate<? extends RecordTemplate>> boolean checkEqualComplexArrayField(RecordDataSchema.Field field, String keyName, T prevArray, T currArray) {
        HashMap<String, Integer> currRemainder = new HashMap<String, Integer>();
        if (!this.checkComplexArrayField(field, keyName, prevArray, currArray, currRemainder, false)) {
            return false;
        }
        if (!currRemainder.isEmpty()) {
            this._infoMap.addRestSpecInfo(field.getName(), CompatibilityInfo.Type.ARRAY_NOT_EQUAL, this._infoPath, prevArray);
            return false;
        }
        return true;
    }

    private boolean checkParameterArrayField(RecordDataSchema.Field field, ParameterSchemaArray prevArray, ParameterSchemaArray currArray) {
        HashMap<String, Integer> currRemainder = new HashMap<String, Integer>();
        if (!this.checkComplexArrayField(field, "name", prevArray, currArray, currRemainder, false)) {
            return false;
        }
        this._infoPath.push(field.getName());
        boolean result = true;
        for (int paramIndex : currRemainder.values()) {
            ParameterSchema param = (ParameterSchema)currArray.get(paramIndex);
            if (this.isQueryParameterOptional(param.isOptional(), param.getDefault(GetMode.DEFAULT))) {
                this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.PARAMETER_NEW_OPTIONAL, this._infoPath, param.getName());
                continue;
            }
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.PARAMETER_NEW_REQUIRED, this._infoPath, param.getName());
            result = false;
        }
        this._infoPath.pop();
        return result;
    }

    private String getParameterItems(ParameterSchema param, DataSchemaResolver resolver) {
        if (param.hasItems()) {
            this._infoMap.addRestSpecInfo(CompatibilityInfo.Type.DEPRECATED, this._infoPath, "The \"items\" field");
            return param.getItems(GetMode.DEFAULT);
        }
        DataSchema paramDataSchema = RestSpecCodec.textToSchema((String)param.getType(GetMode.DEFAULT), (DataSchemaResolver)resolver);
        if (paramDataSchema instanceof ArrayDataSchema) {
            return ((ArrayDataSchema)paramDataSchema).getItems().getUnionMemberKey();
        }
        this._infoMap.addRestSpecInfo("type", CompatibilityInfo.Type.TYPE_ERROR, this._infoPath, "expect an array, got " + paramDataSchema.getType());
        return null;
    }

    private void checkResourceSchema(ResourceSchema prevRec, ResourceSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkDoc(prevRec.schema().getField("doc"), prevRec.getDoc(GetMode.DEFAULT), currRec.getDoc(GetMode.DEFAULT));
        this.checkAnnotationsMap(prevRec.schema().getField("annotations"), prevRec.getAnnotations(GetMode.DEFAULT), currRec.getAnnotations(GetMode.DEFAULT));
        this.checkRestLiDataAnnotations(prevRec.schema().getField("annotations"), prevRec.getAnnotations(GetMode.DEFAULT), currRec.getAnnotations(GetMode.DEFAULT), prevRec.getSchema(GetMode.DEFAULT), currRec.getSchema(GetMode.DEFAULT));
        this.checkEqualSingleValue(prevRec.schema().getField("namespace"), prevRec.getNamespace(GetMode.DEFAULT), currRec.getNamespace(GetMode.DEFAULT));
        this.checkEqualSingleValue(prevRec.schema().getField("path"), prevRec.getPath(GetMode.DEFAULT), currRec.getPath(GetMode.DEFAULT));
        this.checkType("schema", prevRec.getSchema(GetMode.DEFAULT), currRec.getSchema(GetMode.DEFAULT), prevRec.hasActionsSet());
        this.checkComplexField(prevRec.schema().getField("collection"), prevRec.getCollection(), currRec.getCollection());
        this.checkComplexField(prevRec.schema().getField("association"), prevRec.getAssociation(), currRec.getAssociation());
        this.checkComplexField(prevRec.schema().getField("simple"), prevRec.getSimple(), currRec.getSimple());
        this.checkComplexField(prevRec.schema().getField("actionsSet"), prevRec.getActionsSet(), currRec.getActionsSet());
    }

    private void checkCollectionSchema(CollectionSchema prevRec, CollectionSchema currRec) {
        this.checkComplexField(prevRec.schema().getField("identifier"), prevRec.getIdentifier(GetMode.DEFAULT), currRec.getIdentifier(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("alternativeKeys"), "name", prevRec.getAlternativeKeys(GetMode.DEFAULT), currRec.getAlternativeKeys(GetMode.DEFAULT));
        this.checkArrayContainment(prevRec.schema().getField("supports"), (List<? extends Object>)currRec.getSupports(GetMode.DEFAULT), (List<? extends Object>)prevRec.getSupports(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("methods"), "method", prevRec.getMethods(GetMode.DEFAULT), currRec.getMethods(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("finders"), "name", prevRec.getFinders(GetMode.DEFAULT), currRec.getFinders(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("actions"), "name", prevRec.getActions(GetMode.DEFAULT), currRec.getActions(GetMode.DEFAULT));
        this.checkComplexField(prevRec.schema().getField("entity"), prevRec.getEntity(GetMode.DEFAULT), currRec.getEntity(GetMode.DEFAULT));
    }

    private void checkIdentifierSchema(IdentifierSchema prevRec, IdentifierSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkType("type", prevRec.getType(GetMode.DEFAULT), currRec.getType(GetMode.DEFAULT), false);
        this.checkType("params", prevRec.getParams(GetMode.DEFAULT), currRec.getParams(GetMode.DEFAULT), true);
    }

    private void checkFinderSchema(FinderSchema prevRec, FinderSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkDoc(prevRec.schema().getField("doc"), prevRec.getDoc(GetMode.DEFAULT), currRec.getDoc(GetMode.DEFAULT));
        this.checkAnnotationsMap(prevRec.schema().getField("annotations"), prevRec.getAnnotations(GetMode.DEFAULT), currRec.getAnnotations(GetMode.DEFAULT));
        this.checkParameterArrayField(prevRec.schema().getField("parameters"), prevRec.getParameters(GetMode.DEFAULT), currRec.getParameters(GetMode.DEFAULT));
        this.checkComplexField(prevRec.schema().getField("metadata"), prevRec.getMetadata(GetMode.DEFAULT), currRec.getMetadata(GetMode.DEFAULT));
        this.checkPagingSupport(prevRec.isPagingSupported(GetMode.DEFAULT), currRec.isPagingSupported(GetMode.DEFAULT));
        String prevAssocKey = prevRec.getAssocKey(GetMode.DEFAULT);
        String currAssocKey = currRec.getAssocKey(GetMode.DEFAULT);
        StringArray prevAssocKeys = prevRec.getAssocKeys(GetMode.DEFAULT);
        StringArray currAssocKeys = currRec.getAssocKeys(GetMode.DEFAULT);
        assert (!(prevAssocKey != null && prevAssocKeys != null || currAssocKey != null && currAssocKeys != null));
        if (prevAssocKeys == null && currAssocKeys == null) {
            this.checkEqualSingleValue(prevRec.schema().getField("assocKey"), prevAssocKey, currAssocKey);
        } else if (prevAssocKey == null && currAssocKey == null) {
            this.checkEqualSingleValue(prevRec.schema().getField("assocKeys"), prevAssocKeys, currAssocKeys);
        } else if (prevAssocKeys == null) {
            StringArray upgradedPrevAssocKeys = new StringArray();
            upgradedPrevAssocKeys.add((Object)prevAssocKey);
            this.checkEqualSingleValue(prevRec.schema().getField("assocKey"), upgradedPrevAssocKeys, currAssocKeys);
        } else {
            this._infoMap.addRestSpecInfo("assocKeys", CompatibilityInfo.Type.FINDER_ASSOCKEYS_DOWNGRADE, this._infoPath, new Object[0]);
        }
    }

    private void checkSimpleSchema(SimpleSchema prevRec, SimpleSchema currRec) {
        this.checkArrayContainment(prevRec.schema().getField("supports"), (List<? extends Object>)currRec.getSupports(GetMode.DEFAULT), (List<? extends Object>)prevRec.getSupports(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("methods"), "method", prevRec.getMethods(GetMode.DEFAULT), currRec.getMethods(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("actions"), "name", prevRec.getActions(GetMode.DEFAULT), currRec.getActions(GetMode.DEFAULT));
        this.checkComplexField(prevRec.schema().getField("entity"), prevRec.getEntity(GetMode.DEFAULT), currRec.getEntity(GetMode.DEFAULT));
    }

    private void checkAlternativeKeySchema(AlternativeKeySchema prevRec, AlternativeKeySchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkDoc(prevRec.schema().getField("doc"), prevRec.getDoc(GetMode.DEFAULT), currRec.getDoc(GetMode.DEFAULT));
        this.checkEqualSingleValue(prevRec.schema().getField("type"), prevRec.getType(GetMode.DEFAULT), currRec.getType(GetMode.DEFAULT));
        this.checkEqualSingleValue(prevRec.schema().getField("keyCoercer"), prevRec.getKeyCoercer(GetMode.DEFAULT), currRec.getKeyCoercer(GetMode.DEFAULT));
    }

    private void checkParameterSchema(ParameterSchema prevRec, ParameterSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkDoc(prevRec.schema().getField("doc"), prevRec.getDoc(GetMode.DEFAULT), currRec.getDoc(GetMode.DEFAULT));
        this.checkAnnotationsMap(prevRec.schema().getField("annotations"), prevRec.getAnnotations(GetMode.DEFAULT), currRec.getAnnotations(GetMode.DEFAULT));
        if (prevRec.hasItems() || currRec.hasItems()) {
            String prevItems = this.getParameterItems(prevRec, this._prevSchemaResolver);
            String currItems = this.getParameterItems(currRec, this._currSchemaResolver);
            if (prevItems != null && currItems != null) {
                this.checkType("items", prevItems, currItems, false);
            }
        } else {
            this.checkType("type", prevRec.getType(GetMode.DEFAULT), currRec.getType(GetMode.DEFAULT), false);
        }
        Boolean prevOptional = prevRec.isOptional(GetMode.DEFAULT);
        Boolean currOptional = currRec.isOptional(GetMode.DEFAULT);
        String prevDefault = prevRec.getDefault(GetMode.DEFAULT);
        String currDefault = currRec.getDefault(GetMode.DEFAULT);
        assert (!(prevOptional != null && prevDefault != null || currOptional != null && currDefault != null));
        this.checkParameterOptionality(prevRec.schema().getField("optional"), this.isQueryParameterOptional(prevOptional, prevDefault), this.isQueryParameterOptional(currOptional, currDefault));
        if (prevDefault != null && currDefault != null && !prevDefault.equals(currDefault)) {
            this._infoMap.addRestSpecInfo("default", CompatibilityInfo.Type.VALUE_DIFFERENT, this._infoPath, prevDefault, currDefault);
        }
    }

    private void checkMetadataSchema(MetadataSchema prevRec, MetadataSchema currRec) {
        this.checkType("type", prevRec.getType(GetMode.DEFAULT), currRec.getType(GetMode.DEFAULT), false);
    }

    private void checkActionSchema(ActionSchema prevRec, ActionSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkDoc(prevRec.schema().getField("doc"), prevRec.getDoc(GetMode.DEFAULT), currRec.getDoc(GetMode.DEFAULT));
        this.checkAnnotationsMap(prevRec.schema().getField("annotations"), prevRec.getAnnotations(GetMode.DEFAULT), currRec.getAnnotations(GetMode.DEFAULT));
        this.checkParameterArrayField(prevRec.schema().getField("parameters"), prevRec.getParameters(GetMode.DEFAULT), currRec.getParameters(GetMode.DEFAULT));
        this.checkType("returns", prevRec.getReturns(), currRec.getReturns(), true);
        this.checkArrayContainment(prevRec.schema().getField("throws"), (List<? extends Object>)prevRec.getThrows(GetMode.DEFAULT), (List<? extends Object>)currRec.getThrows(GetMode.DEFAULT));
    }

    private void checkRestLiDataAnnotations(RecordDataSchema.Field field, CustomAnnotationContentSchemaMap prevMap, CustomAnnotationContentSchemaMap currMap, String prevType, String currType) {
        if (prevType == null || currType == null) {
            return;
        }
        this._infoPath.push(field.getName());
        DataSchema prevSchema = RestSpecCodec.textToSchema((String)prevType, (DataSchemaResolver)this._prevSchemaResolver);
        DataSchema currSchema = RestSpecCodec.textToSchema((String)currType, (DataSchemaResolver)this._currSchemaResolver);
        for (Class annotationClass : new Class[]{ReadOnly.class, CreateOnly.class}) {
            String annotationName = annotationClass.getAnnotation(RestSpecAnnotation.class).name();
            HashSet prevPaths = new HashSet();
            if (prevMap != null && prevMap.containsKey((Object)annotationName)) {
                prevPaths.addAll((DataList)((CustomAnnotationContentSchema)prevMap.get((Object)annotationName)).data().get((Object)"value"));
            }
            HashSet currPaths = new HashSet();
            if (currMap != null && currMap.containsKey((Object)annotationName)) {
                currPaths.addAll((DataList)((CustomAnnotationContentSchema)currMap.get((Object)annotationName)).data().get((Object)"value"));
            }
            HashSet addedPaths = new HashSet(currPaths);
            addedPaths.removeAll(prevPaths);
            for (Object path : addedPaths) {
                String pathString = path.toString();
                if (!DataSchemaUtil.containsPath((DataSchema)prevSchema, (String)pathString)) continue;
                this._infoMap.addRestSpecInfo(pathString, CompatibilityInfo.Type.ANNOTATION_CHANGE_BREAKS_OLD_CLIENT, this._infoPath, "Cannot add " + annotationClass.getSimpleName() + " annotation");
            }
            HashSet removedPaths = new HashSet(prevPaths);
            removedPaths.removeAll(currPaths);
            for (Object path : removedPaths) {
                String pathString = path.toString();
                if (!DataSchemaUtil.containsPath((DataSchema)currSchema, (String)pathString)) continue;
                if (!DataSchemaUtil.getField((DataSchema)currSchema, (String)pathString).getOptional() && annotationClass.equals(ReadOnly.class)) {
                    this._infoMap.addRestSpecInfo(pathString, CompatibilityInfo.Type.ANNOTATION_CHANGE_BREAKS_NEW_SERVER, this._infoPath, "Cannot remove " + annotationClass.getSimpleName() + " annotation");
                    continue;
                }
                this._infoMap.addRestSpecInfo(pathString, CompatibilityInfo.Type.ANNOTATION_CHANGE_MAY_REQUIRE_CLIENT_CODE_CHANGE, this._infoPath, "Cannot remove " + annotationClass.getSimpleName() + " annotation");
            }
        }
        this._infoPath.pop();
    }

    private void checkAnnotationsMap(RecordDataSchema.Field field, CustomAnnotationContentSchemaMap prevMap, CustomAnnotationContentSchemaMap currMap) {
        HashSet allKeys = new HashSet();
        if (prevMap != null) {
            allKeys.addAll(prevMap.keySet());
        }
        if (currMap != null) {
            allKeys.addAll(currMap.keySet());
        }
        for (String key : allKeys) {
            CustomAnnotationContentSchema prevMapAnnotation = prevMap == null ? null : (CustomAnnotationContentSchema)prevMap.get((Object)key);
            CustomAnnotationContentSchema currMapAnnotation = currMap == null ? null : (CustomAnnotationContentSchema)currMap.get((Object)key);
            this._infoPath.push(field.getName());
            this.checkAnnotationsSchema(key, prevMapAnnotation, currMapAnnotation);
            this._infoPath.pop();
        }
    }

    private void checkAnnotationsSchema(String key, CustomAnnotationContentSchema prevRec, CustomAnnotationContentSchema currRec) {
        if (prevRec == null) {
            this._infoMap.addRestSpecInfo(key, CompatibilityInfo.Type.ANNOTATIONS_CHANGED, this._infoPath, "added");
        } else if (currRec == null) {
            this._infoMap.addRestSpecInfo(key, CompatibilityInfo.Type.ANNOTATIONS_CHANGED, this._infoPath, "removed");
        } else if (!prevRec.equals((Object)currRec)) {
            this._infoMap.addRestSpecInfo(key, CompatibilityInfo.Type.ANNOTATIONS_CHANGED, this._infoPath, "value changed");
        }
    }

    private void checkEntitySchema(EntitySchema prevRec, EntitySchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("path"), prevRec.getPath(GetMode.DEFAULT), currRec.getPath(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("actions"), "name", prevRec.getActions(GetMode.DEFAULT), currRec.getActions(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("subresources"), "name", prevRec.getSubresources(GetMode.DEFAULT), currRec.getSubresources(GetMode.DEFAULT));
    }

    private void checkAssociationSchema(AssociationSchema prevRec, AssociationSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("identifier"), prevRec.getIdentifier(GetMode.DEFAULT), currRec.getIdentifier(GetMode.DEFAULT));
        this.checkEqualComplexArrayField(prevRec.schema().getField("assocKeys"), "name", prevRec.getAssocKeys(GetMode.DEFAULT), currRec.getAssocKeys(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("alternativeKeys"), "name", prevRec.getAlternativeKeys(GetMode.DEFAULT), currRec.getAlternativeKeys(GetMode.DEFAULT));
        this.checkArrayContainment(prevRec.schema().getField("supports"), (List<? extends Object>)currRec.getSupports(GetMode.DEFAULT), (List<? extends Object>)prevRec.getSupports(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("methods"), "method", prevRec.getMethods(GetMode.DEFAULT), currRec.getMethods(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("finders"), "name", prevRec.getFinders(GetMode.DEFAULT), currRec.getFinders(GetMode.DEFAULT));
        this.checkComplexArrayField(prevRec.schema().getField("actions"), "name", prevRec.getActions(GetMode.DEFAULT), currRec.getActions(GetMode.DEFAULT));
        this.checkComplexField(prevRec.schema().getField("entity"), prevRec.getEntity(GetMode.DEFAULT), currRec.getEntity(GetMode.DEFAULT));
    }

    private void checkAssocKeySchema(AssocKeySchema prevRec, AssocKeySchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("name"), prevRec.getName(GetMode.DEFAULT), currRec.getName(GetMode.DEFAULT));
        this.checkType("type", prevRec.getType(GetMode.DEFAULT), currRec.getType(GetMode.DEFAULT), false);
    }

    private void checkActionsSetSchema(ActionsSetSchema prevRec, ActionsSetSchema currRec) {
        this.checkComplexArrayField(prevRec.schema().getField("actions"), "name", prevRec.getActions(GetMode.DEFAULT), currRec.getActions(GetMode.DEFAULT));
    }

    private void checkRestMethodSchema(RestMethodSchema prevRec, RestMethodSchema currRec) {
        this.checkEqualSingleValue(prevRec.schema().getField("method"), prevRec.getMethod(GetMode.DEFAULT), currRec.getMethod(GetMode.DEFAULT));
        this.checkDoc(prevRec.schema().getField("doc"), prevRec.getDoc(GetMode.DEFAULT), currRec.getDoc(GetMode.DEFAULT));
        this.checkAnnotationsMap(prevRec.schema().getField("annotations"), prevRec.getAnnotations(GetMode.DEFAULT), currRec.getAnnotations(GetMode.DEFAULT));
        this.checkParameterArrayField(prevRec.schema().getField("parameters"), prevRec.getParameters(GetMode.DEFAULT), currRec.getParameters(GetMode.DEFAULT));
        this.checkPagingSupport(prevRec.isPagingSupported(GetMode.DEFAULT), currRec.isPagingSupported(GetMode.DEFAULT));
    }

    private boolean isQueryParameterOptional(Boolean isOptional, String defaultValue) {
        return isOptional == null ? defaultValue != null : isOptional;
    }
}

