/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.fork;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.runtime.BoundedBlockingRecordQueue;
import org.apache.gobblin.runtime.ExecutionModel;
import org.apache.gobblin.runtime.TaskContext;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.fork.Fork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousFork
extends Fork {
    private static final Logger log = LoggerFactory.getLogger(AsynchronousFork.class);
    private final BoundedBlockingRecordQueue<Object> recordQueue;

    public AsynchronousFork(TaskContext taskContext, Object schema, int branches, int index, ExecutionModel executionModel) throws Exception {
        super(taskContext, schema, branches, index, executionModel);
        TaskState taskState = taskContext.getTaskState();
        this.recordQueue = BoundedBlockingRecordQueue.newBuilder().hasCapacity(taskState.getPropAsInt("fork.record.queue.capacity", 100)).useTimeout(taskState.getPropAsLong("fork.record.queue.timeout", 1000L)).useTimeoutTimeUnit(TimeUnit.valueOf(taskState.getProp("fork.record.queue.timeout.unit", ConfigurationKeys.DEFAULT_FORK_RECORD_QUEUE_TIMEOUT_UNIT))).collectStats().build();
    }

    @Override
    public Optional<BoundedBlockingRecordQueue.QueueStats> queueStats() {
        return this.recordQueue.stats();
    }

    @Override
    protected void processRecords() throws IOException, DataConversionException {
        while (this.processRecord()) {
        }
    }

    @Override
    protected boolean putRecordImpl(Object record) throws InterruptedException {
        return this.recordQueue.put(record);
    }

    boolean processRecord() throws IOException, DataConversionException {
        try {
            Object record = this.recordQueue.get();
            if (record == null || record == Fork.SHUTDOWN_RECORD) {
                if (this.isParentTaskDone()) {
                    return false;
                }
            } else {
                this.processRecord(record);
            }
        }
        catch (InterruptedException ie) {
            log.warn("Interrupted while trying to get a record off the queue", (Throwable)ie);
            Throwables.propagate((Throwable)ie);
        }
        return true;
    }
}

