/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.AbstractIdleService;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.InMemoryJobCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingJobCatalog
extends AbstractIdleService
implements JobCatalog {
    protected final JobCatalog _fallback;
    protected final InMemoryJobCatalog _cache;
    protected final Logger _log;

    public CachingJobCatalog(JobCatalog fallback, Optional<Logger> log) {
        this._log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        this._fallback = fallback;
        this._cache = new InMemoryJobCatalog(log);
        this._fallback.addListener(new FallbackCatalogListener());
    }

    @Override
    public Collection<JobSpec> getJobs() {
        return this._cache.getJobs();
    }

    @Override
    public JobSpec getJobSpec(URI uri) throws JobSpecNotFoundException {
        try {
            return this._cache.getJobSpec(uri);
        }
        catch (RuntimeException e) {
            return this._fallback.getJobSpec(uri);
        }
    }

    protected void startUp() {
        this._cache.startAsync();
        try {
            this._cache.awaitRunning(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            throw new RuntimeException("Failed to start " + CachingJobCatalog.class.getName(), te);
        }
    }

    protected void shutDown() {
        this._cache.stopAsync();
        try {
            this._cache.awaitTerminated(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            throw new RuntimeException("Failed to stop " + CachingJobCatalog.class.getName(), te);
        }
    }

    @Override
    public void addListener(JobCatalogListener jobListener) {
        this._cache.addListener(jobListener);
    }

    @Override
    public void removeListener(JobCatalogListener jobListener) {
        this._cache.removeListener(jobListener);
    }

    @Override
    public void registerWeakJobCatalogListener(JobCatalogListener jobListener) {
        this._cache.registerWeakJobCatalogListener(jobListener);
    }

    public MetricContext getMetricContext() {
        return this._fallback.getMetricContext();
    }

    public boolean isInstrumentationEnabled() {
        return this._fallback.isInstrumentationEnabled();
    }

    public List<Tag<?>> generateTags(State state) {
        return this._fallback.generateTags(state);
    }

    public void switchMetricContext(List<Tag<?>> tags) {
        this._fallback.switchMetricContext(tags);
    }

    public void switchMetricContext(MetricContext context) {
        this._fallback.switchMetricContext(context);
    }

    @Override
    public JobCatalog.StandardMetrics getMetrics() {
        return this._fallback.getMetrics();
    }

    private class FallbackCatalogListener
    implements JobCatalogListener {
        private FallbackCatalogListener() {
        }

        @Override
        public void onAddJob(JobSpec addedJob) {
            CachingJobCatalog.this._cache.put(addedJob);
        }

        @Override
        public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
            CachingJobCatalog.this._cache.remove(deletedJobURI);
        }

        @Override
        public void onUpdateJob(JobSpec updatedJob) {
            CachingJobCatalog.this._cache.put(updatedJob);
        }
    }
}

