/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Service;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobCatalog;
import org.apache.gobblin.runtime.api.JobCatalogWithTemplates;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.MutableJobCatalog;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.ImmutableFSJobCatalog;
import org.apache.gobblin.runtime.template.HOCONInputStreamJobTemplate;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.filesystem.PathAlterationObserver;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSJobCatalog
extends ImmutableFSJobCatalog
implements MutableJobCatalog,
JobCatalogWithTemplates {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSJobCatalog.class);
    public static final String CONF_EXTENSION = ".conf";
    private static final String FS_SCHEME = "FS";
    protected final MutableJobCatalog.MutableStandardMetrics mutableMetrics;

    public FSJobCatalog(Config sysConfig) throws IOException {
        super(sysConfig);
        this.mutableMetrics = (MutableJobCatalog.MutableStandardMetrics)this.metrics;
    }

    public FSJobCatalog(GobblinInstanceEnvironment env) throws IOException {
        super(env);
        this.mutableMetrics = (MutableJobCatalog.MutableStandardMetrics)this.metrics;
    }

    public FSJobCatalog(Config sysConfig, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled) throws IOException {
        super(sysConfig, null, parentMetricContext, instrumentationEnabled);
        this.mutableMetrics = (MutableJobCatalog.MutableStandardMetrics)this.metrics;
    }

    @Override
    protected JobCatalog.StandardMetrics createStandardMetrics(Optional<Config> sysConfig) {
        this.log.info("create standard metrics {} for {}", (Object)MutableJobCatalog.MutableStandardMetrics.class.getName(), (Object)this.getClass().getName());
        return new MutableJobCatalog.MutableStandardMetrics(this, sysConfig);
    }

    @VisibleForTesting
    protected FSJobCatalog(Config sysConfig, PathAlterationObserver observer) throws IOException {
        super(sysConfig, observer);
        this.mutableMetrics = (MutableJobCatalog.MutableStandardMetrics)this.metrics;
    }

    @Override
    public synchronized void put(JobSpec jobSpec) {
        Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        Preconditions.checkNotNull((Object)jobSpec);
        try {
            long startTime = System.currentTimeMillis();
            Path jobSpecPath = this.getPathForURI(this.jobConfDirPath, jobSpec.getUri());
            this.materializedJobSpec(jobSpecPath, jobSpec, this.fs);
            this.mutableMetrics.updatePutJobTime(startTime);
        }
        catch (IOException e) {
            throw new RuntimeException("When persisting a new JobSpec, unexpected issues happen:" + e.getMessage());
        }
        catch (JobSpecNotFoundException e) {
            throw new RuntimeException("When replacing a existed JobSpec, unexpected issue happen:" + e.getMessage());
        }
    }

    @Override
    public synchronized void remove(URI jobURI) {
        Preconditions.checkState((this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)String.format("%s is not running.", this.getClass().getName()));
        try {
            long startTime = System.currentTimeMillis();
            Path jobSpecPath = this.getPathForURI(this.jobConfDirPath, jobURI);
            if (this.fs.exists(jobSpecPath)) {
                this.fs.delete(jobSpecPath, false);
                this.mutableMetrics.updateRemoveJobTime(startTime);
            } else {
                LOGGER.warn("No file with URI:" + jobSpecPath + " is found. Deletion failed.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("When removing a JobConf. file, issues unexpected happen:" + e.getMessage());
        }
    }

    @Override
    public boolean shouldLoadGlobalConf() {
        return false;
    }

    @Override
    public Path getPathForURI(Path jobConfDirPath, URI uri) {
        return super.getPathForURI(jobConfDirPath, uri).suffix(CONF_EXTENSION);
    }

    @Override
    protected Optional<String> getInjectedExtension() {
        return Optional.of((Object)CONF_EXTENSION);
    }

    synchronized void materializedJobSpec(Path jobSpecPath, JobSpec jobSpec, FileSystem fs) throws IOException, JobSpecNotFoundException {
        Path shadowDirectoryPath = new Path("/tmp");
        Path shadowFilePath = new Path(shadowDirectoryPath, UUID.randomUUID().toString());
        if (fs.exists(shadowFilePath)) {
            fs.delete(shadowFilePath, false);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"gobblin.fsJobCatalog.description", (Object)jobSpec.getDescription()).put((Object)"gobblin.fsJobCatalog.version", (Object)jobSpec.getVersion());
        if (jobSpec.getTemplateURI().isPresent()) {
            mapBuilder.put((Object)"job.template", (Object)((URI)jobSpec.getTemplateURI().get()).toString());
        }
        ImmutableMap injectedKeys = mapBuilder.build();
        String renderedConfig = ConfigFactory.parseMap((Map)injectedKeys).withFallback((ConfigMergeable)jobSpec.getConfig()).root().render(ConfigRenderOptions.defaults());
        try (FSDataOutputStream os = fs.create(shadowFilePath);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, Charsets.UTF_8);){
            writer.write(renderedConfig);
        }
        if (fs.exists(jobSpecPath) && !fs.delete(jobSpecPath, false)) {
            throw new IOException("Unable to delete existing job file: " + jobSpecPath);
        }
        if (!fs.rename(shadowFilePath, jobSpecPath)) {
            throw new IOException("Unable to rename job file: " + shadowFilePath + " to " + jobSpecPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobTemplate getTemplate(URI uri) throws SpecNotFoundException, JobTemplate.TemplateException {
        if (!uri.getScheme().equals(FS_SCHEME)) {
            throw new RuntimeException("Expected scheme FS got unsupported scheme " + uri.getScheme());
        }
        Path templateFullPath = PathUtils.mergePaths((Path)this.jobConfDirPath, (Path)new Path(uri.getPath()));
        try (FSDataInputStream is = this.fs.open(templateFullPath);){
            HOCONInputStreamJobTemplate hOCONInputStreamJobTemplate = new HOCONInputStreamJobTemplate((InputStream)is, uri, (JobCatalogWithTemplates)this);
            return hOCONInputStreamJobTemplate;
        }
        catch (IOException ioe) {
            throw new SpecNotFoundException(uri, (Throwable)ioe);
        }
    }

    @Override
    public Collection<JobTemplate> getAllTemplates() {
        throw new UnsupportedOperationException();
    }
}

