/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobCatalogListenersContainer;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.util.callbacks.CallbacksDispatcher;
import org.slf4j.Logger;

public class JobCatalogListenersList
implements JobCatalogListener,
JobCatalogListenersContainer,
Closeable {
    private final CallbacksDispatcher<JobCatalogListener> _disp;

    public JobCatalogListenersList() {
        this((Optional<Logger>)Optional.absent());
    }

    public JobCatalogListenersList(Optional<Logger> log) {
        this._disp = new CallbacksDispatcher(Optional.absent(), log);
    }

    public Logger getLog() {
        return this._disp.getLog();
    }

    public synchronized List<JobCatalogListener> getListeners() {
        return this._disp.getListeners();
    }

    @Override
    public synchronized void addListener(JobCatalogListener newListener) {
        this._disp.addListener((Object)newListener);
    }

    @Override
    public synchronized void removeListener(JobCatalogListener oldListener) {
        this._disp.removeListener((Object)oldListener);
    }

    @Override
    public synchronized void onAddJob(JobSpec addedJob) {
        Preconditions.checkNotNull((Object)addedJob);
        try {
            this._disp.execCallbacks((Function)new JobCatalogListener.AddJobCallback(addedJob));
        }
        catch (InterruptedException e) {
            this.getLog().warn("onAddJob interrupted.");
        }
    }

    @Override
    public synchronized void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
        Preconditions.checkNotNull((Object)deletedJobURI);
        try {
            this._disp.execCallbacks((Function)new JobCatalogListener.DeleteJobCallback(deletedJobURI, deletedJobVersion));
        }
        catch (InterruptedException e) {
            this.getLog().warn("onDeleteJob interrupted.");
        }
    }

    @Override
    public synchronized void onUpdateJob(JobSpec updatedJob) {
        Preconditions.checkNotNull((Object)updatedJob);
        try {
            this._disp.execCallbacks((Function)new JobCatalogListener.UpdateJobCallback(updatedJob));
        }
        catch (InterruptedException e) {
            this.getLog().warn("onUpdateJob interrupted.");
        }
    }

    @Override
    public void close() throws IOException {
        this._disp.close();
    }

    public void callbackOneListener(Function<JobCatalogListener, Void> callback, JobCatalogListener listener) {
        try {
            this._disp.execCallbacks(callback, (Object)listener);
        }
        catch (InterruptedException e) {
            this.getLog().warn("callback interrupted: " + callback);
        }
    }

    @Override
    public void registerWeakJobCatalogListener(JobCatalogListener jobListener) {
        this._disp.addWeakListener((Object)jobListener);
    }
}

