/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.plugins.email;

import com.typesafe.config.Config;
import java.net.URI;
import org.apache.commons.mail.EmailException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.api.GobblinInstanceDriver;
import org.apache.gobblin.runtime.api.GobblinInstancePlugin;
import org.apache.gobblin.runtime.api.GobblinInstancePluginFactory;
import org.apache.gobblin.runtime.api.JobExecutionDriver;
import org.apache.gobblin.runtime.api.JobExecutionState;
import org.apache.gobblin.runtime.api.JobLifecycleListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.runtime.instance.plugin.BaseIdlePluginImpl;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.EmailUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotificationPlugin
extends BaseIdlePluginImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailNotificationPlugin.class);
    public static final String EMAIL_NOTIFICATIONS_DISABLED_KEY = "gobblin.instance.emailNotifications.disabled";
    public static final boolean EMAIL_NOTIFICATIONS_DISABLED_DEFAULT = false;

    public EmailNotificationPlugin(GobblinInstanceDriver instance) {
        super(instance);
    }

    protected void startUp() throws Exception {
        this.instance.registerJobLifecycleListener(new EmailNotificationListerner());
        LOGGER.info("Started Email Notification Plugin");
    }

    private static class EmailNotificationListerner
    implements JobLifecycleListener {
        private EmailNotificationListerner() {
        }

        @Override
        public void onStatusChange(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
            if (newStatus.isDone() && !previousStatus.isDone()) {
                boolean alertEmailEnabled = ConfigUtils.getBoolean((Config)state.getJobSpec().getConfig(), (String)"email.alert.enabled", (boolean)false);
                boolean notificationEmailEnabled = ConfigUtils.getBoolean((Config)state.getJobSpec().getConfig(), (String)"email.notification.enabled", (boolean)false);
                if (alertEmailEnabled && newStatus.isFailure()) {
                    try {
                        LOGGER.info("Sending job failure email for job: {}", (Object)state.getJobSpec().toShortString());
                        EmailUtils.sendJobFailureAlertEmail((String)state.getJobSpec().toShortString(), (String)EmailNotificationListerner.getEmailBody(state, previousStatus, newStatus), (int)1, (State)ConfigUtils.configToState((Config)state.getJobSpec().getConfig()));
                    }
                    catch (EmailException ee) {
                        LOGGER.error("Failed to send job failure alert email for job " + state.getJobSpec().toShortString(), (Throwable)ee);
                    }
                    return;
                }
                if (notificationEmailEnabled && (newStatus.isCancelled() || newStatus.isSuccess())) {
                    try {
                        LOGGER.info("Sending job completion email for job: {}", (Object)state.getJobSpec().toShortString());
                        EmailUtils.sendJobCompletionEmail((String)state.getJobSpec().toShortString(), (String)EmailNotificationListerner.getEmailBody(state, previousStatus, newStatus), (String)newStatus.toString(), (State)ConfigUtils.configToState((Config)state.getJobSpec().getConfig()));
                    }
                    catch (EmailException ee) {
                        LOGGER.error("Failed to send job completion notification email for job " + state.getJobSpec().toShortString(), (Throwable)ee);
                    }
                }
            }
        }

        private static String getEmailBody(JobExecutionState state, JobState.RunningState previousStatus, JobState.RunningState newStatus) {
            return "JobId: " + state.getJobSpec().getConfig().getString("job.id") + "RunningState: " + newStatus.toString() + "\n" + "JobExecutionState: " + state.getJobSpec().toLongString() + "\n" + "ExecutionMetadata: " + state.getExecutionMetadata();
        }

        @Override
        public void onAddJob(JobSpec addedJob) {
        }

        @Override
        public void onDeleteJob(URI deletedJobURI, String deletedJobVersion) {
        }

        @Override
        public void onUpdateJob(JobSpec updatedJob) {
        }

        @Override
        public void onJobScheduled(JobSpecSchedule jobSchedule) {
        }

        @Override
        public void onJobUnscheduled(JobSpecSchedule jobSchedule) {
        }

        @Override
        public void onJobTriggered(JobSpec jobSpec) {
        }

        @Override
        public void onStageTransition(JobExecutionState state, String previousStage, String newStage) {
        }

        @Override
        public void onMetadataChange(JobExecutionState state, String key, Object oldValue, Object newValue) {
        }

        @Override
        public void onJobLaunch(JobExecutionDriver jobDriver) {
        }
    }

    public static class Factory
    implements GobblinInstancePluginFactory {
        @Override
        public GobblinInstancePlugin createPlugin(GobblinInstanceDriver instance) {
            return new EmailNotificationPlugin(instance);
        }
    }
}

