/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.scheduler;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.runtime.api.JobSpecScheduler;
import org.apache.gobblin.runtime.api.JobSpecSchedulerListener;
import org.apache.gobblin.runtime.scheduler.JobSpecSchedulerListeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobSpecScheduler
extends AbstractIdleService
implements JobSpecScheduler {
    protected final Map<URI, JobSpecSchedule> _schedules = new HashMap<URI, JobSpecSchedule>();
    private final Logger _log;
    private final JobSpecSchedulerListeners _callbacksDispatcher;

    public AbstractJobSpecScheduler(Optional<Logger> log) {
        this._log = (Logger)log.or((Object)LoggerFactory.getLogger(this.getClass()));
        this._callbacksDispatcher = new JobSpecSchedulerListeners(this._log);
    }

    @Override
    public void registerJobSpecSchedulerListener(JobSpecSchedulerListener listener) {
        this._callbacksDispatcher.registerJobSpecSchedulerListener(listener);
    }

    @Override
    public void registerWeakJobSpecSchedulerListener(JobSpecSchedulerListener listener) {
        this._callbacksDispatcher.registerWeakJobSpecSchedulerListener(listener);
    }

    @Override
    public void unregisterJobSpecSchedulerListener(JobSpecSchedulerListener listener) {
        this._callbacksDispatcher.unregisterJobSpecSchedulerListener(listener);
    }

    @Override
    public List<JobSpecSchedulerListener> getJobSpecSchedulerListeners() {
        return this._callbacksDispatcher.getJobSpecSchedulerListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobSpecSchedule scheduleJob(JobSpec jobSpec, Runnable jobRunnable) {
        this._log.info("Scheduling JobSpec " + jobSpec);
        URI jobSpecURI = jobSpec.getUri();
        JobSpecSchedule newSchedule = null;
        TriggerRunnable runnableWithTriggerCallback = new TriggerRunnable(jobSpec, jobRunnable);
        AbstractJobSpecScheduler abstractJobSpecScheduler = this;
        synchronized (abstractJobSpecScheduler) {
            JobSpecSchedule existingSchedule = this._schedules.get(jobSpecURI);
            if (null != existingSchedule) {
                if (existingSchedule.getJobSpec().equals(jobSpec)) {
                    this._log.warn("Ignoring already scheduled job: " + jobSpec);
                    return existingSchedule;
                }
                this.unscheduleJob(jobSpecURI);
            }
            newSchedule = this.doScheduleJob(jobSpec, runnableWithTriggerCallback);
            this._schedules.put(jobSpecURI, newSchedule);
        }
        this._callbacksDispatcher.onJobScheduled(newSchedule);
        return newSchedule;
    }

    @Override
    public JobSpecSchedule scheduleOnce(JobSpec jobSpec, Runnable jobRunnable) {
        this._log.info("Scheduling once JobSpec " + jobSpec);
        RunOnceRunnable runOnceRunnable = new RunOnceRunnable(jobSpec.getUri(), jobRunnable);
        return this.scheduleJob(jobSpec, runOnceRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unscheduleJob(URI jobSpecURI) {
        JobSpecSchedule existingSchedule = null;
        AbstractJobSpecScheduler abstractJobSpecScheduler = this;
        synchronized (abstractJobSpecScheduler) {
            existingSchedule = this._schedules.get(jobSpecURI);
            if (null != existingSchedule) {
                this._log.info("Unscheduling " + existingSchedule);
                this._schedules.remove(jobSpecURI);
                this.doUnschedule(existingSchedule);
            }
        }
        if (null != existingSchedule) {
            this._callbacksDispatcher.onJobUnscheduled(existingSchedule);
        }
    }

    protected abstract JobSpecSchedule doScheduleJob(JobSpec var1, Runnable var2);

    protected abstract void doUnschedule(JobSpecSchedule var1);

    @Override
    public Map<URI, JobSpecSchedule> getSchedules() {
        return Collections.unmodifiableMap(this._schedules);
    }

    public Logger getLog() {
        return this._log;
    }

    protected void startUp() throws TimeoutException {
    }

    protected void shutDown() throws TimeoutException {
        try {
            this._callbacksDispatcher.close();
        }
        catch (IOException ioe) {
            this._log.error("Failed to shut down " + this.getClass().getName(), (Throwable)ioe);
        }
    }

    protected class TriggerRunnable
    implements Runnable {
        private final JobSpec _jobSpec;
        private final Runnable _jobRunnable;

        public TriggerRunnable(JobSpec jobSpec, Runnable jobRunnable) {
            this._jobSpec = jobSpec;
            this._jobRunnable = jobRunnable;
        }

        @Override
        public void run() {
            AbstractJobSpecScheduler.this._callbacksDispatcher.onJobTriggered(this._jobSpec);
            this._jobRunnable.run();
        }
    }

    public class RunOnceRunnable
    implements Runnable {
        private final URI _jobSpecURI;
        private final Runnable _scheduleRunnable;

        public RunOnceRunnable(URI jobSpecURI, Runnable innerRunnable) {
            Preconditions.checkNotNull((Object)jobSpecURI);
            Preconditions.checkNotNull((Object)innerRunnable);
            this._jobSpecURI = jobSpecURI;
            this._scheduleRunnable = innerRunnable;
        }

        @Override
        public void run() {
            try {
                this._scheduleRunnable.run();
            }
            finally {
                AbstractJobSpecScheduler.this.unscheduleJob(this._jobSpecURI);
            }
        }
    }
}

