/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.scheduler;

import com.google.common.base.Optional;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecSchedule;
import org.apache.gobblin.runtime.api.JobSpecSchedulerListener;
import org.slf4j.Logger;

public class DefaultJobSpecSchedulerListenerImpl
implements JobSpecSchedulerListener {
    protected final Optional<Logger> _log;

    public DefaultJobSpecSchedulerListenerImpl(Optional<Logger> log) {
        this._log = log;
    }

    public DefaultJobSpecSchedulerListenerImpl(Logger log) {
        this((Optional<Logger>)Optional.of((Object)log));
    }

    public DefaultJobSpecSchedulerListenerImpl() {
        this((Optional<Logger>)Optional.absent());
    }

    @Override
    public void onJobScheduled(JobSpecSchedule jobSchedule) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("Job scheduled: " + jobSchedule);
        }
    }

    @Override
    public void onJobUnscheduled(JobSpecSchedule jobSchedule) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("Job unscheduled: " + jobSchedule);
        }
    }

    @Override
    public void onJobTriggered(JobSpec jobSpec) {
        if (this._log.isPresent()) {
            ((Logger)this._log.get()).info("Job triggered: " + jobSpec);
        }
    }
}

