/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.template;

import com.google.api.client.util.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.gobblin.runtime.api.JobTemplate;
import org.apache.gobblin.runtime.api.SpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.PackagedTemplatesJobCatalogDecorator;
import org.apache.gobblin.runtime.template.ResourceBasedJobTemplate;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.PullFileLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class PullFileToConfigConverter {
    public static final String DO_NOT_OVERRIDE_KEY = "pullFileToConfigConverter.doNotOverride";
    private static final Set<String> FILTER_KEYS = ImmutableSet.of((Object)"job.config.path", (Object)"jobconf.dir", (Object)"jobconf.fullyQualifiedPath");
    private final Path pullFileRootPath;
    private final Path fileGlobToConvert;
    private final Path templateURI;
    private final File sysConfigPath;
    private final Path outputPath;

    public static void main(String[] args) throws Exception {
        if (args.length != 5) {
            System.out.println("Usage: PullFileToConfigConverter <pullFilesRootPath> <pullFilesToConvertGlob> resource:///<templatePath> <sysConfigPath> <outputDir>");
            System.exit(1);
        }
        new PullFileToConfigConverter(new Path(args[0]), new Path(args[1]), new Path(args[2]), new File(args[3]), new Path(args[4])).convert();
    }

    public void convert() throws IOException {
        Config templateConfig;
        Config baseConfig = ConfigFactory.parseString((String)"pullFileToConfigConverter.doNotOverride: []");
        FileSystem pullFileFs = this.pullFileRootPath.getFileSystem(new Configuration());
        FileSystem outputFs = this.outputPath.getFileSystem(new Configuration());
        Config sysConfig = ConfigFactory.parseFile((File)this.sysConfigPath);
        PullFileLoader pullFileLoader = new PullFileLoader(this.pullFileRootPath, pullFileFs, (Collection)PullFileLoader.DEFAULT_JAVA_PROPS_PULL_FILE_EXTENSIONS, (Collection)PullFileLoader.DEFAULT_HOCON_PULL_FILE_EXTENSIONS);
        PackagedTemplatesJobCatalogDecorator catalog = new PackagedTemplatesJobCatalogDecorator();
        ConfigResolveOptions configResolveOptions = ConfigResolveOptions.defaults();
        configResolveOptions = configResolveOptions.setAllowUnresolved(true);
        try {
            ResourceBasedJobTemplate template = (ResourceBasedJobTemplate)catalog.getTemplate(this.templateURI.toUri());
            templateConfig = sysConfig.withFallback((ConfigMergeable)template.getRawTemplateConfig()).withFallback((ConfigMergeable)baseConfig).resolve(configResolveOptions);
        }
        catch (JobTemplate.TemplateException | SpecNotFoundException exc) {
            throw new IOException(exc);
        }
        HashSet doNotOverride = templateConfig.hasPath(DO_NOT_OVERRIDE_KEY) ? Sets.newHashSet((Iterable)templateConfig.getStringList(DO_NOT_OVERRIDE_KEY)) : Sets.newHashSet();
        ConfigRenderOptions configRenderOptions = ConfigRenderOptions.defaults();
        configRenderOptions = configRenderOptions.setComments(false);
        configRenderOptions = configRenderOptions.setOriginComments(false);
        configRenderOptions = configRenderOptions.setFormatted(true);
        configRenderOptions = configRenderOptions.setJson(false);
        for (FileStatus pullFile : pullFileFs.globStatus(this.fileGlobToConvert)) {
            Config currentResolvedConfig;
            boolean somethingChanged;
            Config pullFileConfig = pullFileLoader.loadPullFile(pullFile.getPath(), ConfigFactory.empty(), true).resolve();
            HashMap outputConfigMap = Maps.newHashMap();
            outputConfigMap.put("job.template", this.templateURI.toString());
            do {
                somethingChanged = false;
                Config currentOutputConfig = ConfigFactory.parseMap((Map)outputConfigMap);
                currentResolvedConfig = currentOutputConfig.withFallback((ConfigMergeable)templateConfig).resolve(configResolveOptions);
                for (Map.Entry<Object, Object> entry : ConfigUtils.configToProperties((Config)pullFileConfig).entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    try {
                        if (currentResolvedConfig.hasPath(key) && (currentResolvedConfig.getString(key).equals(value) || doNotOverride.contains(key)) || FILTER_KEYS.contains(key)) continue;
                        somethingChanged = true;
                        outputConfigMap.put(key, value);
                    }
                    catch (ConfigException.NotResolved notResolved) {}
                }
            } while (somethingChanged);
            try {
                Config outputConfig = ConfigFactory.parseMap((Map)outputConfigMap);
                currentResolvedConfig = outputConfig.withFallback((ConfigMergeable)templateConfig).resolve();
                String rendered = outputConfig.root().render(configRenderOptions);
                Path newPath = PathUtils.removeExtension((Path)pullFile.getPath(), (String[])PullFileLoader.DEFAULT_JAVA_PROPS_PULL_FILE_EXTENSIONS.toArray(new String[0]));
                newPath = PathUtils.addExtension((Path)newPath, (String[])new String[]{"conf"});
                newPath = new Path(this.outputPath, newPath.getName());
                FSDataOutputStream os = outputFs.create(newPath);
                os.write(rendered.getBytes(Charsets.UTF_8));
                os.close();
            }
            catch (ConfigException.NotResolved nre) {
                throw new IOException("Not all configuration keys were resolved in pull file " + pullFile.getPath(), nre);
            }
        }
    }

    @ConstructorProperties(value={"pullFileRootPath", "fileGlobToConvert", "templateURI", "sysConfigPath", "outputPath"})
    public PullFileToConfigConverter(Path pullFileRootPath, Path fileGlobToConvert, Path templateURI, File sysConfigPath, Path outputPath) {
        this.pullFileRootPath = pullFileRootPath;
        this.fileGlobToConvert = fileGlobToConvert;
        this.templateURI = templateURI;
        this.sysConfigPath = sysConfigPath;
        this.outputPath = outputPath;
    }

    public Path getPullFileRootPath() {
        return this.pullFileRootPath;
    }

    public Path getFileGlobToConvert() {
        return this.fileGlobToConvert;
    }

    public Path getTemplateURI() {
        return this.templateURI;
    }

    public File getSysConfigPath() {
        return this.sysConfigPath;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PullFileToConfigConverter)) {
            return false;
        }
        PullFileToConfigConverter other = (PullFileToConfigConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$pullFileRootPath = this.getPullFileRootPath();
        Path other$pullFileRootPath = other.getPullFileRootPath();
        if (this$pullFileRootPath == null ? other$pullFileRootPath != null : !this$pullFileRootPath.equals(other$pullFileRootPath)) {
            return false;
        }
        Path this$fileGlobToConvert = this.getFileGlobToConvert();
        Path other$fileGlobToConvert = other.getFileGlobToConvert();
        if (this$fileGlobToConvert == null ? other$fileGlobToConvert != null : !this$fileGlobToConvert.equals(other$fileGlobToConvert)) {
            return false;
        }
        Path this$templateURI = this.getTemplateURI();
        Path other$templateURI = other.getTemplateURI();
        if (this$templateURI == null ? other$templateURI != null : !this$templateURI.equals(other$templateURI)) {
            return false;
        }
        File this$sysConfigPath = this.getSysConfigPath();
        File other$sysConfigPath = other.getSysConfigPath();
        if (this$sysConfigPath == null ? other$sysConfigPath != null : !((Object)this$sysConfigPath).equals(other$sysConfigPath)) {
            return false;
        }
        Path this$outputPath = this.getOutputPath();
        Path other$outputPath = other.getOutputPath();
        return !(this$outputPath == null ? other$outputPath != null : !this$outputPath.equals(other$outputPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PullFileToConfigConverter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $pullFileRootPath = this.getPullFileRootPath();
        result = result * 59 + ($pullFileRootPath == null ? 43 : $pullFileRootPath.hashCode());
        Path $fileGlobToConvert = this.getFileGlobToConvert();
        result = result * 59 + ($fileGlobToConvert == null ? 43 : $fileGlobToConvert.hashCode());
        Path $templateURI = this.getTemplateURI();
        result = result * 59 + ($templateURI == null ? 43 : $templateURI.hashCode());
        File $sysConfigPath = this.getSysConfigPath();
        result = result * 59 + ($sysConfigPath == null ? 43 : ((Object)$sysConfigPath).hashCode());
        Path $outputPath = this.getOutputPath();
        result = result * 59 + ($outputPath == null ? 43 : $outputPath.hashCode());
        return result;
    }

    public String toString() {
        return "PullFileToConfigConverter(pullFileRootPath=" + this.getPullFileRootPath() + ", fileGlobToConvert=" + this.getFileGlobToConvert() + ", templateURI=" + this.getTemplateURI() + ", sysConfigPath=" + this.getSysConfigPath() + ", outputPath=" + this.getOutputPath() + ")";
    }
}

