/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.common.util.MapUtil;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.util.degrader.DegraderImpl;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderConfigFactory {
    private static final Logger _log = LoggerFactory.getLogger(DegraderConfigFactory.class);

    public static DegraderImpl.Config toDegraderConfig(Map<String, String> properties) {
        DegraderImpl.Config config = new DegraderImpl.Config();
        if (properties == null || properties.isEmpty()) {
            return config;
        }
        config.setLogEnabled((Boolean)MapUtil.getWithDefault(properties, (Object)"degrader.logEnabled", (Object)DegraderImpl.DEFAULT_LOG_ENABLED));
        if (properties.get("degrader.latencyToUse") != null) {
            try {
                config.setLatencyToUse(DegraderImpl.LatencyToUse.valueOf((String)properties.get("degrader.latencyToUse")));
            }
            catch (IllegalArgumentException e) {
                LogUtil.warn(_log, "Received an illegal enum for latencyToUse in the cluster properties. The enum is " + properties.get("degrader.latencyToUse"), e);
                config.setLatencyToUse(DegraderImpl.DEFAULT_LATENCY_TO_USE);
            }
        }
        config.setMaxDropRate((Double)MapUtil.getWithDefault(properties, (Object)"degrader.maxDropRate", (Object)DegraderImpl.DEFAULT_MAX_DROP_RATE));
        config.setMaxDropDuration(((Long)MapUtil.getWithDefault(properties, (Object)"degrader.maxDropDuration", (Object)DegraderImpl.DEFAULT_MAX_DROP_DURATION)).longValue());
        config.setUpStep((Double)MapUtil.getWithDefault(properties, (Object)"degrader.upStep", (Object)DegraderImpl.DEFAULT_UP_STEP));
        config.setDownStep((Double)MapUtil.getWithDefault(properties, (Object)"degrader.downStep", (Object)DegraderImpl.DEFAULT_DOWN_STEP));
        config.setMinCallCount((Integer)MapUtil.getWithDefault(properties, (Object)"degrader.minCallCount", (Object)DegraderImpl.DEFAULT_MIN_CALL_COUNT));
        config.setHighLatency(((Long)MapUtil.getWithDefault(properties, (Object)"degrader.highLatency", (Object)DegraderImpl.DEFAULT_HIGH_LATENCY)).longValue());
        config.setLowLatency(((Long)MapUtil.getWithDefault(properties, (Object)"degrader.lowLatency", (Object)DegraderImpl.DEFAULT_LOW_LATENCY)).longValue());
        config.setHighErrorRate((Double)MapUtil.getWithDefault(properties, (Object)"degrader.highErrorRate", (Object)DegraderImpl.DEFAULT_HIGH_ERROR_RATE));
        config.setLowErrorRate((Double)MapUtil.getWithDefault(properties, (Object)"degrader.lowErrorRate", (Object)DegraderImpl.DEFAULT_LOW_ERROR_RATE));
        config.setHighOutstanding(((Long)MapUtil.getWithDefault(properties, (Object)"degrader.highOutstanding", (Object)DegraderImpl.DEFAULT_HIGH_OUTSTANDING)).longValue());
        config.setLowOutstanding(((Long)MapUtil.getWithDefault(properties, (Object)"degrader.lowOutstanding", (Object)DegraderImpl.DEFAULT_LOW_OUTSTANDING)).longValue());
        config.setMinOutstandingCount((Integer)MapUtil.getWithDefault(properties, (Object)"degrader.minOutstandingCount", (Object)DegraderImpl.DEFAULT_MIN_OUTSTANDING_COUNT));
        config.setOverrideMinCallCount((Integer)MapUtil.getWithDefault(properties, (Object)"degrader.overrideMinCallCount", (Object)DegraderImpl.DEFAULT_OVERRIDE_MIN_CALL_COUNT));
        config.setInitialDropRate(((Double)MapUtil.getWithDefault(properties, (Object)"degrader.initialDropRate", (Object)0.0)).doubleValue());
        config.setSlowStartThreshold(((Double)MapUtil.getWithDefault(properties, (Object)"degrader.slowStartThreshold", (Object)0.0)).doubleValue());
        return config;
    }
}

