/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerQuarantine;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.strategies.degrader.DegraderRingFactory;
import com.linkedin.d2.balancer.strategies.degrader.RingFactory;
import com.linkedin.d2.balancer.strategies.degrader.TrackerClientUpdater;
import com.linkedin.d2.balancer.util.RateLimitedLogger;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.RandomHash;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.hashing.URIRegexHash;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheck;
import com.linkedin.d2.balancer.util.healthcheck.HealthCheckClientBuilder;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.util.degrader.DegraderControl;
import com.linkedin.util.degrader.DegraderImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyV3
implements LoadBalancerStrategy {
    public static final String HASH_METHOD_NONE = "none";
    public static final String HASH_METHOD_URI_REGEX = "uriRegex";
    public static final double EPSILON = 1.0E-5;
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerStrategyV3.class);
    private static final int MAX_HOSTS_TO_CHECK_QUARANTINE = 10;
    private static final int MAX_RETRIES_TO_CHECK_QUARANTINE = 5;
    private boolean _updateEnabled = true;
    private volatile DegraderLoadBalancerStrategyConfig _config;
    private volatile HashFunction<Request> _hashFunction;
    private final DegraderLoadBalancerState _state;
    private final RateLimitedLogger _rateLimitedLogger;

    public DegraderLoadBalancerStrategyV3(DegraderLoadBalancerStrategyConfig config, String serviceName, Map<String, String> degraderProperties) {
        this.setConfig(config);
        if (degraderProperties == null) {
            degraderProperties = Collections.emptyMap();
        }
        this._state = new DegraderLoadBalancerState(serviceName, degraderProperties, config);
        this._rateLimitedLogger = new RateLimitedLogger(_log, 5000L, config.getClock());
    }

    @Override
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        boolean dropCall;
        TrackerClient client;
        LogUtil.debug(_log, "getTrackerClient with generation id ", clusterGenerationId, " partition id: ", partitionId, " on tracker clients: ", trackerClients);
        if (trackerClients == null || trackerClients.size() == 0) {
            LogUtil.warn(_log, "getTrackerClient called with null/empty trackerClients, so returning null");
            return null;
        }
        this.checkUpdatePartitionState(clusterGenerationId, partitionId, trackerClients);
        Ring ring = this._state.getRing(partitionId);
        URI targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        Set<URI> excludedUris = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext);
        if (excludedUris == null) {
            excludedUris = new HashSet<URI>();
        }
        if (targetHostUri == null) {
            client = this.findValidClientFromRing(request, ring, trackerClients, excludedUris, requestContext);
        } else {
            LogUtil.debug(_log, "Degrader honoring target host header in request, skipping hashing.  URI: ", targetHostUri);
            client = this.searchClientFromUri(targetHostUri, trackerClients);
            if (client == null) {
                LogUtil.warn(_log, "No client found for ", targetHostUri, ". Target host specified is no longer part of cluster");
            }
        }
        boolean bl = dropCall = client == null;
        if (!dropCall) {
            dropCall = client.getDegrader(partitionId).checkDrop();
            if (dropCall) {
                LogUtil.warn(_log, "client's degrader is dropping call for: ", client);
            } else {
                LogUtil.debug(_log, "returning client: ", client);
            }
        }
        return !dropCall ? client : null;
    }

    private TrackerClient findValidClientFromRing(Request request, Ring<URI> ring, List<TrackerClient> trackerClients, Set<URI> excludedUris, RequestContext requestContext) {
        int hashCode = this._hashFunction.hash(request);
        if (ring == null) {
            LogUtil.warn(_log, "Can not find hash ring to use");
        }
        URI targetHostUri = ring.get(hashCode);
        Iterator<URI> iterator = ring.getIterator(hashCode);
        TrackerClient client = null;
        while ((excludedUris.contains(targetHostUri) || (client = this.searchClientFromUri(targetHostUri, trackerClients)) == null) && iterator.hasNext()) {
            targetHostUri = iterator.next();
        }
        if (client == null) {
            LogUtil.warn(_log, "No client found. Degrader load balancer state is inconsistent with cluster manager");
        } else if (excludedUris.contains(targetHostUri)) {
            client = null;
            LogUtil.warn(_log, "No client found. We have tried all hosts in the cluster");
        } else {
            LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, targetHostUri);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkUpdatePartitionState(long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        DegraderLoadBalancerStrategyConfig config = this.getConfig();
        Partition partition = this._state.getPartition(partitionId);
        Lock lock = partition.getLock();
        if (!partition.getState().isInitialized()) {
            lock.lock();
            try {
                if (partition.getState().isInitialized()) return;
                LogUtil.debug(_log, "initializing partition state for partition: ", partitionId);
                this.updatePartitionState(clusterGenerationId, partition, trackerClients, config);
                if (partition.getState().isInitialized()) return;
                _log.error("Failed to initialize partition state for patition: ", (Object)partitionId);
                return;
            }
            finally {
                lock.unlock();
            }
        }
        if (!DegraderLoadBalancerStrategyV3.shouldUpdatePartition(clusterGenerationId, partition.getState(), config, this._updateEnabled) || !lock.tryLock()) return;
        try {
            if (!DegraderLoadBalancerStrategyV3.shouldUpdatePartition(clusterGenerationId, partition.getState(), config, this._updateEnabled)) return;
            LogUtil.debug(_log, "updating for cluster generation id: ", clusterGenerationId, ", partitionId: ", partitionId);
            LogUtil.debug(_log, "old state was: ", partition.getState());
            this.updatePartitionState(clusterGenerationId, partition, trackerClients, config);
            return;
        }
        finally {
            lock.unlock();
        }
    }

    private TrackerClient searchClientFromUri(URI uri, List<TrackerClient> trackerClients) {
        for (TrackerClient trackerClient : trackerClients) {
            if (!trackerClient.getUri().equals(uri)) continue;
            return trackerClient;
        }
        return null;
    }

    private void updatePartitionState(long clusterGenerationId, Partition partition, List<TrackerClient> trackerClients, DegraderLoadBalancerStrategyConfig config) {
        PartitionDegraderLoadBalancerState partitionState = partition.getState();
        ArrayList<TrackerClientUpdater> clientUpdaters = new ArrayList<TrackerClientUpdater>();
        for (TrackerClient client : trackerClients) {
            clientUpdaters.add(new TrackerClientUpdater(client, partition.getId()));
        }
        boolean quarantineEnabled = this._state._enableQuarantine.get();
        if (config.getQuarantineMaxPercent() > 0.0 && !quarantineEnabled && this._state._retryTimesForQuarantine.incrementAndGet() <= 5) {
            this._config.getExecutorService().submit(() -> this.checkQuarantineState(clientUpdaters, config));
        }
        partitionState = DegraderLoadBalancerStrategyV3.doUpdatePartitionState(clusterGenerationId, partition.getId(), partitionState, config, clientUpdaters, quarantineEnabled);
        partition.setState(partitionState);
        for (TrackerClientUpdater clientUpdater : clientUpdaters) {
            clientUpdater.update();
        }
    }

    static boolean isNewStateHealthy(PartitionDegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<TrackerClientUpdater> trackerClientUpdaters, int partitionId) {
        if (newState.getCurrentAvgClusterLatency() > config.getLowWaterMark()) {
            return false;
        }
        Map<URI, Integer> pointsMap = newState.getPointsMap();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            int perfectHealth = (int)(client.getPartitionWeight(partitionId) * (double)config.getPointsPerWeight());
            Integer point = pointsMap.get(client.getUri());
            if (point >= perfectHealth) continue;
            return false;
        }
        return true;
    }

    static boolean isOldStateTheSameAsNewState(PartitionDegraderLoadBalancerState oldState, PartitionDegraderLoadBalancerState newState) {
        return oldState.getCurrentOverrideDropRate() == newState.getCurrentOverrideDropRate() && oldState.getPointsMap().equals(newState.getPointsMap()) && oldState.getRecoveryMap().equals(newState.getRecoveryMap()) && oldState.getQuarantineMap().equals(newState.getQuarantineMap());
    }

    private static void logState(PartitionDegraderLoadBalancerState oldState, PartitionDegraderLoadBalancerState newState, int partitionId, DegraderLoadBalancerStrategyConfig config, List<TrackerClientUpdater> trackerClientUpdaters) {
        if (_log.isDebugEnabled()) {
            _log.debug("Strategy updated: partitionId= " + partitionId + ", newState=" + newState + ", unhealthyClients = " + DegraderLoadBalancerStrategyV3.getUnhealthyTrackerClients(trackerClientUpdaters, newState._pointsMap, config, partitionId) + ", config=" + config + ", HashRing coverage=" + newState.getRing());
        } else if (!DegraderLoadBalancerStrategyV3.isNewStateHealthy(newState, config, trackerClientUpdaters, partitionId) || !DegraderLoadBalancerStrategyV3.isOldStateTheSameAsNewState(oldState, newState)) {
            _log.info("Strategy updated: partitionId= " + partitionId + ", newState=" + newState + ", unhealthyClients = " + DegraderLoadBalancerStrategyV3.getUnhealthyTrackerClients(trackerClientUpdaters, newState._pointsMap, config, partitionId) + ", oldState =" + oldState + ", new state's config=" + config);
        }
    }

    private static List<String> getUnhealthyTrackerClients(List<TrackerClientUpdater> trackerClientUpdaters, Map<URI, Integer> pointsMap, DegraderLoadBalancerStrategyConfig config, int partitionId) {
        ArrayList<String> unhealthyClients = new ArrayList<String>();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            int perfectHealth = (int)(client.getPartitionWeight(partitionId) * (double)config.getPointsPerWeight());
            Integer point = pointsMap.get(client.getUri());
            if (point >= perfectHealth) continue;
            unhealthyClients.add(client.getUri() + ":" + point + "/" + perfectHealth);
        }
        return unhealthyClients;
    }

    private static PartitionDegraderLoadBalancerState doUpdatePartitionState(long clusterGenerationId, int partitionId, PartitionDegraderLoadBalancerState oldState, DegraderLoadBalancerStrategyConfig config, List<TrackerClientUpdater> trackerClientUpdaters, boolean isQuarantineEnabled) {
        PartitionDegraderLoadBalancerState newState;
        LogUtil.debug(_log, "updating state for: ", trackerClientUpdaters);
        double sumOfClusterLatencies = 0.0;
        long totalClusterCallCount = 0L;
        boolean hashRingChanges = false;
        boolean recoveryMapChanges = false;
        boolean quarantineMapChanged = false;
        PartitionDegraderLoadBalancerState.Strategy strategy = oldState.getStrategy();
        Map<TrackerClient, Double> oldRecoveryMap = oldState.getRecoveryMap();
        HashMap<TrackerClient, Double> newRecoveryMap = new HashMap<TrackerClient, Double>(oldRecoveryMap);
        double currentOverrideDropRate = oldState.getCurrentOverrideDropRate();
        double initialRecoveryLevel = config.getInitialRecoveryLevel();
        double ringRampFactor = config.getRingRampFactor();
        int pointsPerWeight = config.getPointsPerWeight();
        Map<TrackerClient, DegraderLoadBalancerQuarantine> quarantineMap = oldState.getQuarantineMap();
        Map<TrackerClient, DegraderLoadBalancerQuarantine> quarantineHistory = oldState.getQuarantineHistory();
        HashSet<TrackerClient> activeClients = new HashSet<TrackerClient>();
        long clk = config.getClock().currentTimeMillis();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            double averageLatency = degraderControl.getLatency();
            long callCount = degraderControl.getCallCount();
            oldState.getPreviousMaxDropRate().put(client, clientUpdater.getMaxDropRate());
            sumOfClusterLatencies += averageLatency * (double)callCount;
            totalClusterCallCount += callCount;
            boolean recoveryMapContainsClient = newRecoveryMap.containsKey(client);
            if (isQuarantineEnabled) {
                activeClients.add(client);
                DegraderLoadBalancerQuarantine quarantine = quarantineMap.get(client);
                if (quarantine != null && quarantine.checkUpdateQuarantineState()) {
                    quarantineMap.remove(client);
                    quarantineHistory.put(client, quarantine);
                    _log.info("TrackerClient {} evicted from quarantine @ {}", (Object)client.getUri(), (Object)clk);
                    newRecoveryMap.put(client, degraderControl.getMaxDropRate());
                    clientUpdater.setMaxDropRate(1.0 - initialRecoveryLevel);
                    quarantineMapChanged = true;
                }
            }
            if (!recoveryMapContainsClient) continue;
            if (callCount == 0L) {
                double oldMaxDropRate = clientUpdater.getMaxDropRate();
                double transmissionRate = 1.0 - oldMaxDropRate;
                if (transmissionRate <= 0.0) {
                    transmissionRate = initialRecoveryLevel;
                } else {
                    transmissionRate *= ringRampFactor;
                    transmissionRate = Math.min(transmissionRate, 1.0);
                }
                double newMaxDropRate = 1.0 - transmissionRate;
                if (strategy == PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE) {
                    clientUpdater.setMaxDropRate(newMaxDropRate);
                }
                recoveryMapChanges = true;
                continue;
            }
            clientUpdater.setMaxDropRate((Double)newRecoveryMap.get(client));
            newRecoveryMap.remove(client);
            recoveryMapChanges = true;
        }
        if (isQuarantineEnabled) {
            quarantineMap.entrySet().removeIf(e -> !activeClients.contains(e.getKey()));
            quarantineHistory.entrySet().removeIf(e -> !activeClients.contains(e.getKey()));
        }
        if (oldState.getClusterGenerationId() == clusterGenerationId && totalClusterCallCount <= 0L && !recoveryMapChanges && !quarantineMapChanged) {
            LogUtil.debug(_log, "New state is the same as the old state so we're not changing anything. Old state = ", oldState, ", config= ", config);
            return new PartitionDegraderLoadBalancerState(oldState, clusterGenerationId, config.getClock().currentTimeMillis());
        }
        double newCurrentAvgClusterLatency = -1.0;
        if (totalClusterCallCount > 0L) {
            newCurrentAvgClusterLatency = sumOfClusterLatencies / (double)totalClusterCallCount;
        }
        LogUtil.debug(_log, "average cluster latency: ", newCurrentAvgClusterLatency);
        Map<URI, Integer> points = new HashMap<URI, Integer>();
        Map<URI, Integer> oldPointsMap = oldState.getPointsMap();
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            URI clientUri = client.getUri();
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            double dropRate = Math.min(degraderControl.getCurrentComputedDropRate(), clientUpdater.getMaxDropRate());
            double clientWeight = client.getPartitionWeight(partitionId);
            double successfulTransmissionWeight = clientWeight * (1.0 - dropRate);
            LogUtil.debug(_log, "computed new weight for uri ", clientUri, ": ", successfulTransmissionWeight);
            int newPoints = (int)(successfulTransmissionWeight * (double)pointsPerWeight);
            boolean quarantineEffect = false;
            if (isQuarantineEnabled) {
                if (quarantineMap.containsKey(client)) {
                    newPoints = 0;
                    quarantineEffect = true;
                } else if (successfulTransmissionWeight <= 0.0 && clientWeight > 1.0E-5 && degraderControl.isHigh()) {
                    if (1.0 * (double)quarantineMap.size() < Math.ceil((double)trackerClientUpdaters.size() * config.getQuarantineMaxPercent())) {
                        DegraderLoadBalancerQuarantine quarantine = quarantineHistory.remove(client);
                        if (quarantine == null) {
                            quarantine = new DegraderLoadBalancerQuarantine(clientUpdater, config, oldState.getServiceName());
                        }
                        quarantine.reset(clk - quarantine.getLastChecked() > 30000L);
                        quarantineMap.put(client, quarantine);
                        newPoints = 0;
                        _log.warn("TrackerClient {} is put into quarantine {}. OverrideDropRate = {}, callCount = {}, latency = {}, errorRate = {}", new Object[]{client.getUri(), quarantine, degraderControl.getMaxDropRate(), degraderControl.getCallCount(), degraderControl.getLatency(), degraderControl.getErrorRate()});
                        quarantineEffect = true;
                    } else {
                        _log.error("Quarantine for service {} is full! Could not add {}", (Object)oldState.getServiceName(), (Object)client);
                    }
                }
            }
            if (!quarantineEffect && newPoints == 0 && clientWeight > 1.0E-5) {
                Double oldMaxDropRate = clientUpdater.getMaxDropRate();
                newPoints = (int)(initialRecoveryLevel * (double)pointsPerWeight);
                if (!newRecoveryMap.containsKey(client)) {
                    newRecoveryMap.put(client, oldMaxDropRate);
                    clientUpdater.setMaxDropRate(1.0 - initialRecoveryLevel);
                }
            }
            points.put(clientUri, newPoints);
            if (oldPointsMap.containsKey(clientUri) && oldPointsMap.get(clientUri) == newPoints) continue;
            hashRingChanges = true;
        }
        if (strategy == PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE && hashRingChanges || oldState.getClusterGenerationId() != clusterGenerationId) {
            newState = new PartitionDegraderLoadBalancerState(clusterGenerationId, config.getClock().currentTimeMillis(), true, oldState.getRingFactory(), points, PartitionDegraderLoadBalancerState.Strategy.CALL_DROPPING, currentOverrideDropRate, newCurrentAvgClusterLatency, newRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount, quarantineMap, quarantineHistory);
            DegraderLoadBalancerStrategyV3.logState(oldState, newState, partitionId, config, trackerClientUpdaters);
        } else {
            double newDropLevel = Math.max(0.0, currentOverrideDropRate);
            if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountHighWaterMark()) {
                if (newCurrentAvgClusterLatency >= config.getHighWaterMark() && currentOverrideDropRate != 1.0) {
                    newDropLevel = Math.min(1.0, newDropLevel + config.getGlobalStepUp());
                } else if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                    newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
                }
            } else if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountLowWaterMark()) {
                if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                    newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
                }
            } else {
                newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
            }
            if (newDropLevel != currentOverrideDropRate) {
                DegraderLoadBalancerStrategyV3.overrideClusterDropRate(partitionId, newDropLevel, trackerClientUpdaters);
            }
            newState = new PartitionDegraderLoadBalancerState(clusterGenerationId, config.getClock().currentTimeMillis(), true, oldState.getRingFactory(), oldPointsMap, PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE, newDropLevel, newCurrentAvgClusterLatency, isQuarantineEnabled ? newRecoveryMap : oldRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount, quarantineMap, quarantineHistory);
            DegraderLoadBalancerStrategyV3.logState(oldState, newState, partitionId, config, trackerClientUpdaters);
            points = oldPointsMap;
        }
        DegraderLoadBalancerStrategyV3.overrideMinCallCount(partitionId, currentOverrideDropRate, trackerClientUpdaters, points, pointsPerWeight);
        return newState;
    }

    public static void overrideClusterDropRate(int partitionId, double override, List<TrackerClientUpdater> trackerClientUpdaters) {
        LogUtil.debug(_log, "partitionId=", partitionId, "overriding degrader drop rate to ", override, " for clients: ", trackerClientUpdaters);
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            clientUpdater.setOverrideDropRate(override);
        }
    }

    public static void overrideMinCallCount(int partitionId, double newOverrideDropRate, List<TrackerClientUpdater> trackerClientUpdaters, Map<URI, Integer> pointsMap, int pointsPerWeight) {
        for (TrackerClientUpdater clientUpdater : trackerClientUpdaters) {
            TrackerClient client = clientUpdater.getTrackerClient();
            DegraderControl degraderControl = client.getDegraderControl(partitionId);
            int currentOverrideMinCallCount = client.getDegraderControl(partitionId).getOverrideMinCallCount();
            double hashFactor = pointsMap.get(client.getUri()) / pointsPerWeight;
            double transmitFactor = 1.0 - newOverrideDropRate;
            int newOverrideMinCallCount = (int)Math.max(Math.round((double)degraderControl.getMinCallCount() * hashFactor * transmitFactor), 1L);
            if (newOverrideMinCallCount == currentOverrideMinCallCount) continue;
            clientUpdater.setOverrideMinCallCount(newOverrideMinCallCount);
            if (currentOverrideMinCallCount == DegraderImpl.DEFAULT_OVERRIDE_MIN_CALL_COUNT) continue;
            LogUtil.warn(_log, "partitionId=", partitionId, "overriding Min Call Count to ", newOverrideMinCallCount, " for client: ", client.getUri());
        }
    }

    protected static boolean shouldUpdatePartition(long clusterGenerationId, PartitionDegraderLoadBalancerState partitionState, DegraderLoadBalancerStrategyConfig config, boolean updateEnabled) {
        return updateEnabled && (!config.isUpdateOnlyAtInterval() && partitionState.getClusterGenerationId() != clusterGenerationId || config.getClock().currentTimeMillis() - partitionState.getLastUpdated() >= config.getUpdateIntervalMs());
    }

    public DegraderLoadBalancerState getState() {
        return this._state;
    }

    public DegraderLoadBalancerStrategyConfig getConfig() {
        return this._config;
    }

    public void setConfig(DegraderLoadBalancerStrategyConfig config) {
        this._config = config;
        String hashMethod = this._config.getHashMethod();
        Map<String, Object> hashConfig = this._config.getHashConfig();
        if (hashMethod == null || hashMethod.equals(HASH_METHOD_NONE)) {
            this._hashFunction = new RandomHash();
        } else if (HASH_METHOD_URI_REGEX.equals(hashMethod)) {
            this._hashFunction = new URIRegexHash(hashConfig);
        } else {
            _log.warn("Unknown hash method {}, falling back to random", (Object)hashMethod);
            this._hashFunction = new RandomHash();
        }
    }

    @Override
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        this.checkUpdatePartitionState(clusterGenerationId, partitionId, trackerClients);
        return this._state.getRing(partitionId);
    }

    public Ring<URI> getRing(int partitionId) {
        return this._state.getRing(partitionId);
    }

    public boolean getUpdateEnabled() {
        return this._updateEnabled;
    }

    public void setUpdateEnabled(boolean enabled) {
        this._updateEnabled = enabled;
    }

    @Override
    public void shutdown() {
        this._state.shutdown(this._config);
    }

    private void checkQuarantineState(List<TrackerClientUpdater> clients, DegraderLoadBalancerStrategyConfig config) {
        Callback<None> healthCheckCallback = new Callback<None>(){

            public void onError(Throwable e) {
                DegraderLoadBalancerStrategyV3.this._rateLimitedLogger.warn("Error to enable quarantine. Health checking failed for service {}: ", DegraderLoadBalancerStrategyV3.this._state._serviceName, e);
            }

            public void onSuccess(None result) {
                if (DegraderLoadBalancerStrategyV3.this._state._enableQuarantine.compareAndSet(false, true)) {
                    _log.info("Quarantine is enabled for service {}", (Object)DegraderLoadBalancerStrategyV3.this._state._serviceName);
                }
            }
        };
        clients.stream().limit(10L).forEach(arg_0 -> this.lambda$checkQuarantineState$3(config, (Callback)healthCheckCallback, arg_0));
        for (TrackerClientUpdater client : this._state._healthCheckMap.keySet()) {
            if (clients.contains(client)) continue;
            this._state._healthCheckMap.remove(client);
        }
    }

    void setStrategy(int partitionId, PartitionDegraderLoadBalancerState.Strategy strategy) {
        Partition partition = this._state.getPartition(partitionId);
        PartitionDegraderLoadBalancerState oldState = partition.getState();
        PartitionDegraderLoadBalancerState newState = new PartitionDegraderLoadBalancerState(oldState.getClusterGenerationId(), oldState.getLastUpdated(), oldState.isInitialized(), oldState.getRingFactory(), oldState.getPointsMap(), strategy, oldState.getCurrentOverrideDropRate(), oldState.getCurrentAvgClusterLatency(), oldState.getRecoveryMap(), oldState.getServiceName(), oldState.getDegraderProperties(), oldState.getCurrentClusterCallCount(), oldState.getQuarantineMap(), oldState.getQuarantineHistory());
        partition.setState(newState);
    }

    public String toString() {
        return "DegraderLoadBalancerStrategyV3 [_config=" + this._config + ", _state=" + this._state + "]";
    }

    private /* synthetic */ void lambda$checkQuarantineState$3(DegraderLoadBalancerStrategyConfig config, Callback healthCheckCallback, TrackerClientUpdater client) {
        try {
            HealthCheck healthCheckClient = this._state.getHealthCheckClient(client);
            if (healthCheckClient == null) {
                healthCheckClient = new HealthCheckClientBuilder().setHealthCheckOperations(config.getHealthCheckOperations()).setHealthCheckPath(config.getHealthCheckPath()).setServicePath(config.getServicePath()).setClock(config.getClock()).setLatency(config.getQuarantineLatency()).setMethod(config.getHealthCheckMethod()).setClient(client.getTrackerClient()).build();
                this._state.putHealthCheckClient(client, healthCheckClient);
            }
            healthCheckClient.checkHealth((Callback<None>)healthCheckCallback);
        }
        catch (URISyntaxException e) {
            _log.error("Error to build healthCheckClient ", (Throwable)e);
        }
    }

    public static class PartitionDegraderLoadBalancerState {
        private final RingFactory<URI> _ringFactory;
        private final Ring<URI> _ring;
        private final long _clusterGenerationId;
        private final String _serviceName;
        private final Map<String, String> _degraderProperties;
        private final Map<URI, Integer> _pointsMap;
        private final Map<TrackerClient, Double> _recoveryMap;
        private final Map<TrackerClient, DegraderLoadBalancerQuarantine> _quarantineMap;
        private final Map<TrackerClient, DegraderLoadBalancerQuarantine> _quarantineHistory;
        private final Strategy _strategy;
        private final long _lastUpdated;
        private final double _currentOverrideDropRate;
        private final double _currentAvgClusterLatency;
        private final long _currentClusterCallCount;
        private final boolean _initialized;
        private final Map<TrackerClient, Double> _previousMaxDropRate;

        public PartitionDegraderLoadBalancerState(PartitionDegraderLoadBalancerState state, long clusterGenerationId, long lastUpdated) {
            this._clusterGenerationId = clusterGenerationId;
            this._ringFactory = state._ringFactory;
            this._ring = state._ring;
            this._pointsMap = state._pointsMap;
            this._strategy = state._strategy;
            this._currentOverrideDropRate = state._currentOverrideDropRate;
            this._currentAvgClusterLatency = state._currentAvgClusterLatency;
            this._recoveryMap = state._recoveryMap;
            this._initialized = state._initialized;
            this._lastUpdated = lastUpdated;
            this._serviceName = state._serviceName;
            this._degraderProperties = state._degraderProperties;
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = state._currentClusterCallCount;
            this._quarantineMap = state._quarantineMap;
            this._quarantineHistory = state._quarantineHistory;
        }

        public PartitionDegraderLoadBalancerState(long clusterGenerationId, long lastUpdated, boolean initState, RingFactory<URI> ringFactory, Map<URI, Integer> pointsMap, Strategy strategy, double currentOverrideDropRate, double currentAvgClusterLatency, Map<TrackerClient, Double> recoveryMap, String serviceName, Map<String, String> degraderProperties, long currentClusterCallCount, Map<TrackerClient, DegraderLoadBalancerQuarantine> quarantineMap, Map<TrackerClient, DegraderLoadBalancerQuarantine> quarantineHistory) {
            this._clusterGenerationId = clusterGenerationId;
            this._ringFactory = ringFactory;
            this._ring = ringFactory.createRing(pointsMap);
            this._pointsMap = pointsMap != null ? Collections.unmodifiableMap(new HashMap<URI, Integer>(pointsMap)) : Collections.emptyMap();
            this._strategy = strategy;
            this._currentOverrideDropRate = currentOverrideDropRate;
            this._currentAvgClusterLatency = currentAvgClusterLatency;
            this._recoveryMap = recoveryMap != null ? Collections.unmodifiableMap(new HashMap<TrackerClient, Double>(recoveryMap)) : Collections.emptyMap();
            this._initialized = initState;
            this._lastUpdated = lastUpdated;
            this._serviceName = serviceName;
            this._degraderProperties = degraderProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(degraderProperties)) : Collections.emptyMap();
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = currentClusterCallCount;
            this._quarantineMap = quarantineMap;
            this._quarantineHistory = quarantineHistory;
        }

        public Map<String, String> getDegraderProperties() {
            return this._degraderProperties;
        }

        private String getServiceName() {
            return this._serviceName;
        }

        public long getCurrentClusterCallCount() {
            return this._currentClusterCallCount;
        }

        public long getClusterGenerationId() {
            return this._clusterGenerationId;
        }

        public long getLastUpdated() {
            return this._lastUpdated;
        }

        public Ring<URI> getRing() {
            return this._ring;
        }

        public Map<URI, Integer> getPointsMap() {
            return this._pointsMap;
        }

        public Strategy getStrategy() {
            return this._strategy;
        }

        public Map<TrackerClient, Double> getRecoveryMap() {
            return this._recoveryMap;
        }

        public Map<TrackerClient, DegraderLoadBalancerQuarantine> getQuarantineMap() {
            return this._quarantineMap;
        }

        public Map<TrackerClient, DegraderLoadBalancerQuarantine> getQuarantineHistory() {
            return this._quarantineHistory;
        }

        public double getCurrentOverrideDropRate() {
            return this._currentOverrideDropRate;
        }

        public double getCurrentAvgClusterLatency() {
            return this._currentAvgClusterLatency;
        }

        public Map<TrackerClient, Double> getPreviousMaxDropRate() {
            return this._previousMaxDropRate;
        }

        public boolean isInitialized() {
            return this._initialized;
        }

        public RingFactory<URI> getRingFactory() {
            return this._ringFactory;
        }

        public String toString() {
            return "DegraderLoadBalancerState [_serviceName=" + this._serviceName + ", _currentClusterCallCount=" + this._currentClusterCallCount + ", _currentAvgClusterLatency=" + this._currentAvgClusterLatency + ", _currentOverrideDropRate=" + this._currentOverrideDropRate + ", _clusterGenerationId=" + this._clusterGenerationId + ", _strategy=" + (Object)((Object)this._strategy) + ", _numHostsInCluster=" + (this._pointsMap.size() + this._recoveryMap.size()) + ", _recoveryMap=" + this._recoveryMap + ", _quarantineList=" + this._quarantineMap.values() + "]";
        }

        public static enum Strategy {
            LOAD_BALANCE,
            CALL_DROPPING;

        }
    }

    public static class DegraderLoadBalancerState {
        private final ConcurrentMap<Integer, Partition> _partitions;
        private final String _serviceName;
        private final Map<String, String> _degraderProperties;
        private final DegraderLoadBalancerStrategyConfig _config;
        private final AtomicBoolean _enableQuarantine;
        private final AtomicInteger _retryTimesForQuarantine;
        private final ConcurrentMap<TrackerClientUpdater, HealthCheck> _healthCheckMap;

        DegraderLoadBalancerState(String serviceName, Map<String, String> degraderProperties, DegraderLoadBalancerStrategyConfig config) {
            this._degraderProperties = degraderProperties != null ? degraderProperties : Collections.emptyMap();
            this._partitions = new ConcurrentHashMap<Integer, Partition>();
            this._serviceName = serviceName;
            this._config = config;
            this._enableQuarantine = new AtomicBoolean(false);
            this._retryTimesForQuarantine = new AtomicInteger(0);
            this._healthCheckMap = new ConcurrentHashMap<TrackerClientUpdater, HealthCheck>();
        }

        private Partition getPartition(int partitionId) {
            Partition partition = (Partition)this._partitions.get(partitionId);
            if (partition == null) {
                Partition newValue = new Partition(partitionId, new ReentrantLock(), new PartitionDegraderLoadBalancerState(-1L, this._config.getClock().currentTimeMillis(), false, new DegraderRingFactory<URI>(this._config), new HashMap<URI, Integer>(), PartitionDegraderLoadBalancerState.Strategy.LOAD_BALANCE, 0.0, 0.0, new HashMap<TrackerClient, Double>(), this._serviceName, this._degraderProperties, 0L, new HashMap<TrackerClient, DegraderLoadBalancerQuarantine>(), new HashMap<TrackerClient, DegraderLoadBalancerQuarantine>()));
                Partition oldValue = this._partitions.putIfAbsent(partitionId, newValue);
                partition = oldValue == null ? newValue : oldValue;
            }
            return partition;
        }

        private Ring<URI> getRing(int partitionId) {
            if (this._partitions.get(partitionId) != null) {
                PartitionDegraderLoadBalancerState state = ((Partition)this._partitions.get(partitionId)).getState();
                return state.getRing();
            }
            return null;
        }

        public PartitionDegraderLoadBalancerState getPartitionState(int partitionId) {
            return this.getPartition(partitionId).getState();
        }

        void setPartitionState(int partitionId, PartitionDegraderLoadBalancerState newState) {
            this.getPartition(partitionId).setState(newState);
        }

        void putHealthCheckClient(TrackerClientUpdater updater, HealthCheck client) {
            this._healthCheckMap.put(updater, client);
        }

        HealthCheck getHealthCheckClient(TrackerClientUpdater updater) {
            return (HealthCheck)this._healthCheckMap.get(updater);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown(DegraderLoadBalancerStrategyConfig config) {
            if (config.getQuarantineMaxPercent() <= 0.0 || !this._enableQuarantine.get()) {
                return;
            }
            for (Partition par : this._partitions.values()) {
                Lock lock = par.getLock();
                lock.lock();
                try {
                    PartitionDegraderLoadBalancerState curState = par.getState();
                    curState.getQuarantineMap().values().forEach(DegraderLoadBalancerQuarantine::shutdown);
                }
                finally {
                    lock.unlock();
                }
            }
        }

        public String toString() {
            return "PartitionStates: [" + this._partitions + "]";
        }
    }

    private static class Partition {
        private final int _id;
        private final Lock _lock;
        private volatile PartitionDegraderLoadBalancerState _state;

        Partition(int id, Lock lock, PartitionDegraderLoadBalancerState state) {
            this._id = id;
            this._lock = lock;
            this._state = state;
        }

        public int getId() {
            return this._id;
        }

        public Lock getLock() {
            return this._lock;
        }

        public PartitionDegraderLoadBalancerState getState() {
            return this._state;
        }

        public void setState(PartitionDegraderLoadBalancerState state) {
            this._state = state;
        }

        public String toString() {
            return String.valueOf(this._state);
        }
    }
}

