/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util;

import com.linkedin.util.clock.Clock;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class RateLimitedLogger {
    private static final long INIT_TIME = -1L;
    private final Logger _logger;
    private final long _logRate;
    private final Clock _clock;
    private final AtomicLong _lastLog = new AtomicLong(-1L);

    public RateLimitedLogger(Logger logger, long logRate, Clock clock) {
        this._logger = logger;
        this._logRate = logRate;
        this._clock = clock;
    }

    public boolean isTraceEnabled() {
        return this._logger.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.logAllowed()) {
            this._logger.trace(msg);
        }
    }

    public void trace(String format, Object[] argArray) {
        if (this.logAllowed()) {
            this._logger.trace(format, argArray);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._logger.trace(msg, t);
        }
    }

    public void trace(String format, Object obj) {
        if (this.logAllowed()) {
            this._logger.trace(format, obj);
        }
    }

    public void trace(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._logger.trace(format, obj1, obj2);
        }
    }

    public boolean isDebugEnabled() {
        return this._logger.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.logAllowed()) {
            this._logger.debug(msg);
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.logAllowed()) {
            this._logger.debug(format, argArray);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._logger.debug(msg, t);
        }
    }

    public void debug(String format, Object obj) {
        if (this.logAllowed()) {
            this._logger.debug(format, obj);
        }
    }

    public void debug(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._logger.debug(format, obj1, obj2);
        }
    }

    public boolean isInfoEnabled() {
        return this._logger.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.logAllowed()) {
            this._logger.info(msg);
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.logAllowed()) {
            this._logger.info(format, argArray);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._logger.info(msg, t);
        }
    }

    public void info(String format, Object obj) {
        if (this.logAllowed()) {
            this._logger.info(format, obj);
        }
    }

    public void info(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._logger.info(format, obj1, obj2);
        }
    }

    public boolean isWarnEnabled() {
        return this._logger.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.logAllowed()) {
            this._logger.warn(msg);
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.logAllowed()) {
            this._logger.warn(format, argArray);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._logger.warn(msg, t);
        }
    }

    public void warn(String format, Object obj) {
        if (this.logAllowed()) {
            this._logger.warn(format, obj);
        }
    }

    public void warn(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._logger.warn(format, obj1, obj2);
        }
    }

    public boolean isErrorEnabled() {
        return this._logger.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.logAllowed()) {
            this._logger.error(msg);
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.logAllowed()) {
            this._logger.error(format, argArray);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.logAllowed()) {
            this._logger.error(msg, t);
        }
    }

    public void error(String format, Object obj) {
        if (this.logAllowed()) {
            this._logger.error(format, obj);
        }
    }

    public void error(String format, Object obj1, Object obj2) {
        if (this.logAllowed()) {
            this._logger.error(format, obj1, obj2);
        }
    }

    private boolean logAllowed() {
        long now = this._clock.currentTimeMillis();
        long lastLog = this._lastLog.get();
        return (lastLog == -1L || now - lastLog >= this._logRate) && this._lastLog.compareAndSet(lastLog, now);
    }
}

