/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.d2.balancer.util.hashing.ConsistentHashRingIterator;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.discovery.util.LogUtil;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHashRing<T>
implements Ring<T> {
    private static final Logger _log = LoggerFactory.getLogger(ConsistentHashRing.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @Deprecated
    private final MessageDigest _md;
    private final List<Point<T>> _points;

    public ConsistentHashRing(List<Point<T>> points) {
        this._md = null;
        this._points = points;
        if (points == null) {
            throw new RuntimeException("Building consistent hash ring without points");
        }
        Collections.sort(points);
        LogUtil.debug(_log, "Initializing consistent hash ring with {} items: ", points.size());
    }

    public ConsistentHashRing(Map<T, Integer> pointMap) {
        this._points = new ArrayList<Point<T>>();
        try {
            this._md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.error(_log, "unable to get md5 hash function");
            throw new RuntimeException(e);
        }
        this.add(pointMap);
    }

    public ConsistentHashRing(Map<T, Integer> pointMap, MessageDigest md) {
        this._points = new ArrayList<Point<T>>();
        this._md = md;
        this.add(pointMap);
    }

    protected void add(Map<T, Integer> pointMap) {
        for (Map.Entry<T, Integer> point : pointMap.entrySet()) {
            T t = point.getKey();
            int points = point.getValue();
            if (t == null) {
                LogUtil.warn(_log, "tried to add a null value to consistent hash ring");
                throw new NullPointerException("null values in hash ring are unsupported");
            }
            byte[] bytesToHash = t.toString().getBytes(UTF8);
            byte[] hash = null;
            for (int i = 0; i < points; ++i) {
                int iMod4 = i % 4;
                int iMod4TimesFour = iMod4 * 4;
                if (iMod4 == 0) {
                    hash = this._md.digest(bytesToHash);
                    bytesToHash = hash;
                }
                void hashInt = hash[iMod4TimesFour] + (hash[iMod4TimesFour + 1] << 8) + (hash[iMod4TimesFour + 2] << 16) + (hash[iMod4TimesFour + 3] << 24);
                this._points.add(new Point<T>(t, (int)hashInt));
            }
        }
        Collections.sort(this._points);
        LogUtil.debug(_log, "re-initializing consistent hash ring with items: ", this._points);
    }

    private int getIndex(int key) {
        LogUtil.debug(_log, "searching for hash in ring of size ", this._points.size(), " using hash: ", key);
        int index = Collections.binarySearch(this._points, new Point<Object>(null, key));
        if (index < 0) {
            index = Math.abs(index + 1);
        }
        return index %= this._points.size();
    }

    @Override
    public T get(int key) {
        if (this._points.isEmpty()) {
            LogUtil.debug(_log, "get called on a hash ring with nothing in it");
            return null;
        }
        int index = this.getIndex(key);
        return this._points.get(index).getT();
    }

    @Override
    public Iterator<T> getIterator(int key) {
        if (this._points.isEmpty()) {
            LogUtil.debug(_log, "get called on a hash ring with nothing in it");
            return new ConsistentHashRingIterator<T>(this._points, 0);
        }
        int from = this.getIndex(key);
        return new ConsistentHashRingIterator<T>(this._points, from);
    }

    public List<Point<T>> getPoints() {
        return this._points;
    }

    public double getHighLowDiffOfAreaRing() {
        if (!this._points.isEmpty()) {
            Map<T, Double> coverageMap = this.getCoverageMap();
            Double sizeOfInt = new Double(2.147483647E9) - new Double(-2.147483648E9);
            double maxPercentage = Double.MIN_VALUE;
            double minPercentage = Double.MAX_VALUE;
            for (Map.Entry<T, Double> entry : coverageMap.entrySet()) {
                double value = entry.getValue();
                double percentage = value * 100.0 / sizeOfInt;
                if (percentage > maxPercentage) {
                    maxPercentage = percentage;
                }
                if (!(percentage < minPercentage)) continue;
                minPercentage = percentage;
            }
            return maxPercentage - minPercentage;
        }
        return -1.0;
    }

    Map<T, Double> getCoverageMap() {
        if (this._points.isEmpty()) {
            return null;
        }
        HashMap<T, Double> coverageMap = new HashMap<T, Double>();
        Double curr = new Double(-2.147483648E9);
        Object firstElement = null;
        for (Point<T> point : this._points) {
            if (firstElement == null) {
                firstElement = point.getT();
            }
            Double currentCoverage = (double)point.getHash() - curr;
            curr = new Double(point.getHash());
            Double area = (Double)coverageMap.get(point.getT());
            if (area == null) {
                area = 0.0;
            }
            area = area + currentCoverage;
            coverageMap.put(point.getT(), area);
        }
        Double remainingArea = new Double(2.147483647E9 - curr);
        Double area = (Double)coverageMap.get(firstElement);
        area = area + remainingArea;
        coverageMap.put(firstElement, area);
        return coverageMap;
    }

    String printRingArea() {
        Map<T, Double> coverageMap = this.getCoverageMap();
        if (coverageMap != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Area percentage in the hash ring is [");
            double sizeOfInt = 4.294967295E9;
            for (Map.Entry<T, Double> entry : coverageMap.entrySet()) {
                double percentage = entry.getValue() * 100.0 / sizeOfInt;
                builder.append(String.format("%s=%.2f%%, ", entry.getKey(), percentage));
            }
            builder.append("]");
            return builder.toString();
        }
        return "Ring is currently null or empty";
    }

    public String toString() {
        if (this._md != null) {
            return "ConsistentHashRing [_md=" + this._md + this.printRingArea() + "]";
        }
        return "ConsistentHashRing [" + this.printRingArea() + "]";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ConsistentHashRing)) {
            return false;
        }
        ConsistentHashRing ring = (ConsistentHashRing)o;
        return this._points.equals(ring._points);
    }

    public int hashCode() {
        return this._points == null ? 1 : this._points.hashCode();
    }

    public static class Point<T>
    implements Comparable<Point<T>> {
        private final T _t;
        private final int _hash;

        public Point(T t, int hash) {
            this._t = t;
            this._hash = hash;
        }

        public T getT() {
            return this._t;
        }

        public int getHash() {
            return this._hash;
        }

        @Override
        public int compareTo(Point<T> o) {
            return this._hash < o._hash ? -1 : (this._hash == o._hash ? 0 : 1);
        }

        public String toString() {
            return "Point [_hash=" + this._hash + ", _t=" + this._t + "]";
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Point)) {
                return false;
            }
            Point p = (Point)o;
            return this._t.equals(p._t) && this._hash == p._hash;
        }

        public int hashCode() {
            int hashCode = this._t == null ? 1 : this._t.hashCode() * 31;
            hashCode = 31 * hashCode * this._hash;
            return hashCode;
        }
    }
}

