/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.config.store.api.VersionDoesNotExistException;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.gobblin.util.executors.IteratorExecutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigBasedDatasetsFinder
implements DatasetsFinder {
    private static final Logger log = LoggerFactory.getLogger(ConfigBasedDatasetsFinder.class);
    public static final String GOBBLIN_CONFIG_STORE_WHITELIST_TAG = "gobblin.configBased.whitelist.tag";
    public static final String GOBBLIN_CONFIG_STORE_BLACKLIST_TAGS = "gobblin.configBased.blacklist.tags";
    public static final String GOBBLIN_CONFIG_STORE_DATASET_COMMON_ROOT = "gobblin.configBased.dataset.common.root";
    public static final String JOB_LEVEL_BLACKLIST = "gobblin.copy.configBased.blacklist";
    public static final String WATERMARK_ENABLE = "gobblin.copy.configBased.watermark.enabled";
    protected final String storeRoot;
    protected final Path commonRoot;
    protected final Path whitelistTag;
    protected final Optional<List<Path>> blacklistTags;
    protected final ConfigClient configClient;
    protected final Properties props;
    private final int threadPoolSize;
    private final Optional<List<String>> blacklistPatterns;

    public ConfigBasedDatasetsFinder(FileSystem fs, Properties jobProps) throws IOException {
        Preconditions.checkArgument((boolean)jobProps.containsKey("gobblin.config.management.store.uri"), (Object)"missing required config entery gobblin.config.management.store.uri");
        Preconditions.checkArgument((boolean)jobProps.containsKey(GOBBLIN_CONFIG_STORE_WHITELIST_TAG), (Object)"missing required config entery gobblin.configBased.whitelist.tag");
        Preconditions.checkArgument((boolean)jobProps.containsKey(GOBBLIN_CONFIG_STORE_DATASET_COMMON_ROOT), (Object)"missing required config entery gobblin.configBased.dataset.common.root");
        this.storeRoot = jobProps.getProperty("gobblin.config.management.store.uri");
        this.commonRoot = PathUtils.mergePaths((Path)new Path(this.storeRoot), (Path)new Path(jobProps.getProperty(GOBBLIN_CONFIG_STORE_DATASET_COMMON_ROOT)));
        this.whitelistTag = PathUtils.mergePaths((Path)new Path(this.storeRoot), (Path)new Path(jobProps.getProperty(GOBBLIN_CONFIG_STORE_WHITELIST_TAG)));
        int n = this.threadPoolSize = jobProps.containsKey("gobblin.copy.max.concurrent.listing.services") ? Integer.parseInt(jobProps.getProperty("gobblin.copy.max.concurrent.listing.services")) : 20;
        if (jobProps.containsKey(GOBBLIN_CONFIG_STORE_BLACKLIST_TAGS)) {
            List disableStrs = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)jobProps.getProperty(GOBBLIN_CONFIG_STORE_BLACKLIST_TAGS));
            ArrayList<Path> disablePaths = new ArrayList<Path>();
            for (String s : disableStrs) {
                disablePaths.add(PathUtils.mergePaths((Path)new Path(this.storeRoot), (Path)new Path(s)));
            }
            this.blacklistTags = Optional.of(disablePaths);
        } else {
            this.blacklistTags = Optional.absent();
        }
        this.configClient = ConfigClient.createConfigClient((VersionStabilityPolicy)VersionStabilityPolicy.WEAK_LOCAL_STABILITY);
        this.props = jobProps;
        this.blacklistPatterns = this.props.containsKey(JOB_LEVEL_BLACKLIST) ? Optional.of((Object)Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)this.props.getProperty(JOB_LEVEL_BLACKLIST))) : Optional.absent();
    }

    protected Set<URI> getValidDatasetURIs(Path datasetCommonRoot) {
        Collection allDatasetURIs;
        HashSet<URI> disabledURISet = new HashSet<URI>();
        try {
            allDatasetURIs = this.configClient.getImportedBy(new URI(this.whitelistTag.toString()), true);
            this.enhanceDisabledURIsWithBlackListTag(disabledURISet);
        }
        catch (URISyntaxException | ConfigStoreFactoryDoesNotExistsException | ConfigStoreCreationException e) {
            log.error("Caught error while getting all the datasets URIs " + e.getMessage());
            throw new RuntimeException(e);
        }
        return ConfigBasedDatasetsFinder.getValidDatasetURIsHelper(allDatasetURIs, disabledURISet, datasetCommonRoot);
    }

    protected static Set<URI> getValidDatasetURIsHelper(Collection<URI> allDatasetURIs, Set<URI> disabledURISet, Path datasetCommonRoot) {
        if (allDatasetURIs == null || allDatasetURIs.isEmpty()) {
            return ImmutableSet.of();
        }
        Comparator<URI> pathLengthComparator = new Comparator<URI>(){

            @Override
            public int compare(URI c1, URI c2) {
                return c1.getPath().length() - c2.getPath().length();
            }
        };
        ArrayList<URI> sortedDatasetsList = new ArrayList<URI>(allDatasetURIs);
        Collections.sort(sortedDatasetsList, pathLengthComparator);
        TreeSet<URI> uriSet = new TreeSet<URI>();
        HashSet<URI> noneLeaf = new HashSet<URI>();
        for (URI u : sortedDatasetsList) {
            if (!PathUtils.isAncestor((Path)datasetCommonRoot, (Path)new Path(u.getPath()))) continue;
            URI floor = uriSet.floor(u);
            if (floor != null && PathUtils.isAncestor((Path)new Path(floor.getPath()), (Path)new Path(u.getPath()))) {
                noneLeaf.add(floor);
            }
            uriSet.add(u);
        }
        HashSet<URI> validURISet = new HashSet<URI>();
        for (URI u : uriSet) {
            if (noneLeaf.contains(u)) continue;
            validURISet.add(u);
        }
        for (URI disable : disabledURISet) {
            if (validURISet.remove(disable)) {
                log.info("skip disabled dataset " + disable);
                continue;
            }
            log.info("There's no URI " + disable + " available in validURISet.");
        }
        return validURISet;
    }

    private void enhanceDisabledURIsWithBlackListTag(Set<URI> disabledURIs) throws URISyntaxException, ConfigStoreFactoryDoesNotExistsException, ConfigStoreCreationException, VersionDoesNotExistException {
        if (this.blacklistTags.isPresent()) {
            for (Path s : (List)this.blacklistTags.get()) {
                disabledURIs.addAll(this.configClient.getImportedBy(new URI(s.toString()), true));
            }
        }
    }

    public Path commonDatasetRoot() {
        return this.commonRoot;
    }

    public List<Dataset> findDatasets() throws IOException {
        Set<URI> leafDatasets = this.getValidDatasetURIs(this.commonRoot);
        if (leafDatasets.isEmpty()) {
            return ImmutableList.of();
        }
        final CopyOnWriteArrayList<Dataset> result = new CopyOnWriteArrayList<Dataset>();
        Iterator callableIterator = Iterators.transform(leafDatasets.iterator(), (Function)new Function<URI, Callable<Void>>(){

            public Callable<Void> apply(URI datasetURI) {
                return ConfigBasedDatasetsFinder.this.findDatasetsCallable(ConfigBasedDatasetsFinder.this.configClient, datasetURI, ConfigBasedDatasetsFinder.this.props, (Optional<List<String>>)ConfigBasedDatasetsFinder.this.blacklistPatterns, result);
            }
        });
        this.executeItertorExecutor(callableIterator);
        log.info("found {} datasets in ConfigBasedDatasetsFinder", (Object)result.size());
        return result;
    }

    protected void executeItertorExecutor(Iterator<Callable<Void>> callableIterator) throws IOException {
        try {
            IteratorExecutor executor = new IteratorExecutor(callableIterator, this.threadPoolSize, ExecutorsUtils.newDaemonThreadFactory((Optional)Optional.of((Object)log), (Optional)Optional.of((Object)this.getClass().getSimpleName())));
            List results = executor.executeAndGetResults();
            IteratorExecutor.logFailures((List)results, (Logger)log, (int)10);
        }
        catch (InterruptedException ie) {
            throw new IOException("Dataset finder is interrupted.", ie);
        }
    }

    private URI datasetURNtoURI(String datasetURN) {
        try {
            return new URI(PathUtils.mergePaths((Path)new Path(this.storeRoot), (Path)new Path(datasetURN)).toString());
        }
        catch (URISyntaxException e) {
            log.error("Dataset with URN:" + datasetURN + " cannot be converted into URI. Skip the dataset");
            return null;
        }
    }

    protected abstract Callable<Void> findDatasetsCallable(ConfigClient var1, URI var2, Properties var3, Optional<List<String>> var4, Collection<Dataset> var5);
}

