/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.copy.replication;

import com.typesafe.config.Config;
import java.io.IOException;
import java.net.URI;
import org.apache.gobblin.data.management.copy.replication.EndPoint;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopFsEndPoint
implements EndPoint {
    private static final Logger log = LoggerFactory.getLogger(HadoopFsEndPoint.class);
    private PathFilter pathFilter;
    private boolean applyFilterToDirectories;

    public abstract String getClusterName();

    public abstract URI getFsURI();

    public abstract Path getDatasetPath();

    public abstract Config getSelectionConfig();

    public boolean isPathAvailable(Path path) {
        try {
            Configuration conf = HadoopUtils.newConfiguration();
            FileSystem fs = FileSystem.get((URI)this.getFsURI(), (Configuration)conf);
            if (fs.exists(path)) {
                return true;
            }
            log.warn("Skipped the problematic FileSystem " + this.getFsURI());
            return false;
        }
        catch (IOException ioe) {
            log.warn("Skipped the problematic FileSystem " + this.getFsURI());
            return false;
        }
    }

    @Override
    public boolean isFileSystemAvailable() {
        return this.isPathAvailable(new Path("/"));
    }

    public boolean isDatasetAvailable(Path datasetPath) {
        return this.isPathAvailable(datasetPath);
    }

    public PathFilter getPathFilter() {
        return this.pathFilter;
    }

    public boolean isApplyFilterToDirectories() {
        return this.applyFilterToDirectories;
    }

    public void setPathFilter(PathFilter pathFilter) {
        this.pathFilter = pathFilter;
    }

    public void setApplyFilterToDirectories(boolean applyFilterToDirectories) {
        this.applyFilterToDirectories = applyFilterToDirectories;
    }
}

