/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.retention.profile;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.gobblin.dataset.Dataset;
import org.apache.gobblin.dataset.DatasetsFinder;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableGlobDatasetFinder<T extends Dataset>
implements DatasetsFinder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableGlobDatasetFinder.class);
    private static final String CONFIGURATION_KEY_PREFIX = "gobblin.";
    @Deprecated
    public static final String DATASET_PATTERN_KEY = "gobblin.retention.dataset.pattern";
    @Deprecated
    public static final String DATASET_BLACKLIST_KEY = "gobblin.retention.dataset.blacklist";
    public static final String DATASET_FINDER_PATTERN_KEY = "gobblin.dataset.pattern";
    public static final String DATASET_FINDER_BLACKLIST_KEY = "gobblin.dataset.blacklist";
    protected final Path datasetPattern;
    private final Optional<Pattern> blacklist;
    private final Path commonRoot;
    protected final FileSystem fs;
    protected final Properties props;
    private static final Map<String, String> DEPRECATIONS = ImmutableMap.of((Object)"gobblin.dataset.pattern", (Object)"gobblin.retention.dataset.pattern", (Object)"gobblin.dataset.blacklist", (Object)"gobblin.retention.dataset.blacklist");

    public ConfigurableGlobDatasetFinder(FileSystem fs, Properties jobProps, Config config) {
        for (String property : this.requiredProperties()) {
            Preconditions.checkArgument((config.hasPath(property) || config.hasPath(DEPRECATIONS.get(property)) ? 1 : 0) != 0, (Object)String.format("Missing required property %s", property));
        }
        this.blacklist = ConfigUtils.hasNonEmptyPath((Config)config, (String)DATASET_BLACKLIST_KEY) ? Optional.of((Object)Pattern.compile(config.getString(DATASET_BLACKLIST_KEY))) : (ConfigUtils.hasNonEmptyPath((Config)config, (String)DATASET_FINDER_BLACKLIST_KEY) ? Optional.of((Object)Pattern.compile(config.getString(DATASET_FINDER_BLACKLIST_KEY))) : Optional.absent());
        this.fs = fs;
        Path tmpDatasetPattern = config.hasPath(DATASET_FINDER_PATTERN_KEY) ? new Path(config.getString(DATASET_FINDER_PATTERN_KEY)) : new Path(config.getString(DATASET_PATTERN_KEY));
        this.datasetPattern = tmpDatasetPattern.isAbsolute() ? tmpDatasetPattern : new Path(this.fs.getWorkingDirectory(), tmpDatasetPattern);
        this.commonRoot = PathUtils.deepestNonGlobPath((Path)this.datasetPattern);
        this.props = jobProps;
    }

    public ConfigurableGlobDatasetFinder(FileSystem fs, Properties props) {
        this(fs, props, ConfigFactory.parseProperties((Properties)props));
    }

    public List<String> requiredProperties() {
        return Lists.newArrayList((Object[])new String[]{DATASET_FINDER_PATTERN_KEY});
    }

    public List<T> findDatasets() throws IOException {
        ArrayList datasets = Lists.newArrayList();
        LOG.info("Finding datasets for pattern " + this.datasetPattern);
        FileStatus[] fileStatuss = this.getDatasetDirs();
        if (fileStatuss != null) {
            for (FileStatus fileStatus : fileStatuss) {
                Path pathToMatch = PathUtils.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath());
                if (this.blacklist.isPresent() && ((Pattern)this.blacklist.get()).matcher(pathToMatch.toString()).find()) continue;
                LOG.info("Found dataset at " + fileStatus.getPath());
                datasets.add(this.datasetAtPath(PathUtils.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath())));
            }
        }
        return datasets;
    }

    protected FileStatus[] getDatasetDirs() throws IOException {
        return this.fs.globStatus(this.datasetPattern);
    }

    public Path commonDatasetRoot() {
        return this.commonRoot;
    }

    public abstract T datasetAtPath(Path var1) throws IOException;
}

