/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.metrics.ContextAwareMetric;
import org.apache.gobblin.metrics.ContextAwareMetricFactory;
import org.apache.gobblin.metrics.ContextAwareMetricFactoryArgs;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.Tagged;
import org.apache.gobblin.metrics.context.ContextWeakReference;
import org.apache.gobblin.metrics.context.NameConflictException;
import org.apache.gobblin.metrics.context.ReportableContext;
import org.apache.gobblin.metrics.metric.InnerMetric;

public class InnerMetricContext
extends MetricRegistry
implements ReportableContext,
Closeable {
    private final Closer closer;
    private final String name;
    private final ConcurrentMap<String, InnerMetric> contextAwareMetrics = Maps.newConcurrentMap();
    private final Tagged tagged;
    private final Optional<MetricContext> parent;
    private final Cache<String, MetricContext> children = CacheBuilder.newBuilder().weakValues().build();
    private final WeakReference<MetricContext> metricContext;

    protected InnerMetricContext(MetricContext context, String name, MetricContext parent, List<Tag<?>> tags) throws NameConflictException, ExecutionException {
        this.name = name;
        this.closer = Closer.create();
        this.parent = Optional.fromNullable((Object)parent);
        if (this.parent.isPresent()) {
            ((MetricContext)this.parent.get()).addChildContext(this.name, context);
            this.metricContext = new ContextWeakReference(context, this);
        } else {
            this.metricContext = new WeakReference<MetricContext>(context);
        }
        this.tagged = new Tagged(tags);
        this.tagged.addTag(new Tag<String>("metricContextID", UUID.randomUUID().toString()));
        this.tagged.addTag(new Tag<String>("metricContextName", name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Optional<MetricContext> getParent() {
        return this.parent;
    }

    public synchronized void addChildContext(String childContextName, final MetricContext childContext) throws NameConflictException, ExecutionException {
        if (this.children.get((Object)childContextName, (Callable)new Callable<MetricContext>(){

            @Override
            public MetricContext call() throws Exception {
                return childContext;
            }
        }) != childContext) {
            throw new NameConflictException("A child context with that name already exists.");
        }
    }

    public Map<String, MetricContext> getChildContextsAsMap() {
        return ImmutableMap.copyOf((Map)this.children.asMap());
    }

    @Override
    public SortedSet<String> getNames() {
        return this.getSimpleNames();
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.getSimplyNamedMetrics();
    }

    @Override
    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.getSimplyNamedMetrics(Gauge.class, (Optional<MetricFilter>)Optional.of((Object)filter));
    }

    @Override
    public SortedMap<String, Counter> getCounters(MetricFilter filter) {
        return this.getSimplyNamedMetrics(Counter.class, (Optional<MetricFilter>)Optional.of((Object)filter));
    }

    @Override
    public SortedMap<String, Histogram> getHistograms(MetricFilter filter) {
        return this.getSimplyNamedMetrics(Histogram.class, (Optional<MetricFilter>)Optional.of((Object)filter));
    }

    @Override
    public SortedMap<String, Meter> getMeters(MetricFilter filter) {
        return this.getSimplyNamedMetrics(Meter.class, (Optional<MetricFilter>)Optional.of((Object)filter));
    }

    @Override
    public SortedMap<String, Timer> getTimers(MetricFilter filter) {
        return this.getSimplyNamedMetrics(Timer.class, (Optional<MetricFilter>)Optional.of((Object)filter));
    }

    public synchronized <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        if (!(metric instanceof ContextAwareMetric)) {
            throw new UnsupportedOperationException("Can only register ContextAwareMetrics");
        }
        if (this.contextAwareMetrics.putIfAbsent(name, ((ContextAwareMetric)metric).getInnerMetric()) != null) {
            throw new IllegalArgumentException("A metric named " + name + " already exists");
        }
        MetricContext metricContext = (MetricContext)this.metricContext.get();
        if (metricContext != null) {
            metricContext.addToMetrics((ContextAwareMetric)metric);
        }
        return metric;
    }

    public <T extends ContextAwareMetric> T register(T metric) throws IllegalArgumentException {
        return this.register(metric.getName(), metric);
    }

    public void registerAll(MetricSet metrics) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean remove(String name) {
        MetricContext metricContext = (MetricContext)this.metricContext.get();
        if (metricContext != null) {
            metricContext.removeFromMetrics(((InnerMetric)this.contextAwareMetrics.get(name)).getContextAwareMetric());
        }
        return this.contextAwareMetrics.remove(name) != null && this.removeChildrenMetrics(name);
    }

    public void removeMatching(MetricFilter filter) {
        for (Map.Entry entry : this.contextAwareMetrics.entrySet()) {
            if (!filter.matches((String)entry.getKey(), (Metric)((InnerMetric)entry.getValue()).getContextAwareMetric())) continue;
            this.remove((String)entry.getKey());
        }
    }

    @Override
    public List<Tag<?>> getTags() {
        return this.tagged.getTags();
    }

    @Override
    public Map<String, Object> getTagMap() {
        return this.tagged.getTagMap();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private SortedSet<String> getSimpleNames() {
        return ImmutableSortedSet.copyOf(this.contextAwareMetrics.keySet());
    }

    private Map<String, Metric> getSimplyNamedMetrics() {
        return ImmutableMap.copyOf(this.contextAwareMetrics);
    }

    private <T extends Metric> SortedMap<String, T> getSimplyNamedMetrics(Class<T> mClass, Optional<MetricFilter> filter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : this.contextAwareMetrics.entrySet()) {
            if (!mClass.isInstance(entry.getValue()) || filter.isPresent() && !((MetricFilter)filter.get()).matches((String)entry.getKey(), (Metric)((InnerMetric)entry.getValue()).getContextAwareMetric())) continue;
            builder.put(entry.getKey(), (Object)((Metric)entry.getValue()));
        }
        return builder.build();
    }

    protected synchronized <T extends ContextAwareMetric> T getOrCreate(String name, ContextAwareMetricFactory<T> factory) {
        InnerMetric metric = (InnerMetric)this.contextAwareMetrics.get(name);
        if (metric != null) {
            if (factory.isInstance(metric)) {
                return (T)metric.getContextAwareMetric();
            }
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        T newMetric = factory.newMetric((MetricContext)this.metricContext.get(), name);
        this.register(name, newMetric);
        return newMetric;
    }

    protected synchronized <T extends ContextAwareMetric> T getOrCreate(ContextAwareMetricFactory<T> factory, ContextAwareMetricFactoryArgs args) {
        String name = args.getName();
        InnerMetric metric = (InnerMetric)this.contextAwareMetrics.get(name);
        if (metric != null) {
            if (factory.isInstance(metric)) {
                return (T)metric.getContextAwareMetric();
            }
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        T newMetric = factory.newMetric(args);
        this.register(name, newMetric);
        return newMetric;
    }

    private boolean removeChildrenMetrics(String name) {
        boolean removed = true;
        for (MetricContext child : this.getChildContextsAsMap().values()) {
            if (child.remove(name)) continue;
            removed = false;
        }
        return removed;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InnerMetricContext Name: ");
        stringBuilder.append(this.name);
        if (this.getParent().isPresent()) {
            stringBuilder.append(", Parent Name: ");
            stringBuilder.append(((MetricContext)this.getParent().get()).getName());
        } else {
            stringBuilder.append(", No Parent Context");
        }
        stringBuilder.append(", Number of Children: ");
        stringBuilder.append(this.getChildContextsAsMap().size());
        stringBuilder.append(", Tags: ");
        stringBuilder.append(Joiner.on((String)", ").withKeyValueSeparator(" : ").useForNull("NULL").join(this.getTagMap()));
        return stringBuilder.toString();
    }

    public WeakReference<MetricContext> getMetricContext() {
        return this.metricContext;
    }
}

