/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.Tag;
import org.apache.gobblin.metrics.reporter.ScheduledReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfiguredScheduledReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredScheduledReporter.class);
    private static final String FINAL_TAG_KEY = "finalReport";
    private final TimeUnit rateUnit;
    private final TimeUnit durationUnit;
    private final double rateFactor;
    private final double durationFactor;
    protected final ImmutableMap<String, String> tags;
    protected final Closer closer;
    protected final String metricContextName;
    protected final String metricsPrefix;
    protected static final Joiner JOINER = Joiner.on((char)'.').skipNulls();

    public ConfiguredScheduledReporter(Builder<?> builder, Config config) {
        super(builder.name, config);
        this.rateUnit = builder.rateUnit;
        this.durationUnit = builder.durationUnit;
        this.rateFactor = builder.rateUnit.toSeconds(1L);
        this.durationFactor = 1.0 / (double)builder.durationUnit.toNanos(1L);
        this.tags = ImmutableMap.copyOf(builder.tags);
        this.closer = Closer.create();
        this.metricContextName = builder.metricContextName;
        this.metricsPrefix = builder.metricsPrefix;
    }

    @Override
    protected void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers, Map<String, Object> tags, boolean isFinal) {
        if (isFinal) {
            this.report(gauges, counters, histograms, meters, timers, (Map<String, Object>)ImmutableMap.builder().putAll(tags).put((Object)FINAL_TAG_KEY, (Object)Boolean.TRUE).build());
        } else {
            this.report(gauges, counters, histograms, meters, timers, tags);
        }
    }

    protected double convertDuration(double duration) {
        return duration * this.durationFactor;
    }

    protected double convertRate(double rate) {
        return rate * this.rateFactor;
    }

    protected String getMetricNamePrefix(Map<String, Object> tags) {
        String currentContextName = (String)tags.get("metricContextName");
        if (this.metricContextName == null || currentContextName.indexOf(this.metricContextName) > -1) {
            return currentContextName;
        }
        return JOINER.join((Object)Strings.emptyToNull((String)this.metricsPrefix), (Object)this.metricContextName, new Object[]{tags.get("taskId"), tags.get("forkBranchName"), tags.get("class")});
    }

    @Override
    public void close() throws IOException {
        try {
            this.closer.close();
        }
        catch (Exception e) {
            LOGGER.warn("Exception when closing ConfiguredScheduledReporter", (Throwable)e);
        }
        finally {
            super.close();
        }
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name = "ConfiguredScheduledReporter";
        protected TimeUnit rateUnit = TimeUnit.SECONDS;
        protected TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        protected Map<String, String> tags = Maps.newHashMap();
        protected String metricContextName;
        protected String metricsPrefix;

        protected Builder() {
        }

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this.self();
        }

        public T convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this.self();
        }

        public T withTags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this.self();
        }

        public T withTags(List<Tag<?>> tags) {
            for (Tag<?> tag : tags) {
                this.tags.put((String)tag.getKey(), tag.getValue().toString());
            }
            return this.self();
        }

        public T withTag(String key, String value) {
            this.tags.put(key, value);
            return this.self();
        }

        public T withMetricsPrefix(String metricsPrefix) {
            this.metricsPrefix = metricsPrefix;
            return this.self();
        }

        public T withMetricContextName(String metricContextName) {
            this.metricContextName = metricContextName;
            return this.self();
        }
    }
}

