/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.reporter;

import com.google.common.base.Charsets;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Queue;
import org.apache.gobblin.metrics.GobblinTrackingEvent;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.event.FailureEventBuilder;
import org.apache.gobblin.metrics.reporter.OutputStreamEventReporter;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFailureEventReporter
extends OutputStreamEventReporter {
    private static final Logger log = LoggerFactory.getLogger(FileFailureEventReporter.class);
    private final FileSystem fs;
    private final Path failureLogFile;
    private volatile boolean hasSetupOutputStream;

    public FileFailureEventReporter(MetricContext context, FileSystem fs, Path failureLogFile) throws IOException {
        super(OutputStreamEventReporter.forContext(context));
        this.fs = fs;
        this.failureLogFile = failureLogFile;
        this.hasSetupOutputStream = false;
    }

    @Override
    public void addEventToReportingQueue(GobblinTrackingEvent event) {
        if (FailureEventBuilder.isFailureEvent(event)) {
            super.addEventToReportingQueue(event);
        }
    }

    @Override
    public void reportEventQueue(Queue<GobblinTrackingEvent> queue) {
        if (queue.size() > 0) {
            this.setupOutputStream();
            super.reportEventQueue(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupOutputStream() {
        Path path = this.failureLogFile;
        synchronized (path) {
            if (this.hasSetupOutputStream) {
                return;
            }
            try {
                boolean append = false;
                if (this.fs.exists(this.failureLogFile)) {
                    log.info("Failure log file %s already exists, appending to it", (Object)this.failureLogFile);
                    append = true;
                }
                FSDataOutputStream outputStream = append ? this.fs.append(this.failureLogFile) : this.fs.create(this.failureLogFile);
                this.output = (PrintStream)this.closer.register((Closeable)new PrintStream((OutputStream)outputStream, false, Charsets.UTF_8.toString()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.hasSetupOutputStream = true;
            }
        }
    }
}

